/* $Id: GFTrace.java,v 1.2 1999/03/20 13:36:09 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */

package cryptix.ecc;

import java.math.BigInteger;
import java.io.*;

/**
 * Tables for fast trace computation for GF(2<SUP>m</SUP>)
 * 
 * @author  Paulo S. L. M. Barreto <pbarreto@cryptix.org>
 * @author  Jeroen C. van Gelderen <gelderen@cryptix.org>
 */
class GFTrace {

    /**
     * List of exponents d such that Tr(x^d) = 1 in GF(2^m) (P1363)
     */
    static final short[][] tr1363 = {
        /*    0 */ null,
        /*    1 */ null,
        /*    2 */ {1},
        /*    3 */ {0},
        /*    4 */ {3},
        /*    5 */ {0, 3},
        /*    6 */ {5},
        /*    7 */ {0},
        /*    8 */ {5, 7},
        /*    9 */ {0},
        /*   10 */ {7},
        /*   11 */ {0, 9},
        /*   12 */ {9},
        /*   13 */ {0, 9},
        /*   14 */ {9},
        /*   15 */ {0},
        /*   16 */ {11, 13, 15},
        /*   17 */ {0},
        /*   18 */ {15},
        /*   19 */ {0, 17},
        /*   20 */ {17},
        /*   21 */ {0, 19},
        /*   22 */ {21},
        /*   23 */ {0},
        /*   24 */ {21, 23},
        /*   25 */ {0},
        /*   26 */ {23, 25},
        /*   27 */ {0, 25},
        /*   28 */ {27},
        /*   29 */ {0, 27},
        /*   30 */ {29},
        /*   31 */ {0},
        /*   32 */ {25, 29},
        /*   33 */ {0, 23},
        /*   34 */ {27},
        /*   35 */ {0, 33},
        /*   36 */ {27},
        /*   37 */ {0, 31, 33},
        /*   38 */ {33, 37},
        /*   39 */ {0, 35},
        /*   40 */ {35, 37},
        /*   41 */ {0},
        /*   42 */ {35},
        /*   43 */ {0, 37, 39},
        /*   44 */ {39},
        /*   45 */ {0, 41},
        /*   46 */ {45},
        /*   47 */ {0},
        /*   48 */ {43, 45},
        /*   49 */ {0},
        /*   50 */ {47},
        /*   51 */ {0, 45},
        /*   52 */ {49},
        /*   53 */ {0, 47, 51},
        /*   54 */ {45},
        /*   55 */ {0},
        /*   56 */ {3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29},
        /*   57 */ {0, 53},
        /*   58 */ {39},
        /*   59 */ {0, 55, 57},
        /*   60 */ {59},
        /*   61 */ {0, 59},
        /*   62 */ {33},
        /*   63 */ {0},
        /*   64 */ {61, 63},
        /*   65 */ {0, 47},
        /*   66 */ {63},
        /*   67 */ {0, 65},
        /*   68 */ {59},
        /*   69 */ {0, 63, 67},
        /*   70 */ {65, 67, 69},
        /*   71 */ {0, 65},
        /*   72 */ {3, 5, 41},
        /*   73 */ {0},
        /*   74 */ {39},
        /*   75 */ {0, 69},
        /*   76 */ {55},
        /*   77 */ {0, 71, 75},
        /*   78 */ {73, 75},
        /*   79 */ {0},
        /*   80 */ {71},
        /*   81 */ {0, 77},
        /*   82 */ {1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 81},
        /*   83 */ {0, 79, 81},
        /*   84 */ {79},
        /*   85 */ {0, 77, 83},
        /*   86 */ {65},
        /*   87 */ {0},
        /*   88 */ {81},
        /*   89 */ {0, 51},
        /*   90 */ {63},
        /*   91 */ {0, 83},
        /*   92 */ {71},
        /*   93 */ {0, 91},
        /*   94 */ {73},
        /*   95 */ {0},
        /*   96 */ {1, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51},
        /*   97 */ {0, 91},
        /*   98 */ {87},
        /*   99 */ {0, 93},
        /*  100 */ {85},
        /*  101 */ {0, 95},
        /*  102 */ {73},
        /*  103 */ {0},
        /*  104 */ {101, 103},
        /*  105 */ {0, 101},
        /*  106 */ {91},
        /*  107 */ {0, 103},
        /*  108 */ {91},
        /*  109 */ {0, 105, 107},
        /*  110 */ {77},
        /*  111 */ {0, 101},
        /*  112 */ {107, 109},
        /*  113 */ {0},
        /*  114 */ {109, 111},
        /*  115 */ {0, 107},
        /*  116 */ {115},
        /*  117 */ {0, 115},
        /*  118 */ {85},
        /*  119 */ {0, 111},
        /*  120 */ {117, 119},
        /*  121 */ {0, 103},
        /*  122 */ {121},
        /*  123 */ {0, 121},
        /*  124 */ {105},
        /*  125 */ {0, 119},
        /*  126 */ {105},
        /*  127 */ {0},
        /*  128 */ {121, 127},
        /*  129 */ {0},
        /*  130 */ {127},
        /*  131 */ {0, 123, 129},
        /*  132 */ {115},
        /*  133 */ {0, 125, 131},
        /*  134 */ {77},
        /*  135 */ {0},
        /*  136 */ {131, 133},
        /*  137 */ {0},
        /*  138 */ {131, 137},
        /*  139 */ {0, 131},
        /*  140 */ {125},
        /*  141 */ {0, 131, 137},
        /*  142 */ {121},
        /*  143 */ {0, 141},
        /*  144 */ {137},
        /*  145 */ {0, 93},
        /*  146 */ {75},
        /*  147 */ {0, 133},
        /*  148 */ {121},
        /*  149 */ {0, 139},
        /*  150 */ {97},
        /*  151 */ {0},
        /*  152 */ {149},
        /*  153 */ {0},
        /*  154 */ {139},
        /*  155 */ {0, 93},
        /*  156 */ {147},
        /*  157 */ {0, 151, 155},
        /*  158 */ {3, 5, 9, 11, 15, 17, 21, 23, 27, 29, 33, 35, 39, 41, 45, 47, 51, 53, 57, 59, 63, 65, 69, 71, 75, 77, 81, 85, 87, 91, 93, 97, 99, 103, 105, 109, 111, 115, 117, 121, 123, 127, 129, 133, 135, 139, 141, 145, 147, 151, 153, 157},
        /*  159 */ {0},
        /*  160 */ {155, 157},
        /*  161 */ {0, 143},
        /*  162 */ {135},
        /*  163 */ {0, 157},
        /*  164 */ {157},
        /*  165 */ {0, 157},
        /*  166 */ {129},
        /*  167 */ {0, 161},
        /*  168 */ {5, 9, 13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61, 65, 69, 73, 77, 81, 85},
        /*  169 */ {0, 135},
        /*  170 */ {159},
        /*  171 */ {0, 165, 169},
        /*  172 */ {171},
        /*  173 */ {0, 165, 171},
        /*  174 */ {161},
        /*  175 */ {0, 169},
        /*  176 */ {165, 173},
        /*  177 */ {0, 169},
        /*  178 */ {147},
        /*  179 */ {0, 175, 177},
        /*  180 */ {177},
        /*  181 */ {0, 175},
        /*  182 */ {101},
        /*  183 */ {0, 127},
        /*  184 */ {175, 177},
        /*  185 */ {0, 161},
        /*  186 */ {175},
        /*  187 */ {0, 181},
        /*  188 */ {183},
        /*  189 */ {0, 183, 187},
        /*  190 */ {183},
        /*  191 */ {0},
        /*  192 */ {185, 191},
        /*  193 */ {0},
        /*  194 */ {107},
        /*  195 */ {0, 187, 193},
        /*  196 */ {193},
        /*  197 */ {0, 193, 195},
        /*  198 */ {189},
        /*  199 */ {0, 165},
        /*  200 */ {195, 197},
        /*  201 */ {0, 187},
        /*  202 */ {147},
        /*  203 */ {0, 195},
        /*  204 */ {177},
        /*  205 */ {0, 203},
        /*  206 */ {197, 201},
        /*  207 */ {0},
        /*  208 */ {3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 99, 101, 103, 105, 207},
        /*  209 */ {0, 203},
        /*  210 */ {203},
        /*  211 */ {0, 201, 203},
        /*  212 */ {107},
        /*  213 */ {0, 207, 211},
        /*  214 */ {141},
        /*  215 */ {0},
        /*  216 */ {209, 213, 215},
        /*  217 */ {0},
        /*  218 */ {207},
        /*  219 */ {0, 211, 215},
        /*  220 */ {213},
        /*  221 */ {0, 213, 215, 219},
        /*  222 */ {217},
        /*  223 */ {0},
        /*  224 */ {215, 221},
        /*  225 */ {0, 193},
        /*  226 */ {1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 99, 101, 103, 105, 107, 109, 111, 113, 223},
        /*  227 */ {0, 217, 223},
        /*  228 */ {115},
        /*  229 */ {0, 219, 225},
        /*  230 */ {223},
        /*  231 */ {0, 205},
        /*  232 */ {1, 117, 229, 231},
        /*  233 */ {0, 159},
        /*  234 */ {203},
        /*  235 */ {0, 229},
        /*  236 */ {231},
        /*  237 */ {0, 233},
        /*  238 */ {165},
        /*  239 */ {0, 203},
        /*  240 */ {235, 237},
        /*  241 */ {0, 171},
        /*  242 */ {147},
        /*  243 */ {0, 235},
        /*  244 */ {133},
        /*  245 */ {0, 239, 241},
        /*  246 */ {235, 245},
        /*  247 */ {0, 165},
        /*  248 */ {7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 99, 101, 103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129},
        /*  249 */ {0},
        /*  250 */ {147},
        /*  251 */ {0, 247, 249},
        /*  252 */ {237},
        /*  253 */ {0, 207},
        /*  254 */ {247, 253},
        /*  255 */ {0, 203},
        /*  256 */ {251},
        /*  257 */ {0, 245},
        /*  258 */ {187},
        /*  259 */ {0, 249, 253, 257},
        /*  260 */ {245},
        /*  261 */ {0, 255, 257},
        /*  262 */ {253},
        /*  263 */ {0},
        /*  264 */ {255},
        /*  265 */ {0, 223},
        /*  266 */ {219},
        /*  267 */ {0, 259, 261},
        /*  268 */ {243},
        /*  269 */ {0, 263},
        /*  270 */ {217},
        /*  271 */ {0, 213},
        /*  272 */ {263, 269},
        /*  273 */ {0},
        /*  274 */ {207},
        /*  275 */ {0, 265},
        /*  276 */ {213},
        /*  277 */ {0, 265, 271},
        /*  278 */ {273},
        /*  279 */ {0},
        /*  280 */ {271, 275},
        /*  281 */ {0},
        /*  282 */ {247},
        /*  283 */ {0, 271},
        /*  284 */ {231},
        /*  285 */ {0, 275},
        /*  286 */ {217},
        /*  287 */ {0},
        /*  288 */ {277, 287},
        /*  289 */ {0},
        /*  290 */ {285, 287},
        /*  291 */ {0, 279},
        /*  292 */ {255},
        /*  293 */ {0, 287},
        /*  294 */ {261},
        /*  295 */ {0, 247},
        /*  296 */ {289, 293},
        /*  297 */ {0},
        /*  298 */ {287},
        /*  299 */ {0, 293, 295},
        /*  300 */ {295},
        /*  301 */ {0, 299},
        /*  302 */ {261},
        /*  303 */ {0},
        /*  304 */ {293, 303},
        /*  305 */ {0, 203},
        /*  306 */ {299, 303, 305},
        /*  307 */ {0, 299, 303, 305},
        /*  308 */ {293},
        /*  309 */ {0, 299, 303, 305},
        /*  310 */ {217},
        /*  311 */ {0},
        /*  312 */ {303, 305},
        /*  313 */ {0},
        /*  314 */ {299},
        /*  315 */ {0, 305},
        /*  316 */ {253},
        /*  317 */ {0, 313, 315},
        /*  318 */ {273},
        /*  319 */ {0, 283},
        /*  320 */ {317, 319},
        /*  321 */ {0},
        /*  322 */ {255},
        /*  323 */ {0, 313},
        /*  324 */ {273},
        /*  325 */ {0, 315, 323},
        /*  326 */ {323, 325},
        /*  327 */ {0, 293},
        /*  328 */ {325, 327},
        /*  329 */ {0, 279},
        /*  330 */ {231},
        /*  331 */ {0, 321, 325, 329},
        /*  332 */ {243},
        /*  333 */ {0, 331},
        /*  334 */ {329, 333},
        /*  335 */ {0, 325, 333},
        /*  336 */ {329, 335},
        /*  337 */ {0},
        /*  338 */ {335, 337},
        /*  339 */ {0, 323, 329},
        /*  340 */ {295},
        /*  341 */ {0, 331, 333, 335},
        /*  342 */ {217},
        /*  343 */ {0},
        /*  344 */ {337, 343},
        /*  345 */ {0, 323},
        /*  346 */ {283},
        /*  347 */ {0, 337},
        /*  348 */ {245},
        /*  349 */ {0, 343, 347},
        /*  350 */ {297},
        /*  351 */ {0, 317},
        /*  352 */ {339, 341},
        /*  353 */ {0},
        /*  354 */ {255},
        /*  355 */ {0, 349},
        /*  356 */ {347, 349},
        /*  357 */ {0, 347, 355},
        /*  358 */ {301},
        /*  359 */ {0, 291},
        /*  360 */ {355, 357},
        /*  361 */ {0, 357},
        /*  362 */ {299},
        /*  363 */ {0, 355},
        /*  364 */ {355},
        /*  365 */ {0, 359},
        /*  366 */ {337},
        /*  367 */ {0},
        /*  368 */ {361, 365},
        /*  369 */ {0},
        /*  370 */ {231},
        /*  371 */ {0, 363, 369},
        /*  372 */ {261},
        /*  373 */ {0, 365, 371},
        /*  374 */ {369},
        /*  375 */ {0, 359},
        /*  376 */ {369, 371},
        /*  377 */ {0},
        /*  378 */ {335},
        /*  379 */ {0, 369, 371},
        /*  380 */ {333},
        /*  381 */ {0, 379},
        /*  382 */ {301},
        /*  383 */ {0, 293},
        /*  384 */ {381},
        /*  385 */ {0, 379},
        /*  386 */ {303},
        /*  387 */ {0, 379},
        /*  388 */ {229},
        /*  389 */ {0, 379},
        /*  390 */ {381},
        /*  391 */ {0, 363},
        /*  392 */ {3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 99, 101, 103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131, 133, 135, 137, 139, 141, 143, 145, 147, 149, 151, 153, 155, 157, 159, 161, 163, 165, 167, 169, 171, 173, 175, 177, 179, 181, 183, 185, 187, 189, 191, 193, 195, 197},
        /*  393 */ {0},
        /*  394 */ {259},
        /*  395 */ {0, 389},
        /*  396 */ {371},
        /*  397 */ {0, 385, 391},
        /*  398 */ {391},
        /*  399 */ {0, 373},
        /*  400 */ {395, 397},
        /*  401 */ {0, 249},
        /*  402 */ {231},
        /*  403 */ {0, 395},
        /*  404 */ {339},
        /*  405 */ {0, 397, 403},
        /*  406 */ {265},
        /*  407 */ {0},
        /*  408 */ {403, 405},
        /*  409 */ {0},
        /*  410 */ {407},
        /*  411 */ {0, 399, 401},
        /*  412 */ {265},
        /*  413 */ {0, 403, 407},
        /*  414 */ {401},
        /*  415 */ {0, 313},
        /*  416 */ {407, 411},
        /*  417 */ {0},
        /*  418 */ {219},
        /*  419 */ {0, 415},
        /*  420 */ {413},
        /*  421 */ {0, 417, 419},
        /*  422 */ {273},
        /*  423 */ {0},
        /*  424 */ {415, 417},
        /*  425 */ {0, 413},
        /*  426 */ {363},
        /*  427 */ {0, 421},
        /*  428 */ {323},
        /*  429 */ {0, 419, 421},
        /*  430 */ {429},
        /*  431 */ {0, 311},
        /*  432 */ {419, 429},
        /*  433 */ {0},
        /*  434 */ {423, 429},
        /*  435 */ {0, 423},
        /*  436 */ {271},
        /*  437 */ {0, 431, 435},
        /*  438 */ {373},
        /*  439 */ {0},
        /*  440 */ {437, 439},
        /*  441 */ {0},
        /*  442 */ {435, 437},
        /*  443 */ {0, 433, 437},
        /*  444 */ {363},
        /*  445 */ {0, 439, 441},
        /*  446 */ {341},
        /*  447 */ {0},
        /*  448 */ {437},
        /*  449 */ {0, 315},
        /*  450 */ {403},
        /*  451 */ {0, 435, 441},
        /*  452 */ {447},
        /*  453 */ {0, 447, 449},
        /*  454 */ {453},
        /*  455 */ {0, 417},
        /*  456 */ {447},
        /*  457 */ {0, 441},
        /*  458 */ {255},
        /*  459 */ {0, 447, 457},
        /*  460 */ {441},
        /*  461 */ {0, 455},
        /*  462 */ {389},
        /*  463 */ {0},
        /*  464 */ {445, 451},
        /*  465 */ {0},
        /*  466 */ {455},
        /*  467 */ {0, 461},
        /*  468 */ {441},
        /*  469 */ {0, 467},
        /*  470 */ {461},
        /*  471 */ {0},
        /*  472 */ {461, 469},
        /*  473 */ {0, 273},
        /*  474 */ {283},
        /*  475 */ {0, 467, 471},
        /*  476 */ {467},
        /*  477 */ {0, 461},
        /*  478 */ {357},
        /*  479 */ {0, 375},
        /*  480 */ {465, 471},
        /*  481 */ {0, 343},
        /*  482 */ {473, 477},
        /*  483 */ {0, 477, 479},
        /*  484 */ {379},
        /*  485 */ {0, 469, 479},
        /*  486 */ {405},
        /*  487 */ {0, 393},
        /*  488 */ {485, 487},
        /*  489 */ {0},
        /*  490 */ {271},
        /*  491 */ {0, 485},
        /*  492 */ {485},
        /*  493 */ {0, 483},
        /*  494 */ {477},
        /*  495 */ {0, 419},
        /*  496 */ {491},
        /*  497 */ {0, 419},
        /*  498 */ {343},
        /*  499 */ {0, 493},
        /*  500 */ {473},
        /*  501 */ {0, 497, 499},
        /*  502 */ {497},
        /*  503 */ {0},
        /*  504 */ {489},
        /*  505 */ {0, 349},
        /*  506 */ {483},
        /*  507 */ {0, 501},
        /*  508 */ {499},
        /*  509 */ {0, 501},
        /*  510 */ {441},
        /*  511 */ {0, 501},
        /*  512 */ {507},
        /*  513 */ {0, 487},
        /*  514 */ {447},
        /*  515 */ {0, 501, 511},
        /*  516 */ {495},
        /*  517 */ {0, 505, 507, 515},
        /*  518 */ {485},
        /*  519 */ {0},
        /*  520 */ {505, 509},
        /*  521 */ {0, 489},
        /*  522 */ {483},
        /*  523 */ {0, 517, 521},
        /*  524 */ {357},
        /*  525 */ {0, 519, 521},
        /*  526 */ {429},
        /*  527 */ {0},
        /*  528 */ {517},
        /*  529 */ {0, 487},
        /*  530 */ {523, 527},
        /*  531 */ {0, 521, 527},
        /*  532 */ {531},
        /*  533 */ {0, 529, 531},
        /*  534 */ {373},
        /*  535 */ {0, 527, 529, 533},
        /*  536 */ {529, 531, 533},
        /*  537 */ {0, 443},
        /*  538 */ {343},
        /*  539 */ {0, 529, 535},
        /*  540 */ {531},
        /*  541 */ {0, 531, 537},
        /*  542 */ {541},
        /*  543 */ {0, 527},
        /*  544 */ {541, 543},
        /*  545 */ {0, 423},
        /*  546 */ {545},
        /*  547 */ {0, 543},
        /*  548 */ {543, 545},
        /*  549 */ {0, 533, 545},
        /*  550 */ {357},
        /*  551 */ {0},
        /*  552 */ {533, 543},
        /*  553 */ {0},
        /*  554 */ {547},
        /*  555 */ {0, 545, 551},
        /*  556 */ {403},
        /*  557 */ {0, 551},
        /*  558 */ {485},
        /*  559 */ {0, 525},
        /*  560 */ {549, 551},
        /*  561 */ {0},
        /*  562 */ {551},
        /*  563 */ {0, 549},
        /*  564 */ {401},
        /*  565 */ {0, 559},
        /*  566 */ {413},
        /*  567 */ {0, 539},
        /*  568 */ {553, 561},
        /*  569 */ {0},
        /*  570 */ {503},
        /*  571 */ {0, 561, 569},
        /*  572 */ {571},
        /*  573 */ {0, 563, 567, 569},
        /*  574 */ {561},
        /*  575 */ {0, 429},
        /*  576 */ {563, 573},
        /*  577 */ {0},
        /*  578 */ {555},
        /*  579 */ {0, 567},
        /*  580 */ {343},
        /*  581 */ {0, 575},
        /*  582 */ {497},
        /*  583 */ {0, 453},
        /*  584 */ {571, 581},
        /*  585 */ {0, 497},
        /*  586 */ {579, 581},
        /*  587 */ {0, 581},
        /*  588 */ {553},
        /*  589 */ {0, 579, 585},
        /*  590 */ {497},
        /*  591 */ {0, 585, 587},
        /*  592 */ {579, 589},
        /*  593 */ {0, 507},
        /*  594 */ {575},
        /*  595 */ {0, 593},
        /*  596 */ {323},
        /*  597 */ {0, 583, 585},
        /*  598 */ {591, 597},
        /*  599 */ {0, 569},
        /*  600 */ {591, 595},
        /*  601 */ {0},
        /*  602 */ {387},
        /*  603 */ {0, 597, 599},
        /*  604 */ {499},
        /*  605 */ {0, 595},
        /*  606 */ {441},
        /*  607 */ {0},
        /*  608 */ {589, 595},
        /*  609 */ {0},
        /*  610 */ {483},
        /*  611 */ {0, 601, 607, 609},
        /*  612 */ {531},
        /*  613 */ {0, 603, 609},
        /*  614 */ {569},
        /*  615 */ {0},
        /*  616 */ {597, 613},
        /*  617 */ {0, 417},
        /*  618 */ {323},
        /*  619 */ {0, 611},
        /*  620 */ {611},
        /*  621 */ {0, 609, 615},
        /*  622 */ {325},
        /*  623 */ {0, 555},
        /*  624 */ {613, 619},
        /*  625 */ {0},
        /*  626 */ {375},
        /*  627 */ {0, 619, 623},
        /*  628 */ {405},
        /*  629 */ {0, 623, 627},
        /*  630 */ {623},
        /*  631 */ {0},
        /*  632 */ {623, 631},
        /*  633 */ {0},
        /*  634 */ {595},
        /*  635 */ {0, 621, 625, 631},
        /*  636 */ {419},
        /*  637 */ {0, 623},
        /*  638 */ {633, 637},
        /*  639 */ {0, 623},
        /*  640 */ {637},
        /*  641 */ {0},
        /*  642 */ {523},
        /*  643 */ {0, 641},
        /*  644 */ {633, 639},
        /*  645 */ {0, 637, 641},
        /*  646 */ {397},
        /*  647 */ {0},
        /*  648 */ {635, 645, 647},
        /*  649 */ {0},
        /*  650 */ {647},
        /*  651 */ {0, 637},
        /*  652 */ {559},
        /*  653 */ {0, 643, 645},
        /*  654 */ {621},
        /*  655 */ {0, 567},
        /*  656 */ {649, 651},
        /*  657 */ {0, 619},
        /*  658 */ {603},
        /*  659 */ {0, 655, 657},
        /*  660 */ {649},
        /*  661 */ {0, 649, 657},
        /*  662 */ {641},
        /*  663 */ {0},
        /*  664 */ {653, 655},
        /*  665 */ {0},
        /*  666 */ {659},
        /*  667 */ {0, 649},
        /*  668 */ {521},
        /*  669 */ {0, 665, 667},
        /*  670 */ {517},
        /*  671 */ {0},
        /*  672 */ {661, 667},
        /*  673 */ {0, 645},
        /*  674 */ {663, 667},
        /*  675 */ {0, 669},
        /*  676 */ {645},
        /*  677 */ {0, 669, 673},
        /*  678 */ {663, 673, 675},
        /*  679 */ {0, 613},
        /*  680 */ {657, 671},
        /*  681 */ {0},
        /*  682 */ {511},
        /*  683 */ {0, 677},
        /*  684 */ {475},
        /*  685 */ {0, 681},
        /*  686 */ {489},
        /*  687 */ {0},
        /*  688 */ {669},
        /*  689 */ {0, 675},
        /*  690 */ {611},
        /*  691 */ {0, 685, 689},
        /*  692 */ {393},
        /*  693 */ {0, 685, 691},
        /*  694 */ {525},
        /*  695 */ {0},
        /*  696 */ {673},
        /*  697 */ {0},
        /*  698 */ {483},
        /*  699 */ {0, 689},
        /*  700 */ {625},
        /*  701 */ {0, 685, 697, 699},
        /*  702 */ {665},
        /*  703 */ {0, 691},
        /*  704 */ {701},
        /*  705 */ {0},
        /*  706 */ {695},
        /*  707 */ {0, 699},
        /*  708 */ {693},
        /*  709 */ {0, 705},
        /*  710 */ {697},
        /*  711 */ {0, 619},
        /*  712 */ {707, 709},
        /*  713 */ {0},
        /*  714 */ {691},
        /*  715 */ {0, 711},
        /*  716 */ {533},
        /*  717 */ {0, 701},
        /*  718 */ {553},
        /*  719 */ {0, 569},
        /*  720 */ {711},
        /*  721 */ {0},
        /*  722 */ {491},
        /*  723 */ {0, 707, 713, 719},
        /*  724 */ {517},
        /*  725 */ {0, 719},
        /*  726 */ {721},
        /*  727 */ {0, 547},
        /*  728 */ {725},
        /*  729 */ {0, 671},
        /*  730 */ {583},
        /*  731 */ {0, 723, 725, 729},
        /*  732 */ {389},
        /*  733 */ {0, 725, 731},
        /*  734 */ {723, 733},
        /*  735 */ {0, 691},
        /*  736 */ {723},
        /*  737 */ {0},
        /*  738 */ {391},
        /*  739 */ {0, 721, 723, 731},
        /*  740 */ {605},
        /*  741 */ {0, 733},
        /*  742 */ {657},
        /*  743 */ {0, 653},
        /*  744 */ {731, 733, 743},
        /*  745 */ {0, 487},
        /*  746 */ {395},
        /*  747 */ {0, 737, 741, 743},
        /*  748 */ {729},
        /*  749 */ {0, 743},
        /*  750 */ {441},
        /*  751 */ {0, 733},
        /*  752 */ {739, 749},
        /*  753 */ {0, 595},
        /*  754 */ {735},
        /*  755 */ {0, 743, 745},
        /*  756 */ {711},
        /*  757 */ {0, 751},
        /*  758 */ {525},
        /*  759 */ {0, 661},
        /*  760 */ {749, 755},
        /*  761 */ {0},
        /*  762 */ {679},
        /*  763 */ {0, 747, 749},
        /*  764 */ {759, 761},
        /*  765 */ {0, 761},
        /*  766 */ {747, 757},
        /*  767 */ {0, 599},
        /*  768 */ {749, 751},
        /*  769 */ {0, 649},
        /*  770 */ {765},
        /*  771 */ {0, 765},
        /*  772 */ {765},
        /*  773 */ {0, 763, 765, 767},
        /*  774 */ {589},
        /*  775 */ {0},
        /*  776 */ {761, 769},
        /*  777 */ {0},
        /*  778 */ {403},
        /*  779 */ {0, 769, 771},
        /*  780 */ {767},
        /*  781 */ {0, 765, 779},
        /*  782 */ {453},
        /*  783 */ {0, 715},
        /*  784 */ {771, 775},
        /*  785 */ {0, 693},
        /*  786 */ {783},
        /*  787 */ {0, 781},
        /*  788 */ {771, 785},
        /*  789 */ {0, 787},
        /*  790 */ {781, 789},
        /*  791 */ {0, 761},
        /*  792 */ {783, 785, 789},
        /*  793 */ {0},
        /*  794 */ {651},
        /*  795 */ {0, 791},
        /*  796 */ {787, 795},
        /*  797 */ {0, 785, 787, 793},
        /*  798 */ {745},
        /*  799 */ {0},
        /*  800 */ {791, 793, 799},
        /*  801 */ {0},
        /*  802 */ {787, 789, 793},
        /*  803 */ {0, 789, 801},
        /*  804 */ {729},
        /*  805 */ {0, 797, 803},
        /*  806 */ {785},
        /*  807 */ {0},
        /*  808 */ {805},
        /*  809 */ {0},
        /*  810 */ {651},
        /*  811 */ {0, 799, 801, 803},
        /*  812 */ {783},
        /*  813 */ {0, 803},
        /*  814 */ {793},
        /*  815 */ {0},
        /*  816 */ {805},
        /*  817 */ {0, 765},
        /*  818 */ {699},
        /*  819 */ {0, 803},
        /*  820 */ {697},
        /*  821 */ {0, 819},
        /*  822 */ {805},
        /*  823 */ {0},
        /*  824 */ {813},
        /*  825 */ {0, 787},
        /*  826 */ {571},
        /*  827 */ {0, 815, 817},
        /*  828 */ {639},
        /*  829 */ {0, 825},
        /*  830 */ {813, 823},
        /*  831 */ {0},
        /*  832 */ {819, 827},
        /*  833 */ {0},
        /*  834 */ {819},
        /*  835 */ {0, 821},
        /*  836 */ {827},
        /*  837 */ {0, 829, 831},
        /*  838 */ {777},
        /*  839 */ {0, 785},
        /*  840 */ {829, 835, 839},
        /*  841 */ {0, 697},
        /*  842 */ {795},
        /*  843 */ {0, 833},
        /*  844 */ {739},
        /*  845 */ {0, 843},
        /*  846 */ {741},
        /*  847 */ {0, 711},
        /*  848 */ {837, 847},
        /*  849 */ {0},
        /*  850 */ {739},
        /*  851 */ {0, 841},
        /*  852 */ {693},
        /*  853 */ {0, 843},
        /*  854 */ {847, 849, 851},
        /*  855 */ {0},
        /*  856 */ {837, 853},
        /*  857 */ {0},
        /*  858 */ {651},
        /*  859 */ {0, 855},
        /*  860 */ {825},
        /*  861 */ {0, 847},
        /*  862 */ {513},
        /*  863 */ {0, 857, 861},
        /*  864 */ {843},
        /*  865 */ {0},
        /*  866 */ {791},
        /*  867 */ {0, 865},
        /*  868 */ {723},
        /*  869 */ {0, 863},
        /*  870 */ {569},
        /*  871 */ {0, 493},
        /*  872 */ {859, 869, 871},
        /*  873 */ {0, 521},
        /*  874 */ {867},
        /*  875 */ {0, 863, 867},
        /*  876 */ {727},
        /*  877 */ {0, 871, 873},
        /*  878 */ {869},
        /*  879 */ {0},
        /*  880 */ {865, 873, 875},
        /*  881 */ {0, 803},
        /*  882 */ {783},
        /*  883 */ {0, 867, 871},
        /*  884 */ {711},
        /*  885 */ {0, 877},
        /*  886 */ {873, 877},
        /*  887 */ {0},
        /*  888 */ {869},
        /*  889 */ {0},
        /*  890 */ {707},
        /*  891 */ {0, 879, 887},
        /*  892 */ {861},
        /*  893 */ {0, 885, 887},
        /*  894 */ {721},
        /*  895 */ {0, 883},
        /*  896 */ {889, 891, 893},
        /*  897 */ {0},
        /*  898 */ {691},
        /*  899 */ {0, 881},
        /*  900 */ {899},
        /*  901 */ {0, 895},
        /*  902 */ {881},
        /*  903 */ {0},
        /*  904 */ {897},
        /*  905 */ {0},
        /*  906 */ {783},
        /*  907 */ {0, 895, 897, 905},
        /*  908 */ {765},
        /*  909 */ {0, 895, 905},
        /*  910 */ {895, 901, 903},
        /*  911 */ {0, 707},
        /*  912 */ {905, 907, 911},
        /*  913 */ {0},
        /*  914 */ {913},
        /*  915 */ {0, 907, 909},
        /*  916 */ {733},
        /*  917 */ {0, 905, 907},
        /*  918 */ {841},
        /*  919 */ {0, 883},
        /*  920 */ {911},
        /*  921 */ {0},
        /*  922 */ {915, 917},
        /*  923 */ {0, 907, 909},
        /*  924 */ {893},
        /*  925 */ {0, 909},
        /*  926 */ {561},
        /*  927 */ {0},
        /*  928 */ {925},
        /*  929 */ {0, 925},
        /*  930 */ {899},
        /*  931 */ {0, 921, 927},
        /*  932 */ {755},
        /*  933 */ {0, 917, 927},
        /*  934 */ {929},
        /*  935 */ {0},
        /*  936 */ {921, 923},
        /*  937 */ {0},
        /*  938 */ {731},
        /*  939 */ {0, 935},
        /*  940 */ {933, 939},
        /*  941 */ {0, 935},
        /*  942 */ {897},
        /*  943 */ {0, 919},
        /*  944 */ {933, 935},
        /*  945 */ {0},
        /*  946 */ {925, 933},
        /*  947 */ {0, 941},
        /*  948 */ {759},
        /*  949 */ {0, 941, 947},
        /*  950 */ {937},
        /*  951 */ {0, 691},
        /*  952 */ {943, 945},
        /*  953 */ {0, 785},
        /*  954 */ {823},
        /*  955 */ {0, 949},
        /*  956 */ {651},
        /*  957 */ {0, 947, 951},
        /*  958 */ {945, 949},
        /*  959 */ {0},
        /*  960 */ {951, 957},
        /*  961 */ {0, 943},
        /*  962 */ {947, 957},
        /*  963 */ {0, 943, 957},
        /*  964 */ {861},
        /*  965 */ {0, 961, 963},
        /*  966 */ {765},
        /*  967 */ {0, 931},
        /*  968 */ {959, 963},
        /*  969 */ {0},
        /*  970 */ {959, 963},
        /*  971 */ {0, 965, 969},
        /*  972 */ {965},
        /*  973 */ {0, 967, 969},
        /*  974 */ {965, 967},
        /*  975 */ {0},
        /*  976 */ {959},
        /*  977 */ {0},
        /*  978 */ {969, 975, 977},
        /*  979 */ {0, 801},
        /*  980 */ {973},
        /*  981 */ {0, 969, 975},
        /*  982 */ {805},
        /*  983 */ {0, 753},
        /*  984 */ {975, 981},
        /*  985 */ {0, 763},
        /*  986 */ {983},
        /*  987 */ {0, 971, 975},
        /*  988 */ {867},
        /*  989 */ {0, 979, 985, 987},
        /*  990 */ {829},
        /*  991 */ {0},
        /*  992 */ {975, 977, 979},
        /*  993 */ {0, 931},
        /*  994 */ {771},
        /*  995 */ {0, 983, 993},
        /*  996 */ {931},
        /*  997 */ {0, 985, 991},
        /*  998 */ {897},
        /*  999 */ {0},
        /* 1000 */ {995, 997},
    };

    /**
     * List of exponents d such that Tr(x^d) = 1 in GF(2^m) (X9.F1)
     */
    static final short[][] trX9F1 = {
        /*    0 */ null,
        /*    1 */ null,
        /*    2 */ null,
        /*    3 */ null,
        /*    4 */ null,
        /*    5 */ null,
        /*    6 */ null,
        /*    7 */ null,
        /*    8 */ null,
        /*    9 */ null,
        /*   10 */ null,
        /*   11 */ null,
        /*   12 */ null,
        /*   13 */ null,
        /*   14 */ null,
        /*   15 */ null,
        /*   16 */ null,
        /*   17 */ null,
        /*   18 */ null,
        /*   19 */ null,
        /*   20 */ null,
        /*   21 */ null,
        /*   22 */ null,
        /*   23 */ null,
        /*   24 */ null,
        /*   25 */ null,
        /*   26 */ null,
        /*   27 */ null,
        /*   28 */ null,
        /*   29 */ null,
        /*   30 */ null,
        /*   31 */ null,
        /*   32 */ null,
        /*   33 */ null,
        /*   34 */ null,
        /*   35 */ null,
        /*   36 */ null,
        /*   37 */ null,
        /*   38 */ null,
        /*   39 */ null,
        /*   40 */ null,
        /*   41 */ null,
        /*   42 */ null,
        /*   43 */ null,
        /*   44 */ null,
        /*   45 */ null,
        /*   46 */ null,
        /*   47 */ null,
        /*   48 */ null,
        /*   49 */ null,
        /*   50 */ null,
        /*   51 */ null,
        /*   52 */ null,
        /*   53 */ null,
        /*   54 */ null,
        /*   55 */ null,
        /*   56 */ null,
        /*   57 */ null,
        /*   58 */ null,
        /*   59 */ null,
        /*   60 */ null,
        /*   61 */ null,
        /*   62 */ null,
        /*   63 */ null,
        /*   64 */ null,
        /*   65 */ null,
        /*   66 */ null,
        /*   67 */ null,
        /*   68 */ null,
        /*   69 */ null,
        /*   70 */ null,
        /*   71 */ null,
        /*   72 */ null,
        /*   73 */ null,
        /*   74 */ null,
        /*   75 */ null,
        /*   76 */ null,
        /*   77 */ null,
        /*   78 */ null,
        /*   79 */ null,
        /*   80 */ null,
        /*   81 */ null,
        /*   82 */ null,
        /*   83 */ null,
        /*   84 */ null,
        /*   85 */ null,
        /*   86 */ null,
        /*   87 */ null,
        /*   88 */ null,
        /*   89 */ null,
        /*   90 */ null,
        /*   91 */ null,
        /*   92 */ null,
        /*   93 */ null,
        /*   94 */ null,
        /*   95 */ null,
        /*   96 */ null,
        /*   97 */ null,
        /*   98 */ null,
        /*   99 */ null,
        /*  100 */ null,
        /*  101 */ null,
        /*  102 */ null,
        /*  103 */ null,
        /*  104 */ null,
        /*  105 */ null,
        /*  106 */ null,
        /*  107 */ null,
        /*  108 */ null,
        /*  109 */ null,
        /*  110 */ null,
        /*  111 */ null,
        /*  112 */ null,
        /*  113 */ null,
        /*  114 */ null,
        /*  115 */ null,
        /*  116 */ null,
        /*  117 */ null,
        /*  118 */ null,
        /*  119 */ null,
        /*  120 */ null,
        /*  121 */ null,
        /*  122 */ null,
        /*  123 */ null,
        /*  124 */ null,
        /*  125 */ null,
        /*  126 */ null,
        /*  127 */ null,
        /*  128 */ null,
        /*  129 */ null,
        /*  130 */ null,
        /*  131 */ null,
        /*  132 */ null,
        /*  133 */ null,
        /*  134 */ null,
        /*  135 */ null,
        /*  136 */ null,
        /*  137 */ null,
        /*  138 */ null,
        /*  139 */ null,
        /*  140 */ null,
        /*  141 */ null,
        /*  142 */ null,
        /*  143 */ null,
        /*  144 */ null,
        /*  145 */ null,
        /*  146 */ null,
        /*  147 */ null,
        /*  148 */ null,
        /*  149 */ null,
        /*  150 */ null,
        /*  151 */ null,
        /*  152 */ null,
        /*  153 */ null,
        /*  154 */ null,
        /*  155 */ null,
        /*  156 */ null,
        /*  157 */ null,
        /*  158 */ null,
        /*  159 */ null,
        /*  160 */ {43, 86, 129, 159},
        /*  161 */ {0, 143},
        /*  162 */ {135},
        /*  163 */ {0, 155, 161},
        /*  164 */ {115, 163},
        /*  165 */ {0, 163},
        /*  166 */ {129},
        /*  167 */ {0, 161},
        /*  168 */ {103, 167},
        /*  169 */ {0, 135},
        /*  170 */ {159},
        /*  171 */ {0, 129},
        /*  172 */ {171},
        /*  173 */ {0, 163, 171},
        /*  174 */ {161},
        /*  175 */ {0, 169},
        /*  176 */ {133, 175},
        /*  177 */ {0, 169},
        /*  178 */ {147},
        /*  179 */ {0, 175, 177},
        /*  180 */ {177},
        /*  181 */ {0, 179},
        /*  182 */ {101},
        /*  183 */ {0, 127},
        /*  184 */ {103, 183},
        /*  185 */ {0, 161},
        /*  186 */ {175},
        /*  187 */ {0, 167, 185},
        /*  188 */ {187},
        /*  189 */ {0, 187},
        /*  190 */ {143, 189},
        /*  191 */ {0},
        /*  192 */ {185, 191},
        /*  193 */ {0},
        /*  194 */ {107},
        /*  195 */ {0, 193},
        /*  196 */ {193},
        /*  197 */ {0, 195},
        /*  198 */ {189},
        /*  199 */ {0, 165},
        /*  200 */ {119, 199},
        /*  201 */ {0, 187},
        /*  202 */ {147},
        /*  203 */ {0, 201},
        /*  204 */ {177},
        /*  205 */ {0, 203},
        /*  206 */ {143, 205},
        /*  207 */ {0},
        /*  208 */ {125, 207},
        /*  209 */ {0, 203},
        /*  210 */ {203},
        /*  211 */ {0, 209},
        /*  212 */ {107},
        /*  213 */ {0, 151, 211},
        /*  214 */ {141},
        /*  215 */ {0},
        /*  216 */ {109, 215},
        /*  217 */ {0},
        /*  218 */ {207},
        /*  219 */ {0, 217},
        /*  220 */ {213},
        /*  221 */ {0, 203, 219},
        /*  222 */ {149, 221},
        /*  223 */ {0},
        /*  224 */ {65, 130, 195, 223},
        /*  225 */ {0, 193},
        /*  226 */ {225},
        /*  227 */ {0, 225},
        /*  228 */ {115},
        /*  229 */ {0, 227},
        /*  230 */ {217, 229},
        /*  231 */ {0, 205},
        /*  232 */ {209, 231},
        /*  233 */ {0, 159},
        /*  234 */ {203},
        /*  235 */ {0, 233},
        /*  236 */ {231},
        /*  237 */ {0, 133, 235},
        /*  238 */ {165},
        /*  239 */ {0, 203},
        /*  240 */ {191, 237, 239},
        /*  241 */ {0, 171},
        /*  242 */ {147},
        /*  243 */ {0, 241},
        /*  244 */ {133},
        /*  245 */ {0, 243},
        /*  246 */ {235, 245},
        /*  247 */ {0, 165},
        /*  248 */ {5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 105, 110, 115, 120, 125, 130, 135, 140, 145, 150, 155, 160, 165, 170, 175, 180, 185, 190, 195, 200, 205, 210, 215, 220, 225, 230, 235, 240, 245, 247},
        /*  249 */ {0},
        /*  250 */ {147},
        /*  251 */ {0, 249},
        /*  252 */ {237},
        /*  253 */ {0, 207},
        /*  254 */ {247, 253},
        /*  255 */ {0, 203},
        /*  256 */ {101, 202, 255},
        /*  257 */ {0, 245},
        /*  258 */ {187},
        /*  259 */ {0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 105, 110, 115, 120, 125, 130, 135, 140, 145, 150, 155, 160, 165, 170, 175, 180, 185, 190, 195, 200, 205, 210, 215, 220, 225, 230, 235, 240, 245, 250, 255, 257},
        /*  260 */ {245},
        /*  261 */ {0, 187, 259},
        /*  262 */ {55, 110, 165, 220, 261},
        /*  263 */ {0},
        /*  264 */ {95, 190, 263},
        /*  265 */ {0, 223},
        /*  266 */ {219},
        /*  267 */ {0, 265},
        /*  268 */ {243},
        /*  269 */ {0, 267},
        /*  270 */ {217},
        /*  271 */ {0, 213},
        /*  272 */ {269, 271},
        /*  273 */ {0},
        /*  274 */ {207},
        /*  275 */ {0, 247, 273},
        /*  276 */ {213},
        /*  277 */ {0, 275},
        /*  278 */ {273},
        /*  279 */ {0},
        /*  280 */ {167, 279},
        /*  281 */ {0},
        /*  282 */ {247},
        /*  283 */ {0, 83, 166, 249, 281},
        /*  284 */ {231},
        /*  285 */ {0, 283},
        /*  286 */ {217},
        /*  287 */ {0},
        /*  288 */ {97, 194, 287},
        /*  289 */ {0},
        /*  290 */ {289},
        /*  291 */ {0, 215, 289},
        /*  292 */ {255},
        /*  293 */ {0, 139, 278},
        /*  294 */ {261},
        /*  295 */ {0, 247},
        /*  296 */ {173, 295},
        /*  297 */ {0},
        /*  298 */ {297},
        /*  299 */ {0, 297},
        /*  300 */ {295},
        /*  301 */ {0, 275, 299},
        /*  302 */ {261},
        /*  303 */ {0},
        /*  304 */ {293, 303},
        /*  305 */ {0, 203},
        /*  306 */ {305},
        /*  307 */ {0, 305},
        /*  308 */ {293},
        /*  309 */ {0, 283, 307},
        /*  310 */ {217},
        /*  311 */ {0},
        /*  312 */ {229, 311},
        /*  313 */ {0},
        /*  314 */ {299},
        /*  315 */ {0, 173, 313},
        /*  316 */ {253},
        /*  317 */ {0, 249},
        /*  318 */ {273},
        /*  319 */ {0, 283},
        /*  320 */ {313, 319},
        /*  321 */ {0},
        /*  322 */ {255},
        /*  323 */ {0, 321},
        /*  324 */ {273},
        /*  325 */ {0, 323},
        /*  326 */ {259, 325},
        /*  327 */ {0, 293},
        /*  328 */ {277, 327},
        /*  329 */ {0, 279},
        /*  330 */ {231},
        /*  331 */ {0, 197, 329},
        /*  332 */ {243},
        /*  333 */ {0, 331},
        /*  334 */ {329, 333},
        /*  335 */ {0, 85, 170, 255, 333},
        /*  336 */ {259, 335},
        /*  337 */ {0},
        /*  338 */ {337},
        /*  339 */ {0, 313, 337},
        /*  340 */ {295},
        /*  341 */ {0, 339},
        /*  342 */ {217},
        /*  343 */ {0},
        /*  344 */ {337, 343},
        /*  345 */ {0, 323},
        /*  346 */ {283},
        /*  347 */ {0, 251, 345},
        /*  348 */ {245},
        /*  349 */ {0, 163, 326, 347},
        /*  350 */ {297},
        /*  351 */ {0, 317},
        /*  352 */ {89, 178, 267, 351},
        /*  353 */ {0},
        /*  354 */ {255},
        /*  355 */ {0, 217, 353},
        /*  356 */ {287, 355},
        /*  357 */ {0, 329, 355},
        /*  358 */ {301},
        /*  359 */ {0, 291},
        /*  360 */ {311, 359},
        /*  361 */ {0, 317, 359},
        /*  362 */ {299},
        /*  363 */ {0, 325, 361},
        /*  364 */ {355},
        /*  365 */ {0, 363},
        /*  366 */ {337},
        /*  367 */ {0},
        /*  368 */ {283, 367},
        /*  369 */ {0},
        /*  370 */ {231},
        /*  371 */ {0, 215, 369},
        /*  372 */ {261},
        /*  373 */ {0, 201},
        /*  374 */ {265, 373},
        /*  375 */ {0, 359},
        /*  376 */ {299, 375},
        /*  377 */ {0},
        /*  378 */ {335},
        /*  379 */ {0, 157, 314, 377},
        /*  380 */ {333},
        /*  381 */ {0, 379},
        /*  382 */ {301},
        /*  383 */ {0, 293},
        /*  384 */ {85, 170, 255, 340, 383},
        /*  385 */ {0, 379},
        /*  386 */ {303},
        /*  387 */ {0, 241, 385},
        /*  388 */ {229},
        /*  389 */ {0, 387},
        /*  390 */ {381},
        /*  391 */ {0, 363},
        /*  392 */ {247, 391},
        /*  393 */ {0},
        /*  394 */ {259},
        /*  395 */ {0, 393},
        /*  396 */ {371},
        /*  397 */ {0, 395},
        /*  398 */ {375, 395, 397},
        /*  399 */ {0, 373},
        /*  400 */ {155, 310, 399},
        /*  401 */ {0, 249},
        /*  402 */ {231},
        /*  403 */ {0, 323, 401},
        /*  404 */ {339},
        /*  405 */ {0, 367, 403},
        /*  406 */ {265},
        /*  407 */ {0},
        /*  408 */ {85, 170, 255, 340, 407},
        /*  409 */ {0},
        /*  410 */ {409},
        /*  411 */ {0, 361, 409},
        /*  412 */ {265},
        /*  413 */ {0, 411},
        /*  414 */ {401},
        /*  415 */ {0, 313},
        /*  416 */ {413, 415},
        /*  417 */ {0},
        /*  418 */ {219},
        /*  419 */ {0, 417},
        /*  420 */ {413},
        /*  421 */ {0, 419},
        /*  422 */ {273},
        /*  423 */ {0},
        /*  424 */ {247, 423},
        /*  425 */ {0, 413},
        /*  426 */ {363},
        /*  427 */ {0, 425},
        /*  428 */ {323},
        /*  429 */ {0, 415, 427},
        /*  430 */ {167, 334, 429},
        /*  431 */ {0, 311},
        /*  432 */ {329, 431},
        /*  433 */ {0},
        /*  434 */ {433},
        /*  435 */ {0, 269, 433},
        /*  436 */ {271},
        /*  437 */ {0, 431, 435},
        /*  438 */ {373},
        /*  439 */ {0},
        /*  440 */ {403, 439},
        /*  441 */ {0},
        /*  442 */ {441},
        /*  443 */ {0, 441},
        /*  444 */ {363},
        /*  445 */ {0, 443},
        /*  446 */ {341},
        /*  447 */ {0},
        /*  448 */ {365, 445, 447},
        /*  449 */ {0, 315},
        /*  450 */ {403},
        /*  451 */ {0, 449},
        /*  452 */ {451},
        /*  453 */ {0, 365, 451},
        /*  454 */ {259, 453},
        /*  455 */ {0, 417},
        /*  456 */ {181, 362, 455},
        /*  457 */ {0, 441},
        /*  458 */ {255},
        /*  459 */ {0, 127, 254, 381, 457},
        /*  460 */ {441},
        /*  461 */ {0, 459},
        /*  462 */ {389},
        /*  463 */ {0},
        /*  464 */ {463},
        /*  465 */ {0},
        /*  466 */ {465},
        /*  467 */ {0, 257, 465},
        /*  468 */ {441},
        /*  469 */ {0, 467},
        /*  470 */ {461},
        /*  471 */ {0},
        /*  472 */ {439, 471},
        /*  473 */ {0, 273},
        /*  474 */ {283},
        /*  475 */ {0, 407, 473},
        /*  476 */ {467},
        /*  477 */ {0, 475},
        /*  478 */ {357},
        /*  479 */ {0, 375},
        /*  480 */ {331, 479},
        /*  481 */ {0, 343},
        /*  482 */ {469, 481},
        /*  483 */ {0, 131, 262, 393, 481},
        /*  484 */ {379},
        /*  485 */ {0, 415, 483},
        /*  486 */ {405},
        /*  487 */ {0, 393},
        /*  488 */ {365, 487},
        /*  489 */ {0},
        /*  490 */ {271},
        /*  491 */ {0, 221, 442, 489},
        /*  492 */ {485},
        /*  493 */ {0, 491},
        /*  494 */ {477},
        /*  495 */ {0, 419},
        /*  496 */ {493, 495},
        /*  497 */ {0, 419},
        /*  498 */ {343},
        /*  499 */ {0, 325, 497},
        /*  500 */ {473},
        /*  501 */ {0, 169, 338, 499},
        /*  502 */ {403, 501},
        /*  503 */ {0},
        /*  504 */ {501, 503},
        /*  505 */ {0, 349},
        /*  506 */ {483},
        /*  507 */ {0, 481, 505},
        /*  508 */ {499},
        /*  509 */ {0, 415, 507},
        /*  510 */ {441},
        /*  511 */ {0, 501},
        /*  512 */ {461, 511},
        /*  513 */ {0, 487},
        /*  514 */ {447},
        /*  515 */ {0, 513},
        /*  516 */ {495},
        /*  517 */ {0, 515},
        /*  518 */ {485},
        /*  519 */ {0},
        /*  520 */ {229, 458, 519},
        /*  521 */ {0, 489},
        /*  522 */ {483},
        /*  523 */ {0, 457, 521},
        /*  524 */ {357},
        /*  525 */ {0, 433, 523},
        /*  526 */ {429},
        /*  527 */ {0},
        /*  528 */ {493, 527},
        /*  529 */ {0, 487},
        /*  530 */ {505, 529},
        /*  531 */ {0, 529},
        /*  532 */ {531},
        /*  533 */ {0, 531},
        /*  534 */ {373},
        /*  535 */ {0, 533},
        /*  536 */ {371, 535},
        /*  537 */ {0, 443},
        /*  538 */ {343},
        /*  539 */ {0, 537},
        /*  540 */ {531},
        /*  541 */ {0, 505, 539},
        /*  542 */ {539, 541},
        /*  543 */ {0, 527},
        /*  544 */ {457, 543},
        /*  545 */ {0, 423},
        /*  546 */ {545},
        /*  547 */ {0, 545},
        /*  548 */ {163, 326, 489, 547},
        /*  549 */ {0, 275},
        /*  550 */ {357},
        /*  551 */ {0},
        /*  552 */ {511, 551},
        /*  553 */ {0},
        /*  554 */ {553},
        /*  555 */ {0, 229, 458, 553},
        /*  556 */ {403},
        /*  557 */ {0, 269, 538, 555},
        /*  558 */ {485},
        /*  559 */ {0, 525},
        /*  560 */ {403, 559},
        /*  561 */ {0},
        /*  562 */ {561},
        /*  563 */ {0, 559},
        /*  564 */ {401},
        /*  565 */ {0, 499, 563},
        /*  566 */ {413},
        /*  567 */ {0, 539},
        /*  568 */ {277, 554, 567},
        /*  569 */ {0},
        /*  570 */ {503},
        /*  571 */ {0, 163, 326, 489, 569},
        /*  572 */ {571},
        /*  573 */ {0, 353, 571},
        /*  574 */ {561},
        /*  575 */ {0, 429},
        /*  576 */ {573, 575},
        /*  577 */ {0},
        /*  578 */ {577},
        /*  579 */ {0, 53, 106, 159, 212, 265, 318, 371, 424, 477, 530},
        /*  580 */ {343},
        /*  581 */ {0, 443, 579},
        /*  582 */ {497},
        /*  583 */ {0, 453},
        /*  584 */ {223, 446, 583},
        /*  585 */ {0, 497},
        /*  586 */ {585},
        /*  587 */ {0, 457, 585},
        /*  588 */ {553},
        /*  589 */ {0, 587},
        /*  590 */ {497},
        /*  591 */ {0, 553, 589},
        /*  592 */ {449, 591},
        /*  593 */ {0, 507},
        /*  594 */ {575},
        /*  595 */ {0, 593},
        /*  596 */ {323},
        /*  597 */ {0, 533, 595},
        /*  598 */ {467, 597},
        /*  599 */ {0, 569},
        /*  600 */ {361, 599},
        /*  601 */ {0},
        /*  602 */ {387},
        /*  603 */ {0, 157, 314, 471, 601},
        /*  604 */ {499},
        /*  605 */ {0, 293, 586, 603},
        /*  606 */ {441},
        /*  607 */ {0},
        /*  608 */ {395, 607},
        /*  609 */ {0},
        /*  610 */ {483},
        /*  611 */ {0, 609},
        /*  612 */ {531},
        /*  613 */ {0, 611},
        /*  614 */ {569},
        /*  615 */ {0},
        /*  616 */ {151, 302, 453, 604, 615},
        /*  617 */ {0, 417},
        /*  618 */ {323},
        /*  619 */ {0, 125, 250, 375, 500, 617},
        /*  620 */ {611},
        /*  621 */ {0, 619},
        /*  622 */ {325},
        /*  623 */ {0, 555},
        /*  624 */ {553, 623},
        /*  625 */ {0},
        /*  626 */ {375},
        /*  627 */ {0, 625},
        /*  628 */ {405},
        /*  629 */ {0, 627},
        /*  630 */ {581, 629},
        /*  631 */ {0},
        /*  632 */ {623, 631},
        /*  633 */ {0},
        /*  634 */ {595},
        /*  635 */ {0, 571, 633},
        /*  636 */ {419},
        /*  637 */ {0, 553, 635},
        /*  638 */ {511, 637},
        /*  639 */ {0, 623},
        /*  640 */ {387, 637, 639},
        /*  641 */ {0},
        /*  642 */ {523},
        /*  643 */ {0, 641},
        /*  644 */ {643},
        /*  645 */ {0, 643},
        /*  646 */ {397},
        /*  647 */ {0},
        /*  648 */ {413, 647},
        /*  649 */ {0},
        /*  650 */ {647},
        /*  651 */ {0, 637},
        /*  652 */ {559},
        /*  653 */ {0, 651},
        /*  654 */ {621},
        /*  655 */ {0, 567},
        /*  656 */ {617, 655},
        /*  657 */ {0, 619},
        /*  658 */ {603},
        /*  659 */ {0, 657},
        /*  660 */ {649},
        /*  661 */ {0, 581, 659},
        /*  662 */ {641},
        /*  663 */ {0},
        /*  664 */ {487, 663},
        /*  665 */ {0},
        /*  666 */ {665},
        /*  667 */ {0, 665},
        /*  668 */ {521},
        /*  669 */ {0, 355, 667},
        /*  670 */ {517},
        /*  671 */ {0},
        /*  672 */ {581, 671},
        /*  673 */ {0, 645},
        /*  674 */ {673},
        /*  675 */ {0, 461, 673},
        /*  676 */ {645},
        /*  677 */ {0, 675},
        /*  678 */ {583, 677},
        /*  679 */ {0, 613},
        /*  680 */ {589, 679},
        /*  681 */ {0, 679},
        /*  682 */ {511},
        /*  683 */ {0, 681},
        /*  684 */ {475},
        /*  685 */ {0, 681},
        /*  686 */ {489},
        /*  687 */ {0},
        /*  688 */ {617, 687},
        /*  689 */ {0, 675},
        /*  690 */ {611},
        /*  691 */ {0, 449, 689},
        /*  692 */ {393},
        /*  693 */ {0, 443, 691},
        /*  694 */ {525},
        /*  695 */ {0},
        /*  696 */ {455, 695},
        /*  697 */ {0},
        /*  698 */ {483},
        /*  699 */ {0, 659, 697},
        /*  700 */ {625},
        /*  701 */ {0, 235, 470, 699},
        /*  702 */ {665},
        /*  703 */ {0, 701},
        /*  704 */ {427, 703},
        /*  705 */ {0},
        /*  706 */ {679, 705},
        /*  707 */ {0, 705},
        /*  708 */ {693},
        /*  709 */ {0, 707},
        /*  710 */ {681, 707, 709},
        /*  711 */ {0, 619},
        /*  712 */ {89, 178, 267, 356, 445, 534, 623, 711},
        /*  713 */ {0},
        /*  714 */ {691},
        /*  715 */ {0, 257, 514},
        /*  716 */ {533},
        /*  717 */ {0, 397, 715},
        /*  718 */ {553},
        /*  719 */ {0, 569},
        /*  720 */ {95, 190, 285, 380, 475, 570, 665, 719},
        /*  721 */ {0},
        /*  722 */ {491},
        /*  723 */ {0, 455, 721},
        /*  724 */ {517},
        /*  725 */ {0, 723},
        /*  726 */ {721},
        /*  727 */ {0, 547},
        /*  728 */ {677, 727},
        /*  729 */ {0, 671},
        /*  730 */ {583},
        /*  731 */ {0, 729},
        /*  732 */ {389},
        /*  733 */ {0, 641, 731},
        /*  734 */ {667, 733},
        /*  735 */ {0, 691},
        /*  736 */ {377, 735},
        /*  737 */ {0},
        /*  738 */ {391},
        /*  739 */ {0, 679, 737},
        /*  740 */ {605},
        /*  741 */ {0, 707, 739},
        /*  742 */ {657},
        /*  743 */ {0, 653},
        /*  744 */ {397, 743},
        /*  745 */ {0, 487},
        /*  746 */ {395},
        /*  747 */ {0, 589, 745},
        /*  748 */ {729},
        /*  749 */ {0, 747},
        /*  750 */ {441},
        /*  751 */ {0, 733},
        /*  752 */ {623, 751},
        /*  753 */ {0, 595},
        /*  754 */ {735},
        /*  755 */ {0, 751},
        /*  756 */ {711},
        /*  757 */ {0, 755},
        /*  758 */ {525},
        /*  759 */ {0, 661},
        /*  760 */ {743, 759},
        /*  761 */ {0},
        /*  762 */ {679},
        /*  763 */ {0, 761},
        /*  764 */ {763},
        /*  765 */ {0, 763},
        /*  766 */ {763, 765},
        /*  767 */ {0, 599},
        /*  768 */ {653, 767},
        /*  769 */ {0, 649},
        /*  770 */ {317, 634, 769},
        /*  771 */ {0, 685, 769},
        /*  772 */ {765},
        /*  773 */ {0, 771},
        /*  774 */ {589},
        /*  775 */ {0},
        /*  776 */ {725, 775},
        /*  777 */ {0},
        /*  778 */ {403},
        /*  779 */ {0, 323, 646, 777},
        /*  780 */ {767},
        /*  781 */ {0, 779},
        /*  782 */ {453},
        /*  783 */ {0, 715},
        /*  784 */ {725, 783},
        /*  785 */ {0, 693},
        /*  786 */ {785},
        /*  787 */ {0, 785},
        /*  788 */ {413, 787},
        /*  789 */ {0, 787},
        /*  790 */ {679, 789},
        /*  791 */ {0, 761},
        /*  792 */ {389, 778, 791},
        /*  793 */ {0},
        /*  794 */ {651},
        /*  795 */ {0, 793},
        /*  796 */ {795},
        /*  797 */ {0, 795},
        /*  798 */ {745},
        /*  799 */ {0},
        /*  800 */ {337, 674, 799},
        /*  801 */ {0},
        /*  802 */ {801},
        /*  803 */ {0, 595, 801},
        /*  804 */ {729},
        /*  805 */ {0, 803},
        /*  806 */ {785},
        /*  807 */ {0},
        /*  808 */ {633, 805, 807},
        /*  809 */ {0},
        /*  810 */ {651},
        /*  811 */ {0, 793, 809},
        /*  812 */ {783},
        /*  813 */ {0, 11, 22, 33, 44, 55, 66, 77, 88, 99, 110, 121, 132, 143, 154, 165, 176, 187, 198, 209, 220, 231, 242, 253, 264, 275, 286, 297, 308, 319, 330, 341, 352, 363, 374, 385, 396, 407, 418, 429, 440, 451, 462, 473, 484, 495, 506, 517, 528, 539, 550, 561, 572, 583, 594, 605, 616, 627, 638, 649, 660, 671, 682, 693, 704, 715, 726, 737, 748, 759, 770, 781, 792, 803, 811},
        /*  814 */ {793},
        /*  815 */ {0},
        /*  816 */ {765, 813, 815},
        /*  817 */ {0, 765},
        /*  818 */ {699},
        /*  819 */ {0, 817},
        /*  820 */ {697},
        /*  821 */ {0, 819},
        /*  822 */ {805},
        /*  823 */ {0},
        /*  824 */ {329, 658, 823},
        /*  825 */ {0, 787},
        /*  826 */ {571},
        /*  827 */ {0, 825},
        /*  828 */ {639},
        /*  829 */ {0, 269, 538, 807, 827},
        /*  830 */ {589, 829},
        /*  831 */ {0},
        /*  832 */ {793, 831},
        /*  833 */ {0},
        /*  834 */ {819},
        /*  835 */ {0, 485, 833},
        /*  836 */ {835},
        /*  837 */ {0, 835},
        /*  838 */ {777},
        /*  839 */ {0, 785},
        /*  840 */ {499, 839},
        /*  841 */ {0, 697},
        /*  842 */ {795},
        /*  843 */ {0, 521, 841},
        /*  844 */ {739},
        /*  845 */ {0, 843},
        /*  846 */ {741},
        /*  847 */ {0, 711},
        /*  848 */ {623, 847},
        /*  849 */ {0},
        /*  850 */ {739},
        /*  851 */ {0, 409, 818, 849},
        /*  852 */ {693},
        /*  853 */ {0, 851},
        /*  854 */ {775, 853},
        /*  855 */ {0},
        /*  856 */ {855},
        /*  857 */ {0},
        /*  858 */ {651},
        /*  859 */ {0, 265, 530, 795, 857},
        /*  860 */ {825},
        /*  861 */ {0, 847},
        /*  862 */ {513},
        /*  863 */ {0, 773, 861},
        /*  864 */ {257, 514, 771, 863},
        /*  865 */ {0},
        /*  866 */ {791},
        /*  867 */ {0, 487, 865},
        /*  868 */ {723},
        /*  869 */ {0, 787, 867},
        /*  870 */ {569},
        /*  871 */ {0, 493},
        /*  872 */ {181, 362, 543, 724, 871},
        /*  873 */ {0, 521},
        /*  874 */ {873},
        /*  875 */ {0, 809, 873},
        /*  876 */ {727},
        /*  877 */ {0, 737, 875},
        /*  878 */ {535, 877},
        /*  879 */ {0},
        /*  880 */ {659, 877, 879},
        /*  881 */ {0, 803},
        /*  882 */ {783},
        /*  883 */ {0, 395, 790, 881},
        /*  884 */ {711},
        /*  885 */ {0, 883},
        /*  886 */ {659, 885},
        /*  887 */ {0},
        /*  888 */ {791, 887},
        /*  889 */ {0},
        /*  890 */ {707},
        /*  891 */ {0, 527, 889},
        /*  892 */ {861},
        /*  893 */ {0, 891},
        /*  894 */ {721},
        /*  895 */ {0, 883},
        /*  896 */ {877, 895},
        /*  897 */ {0},
        /*  898 */ {691},
        /*  899 */ {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 752, 753, 754, 755, 756, 757, 758, 759, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 843, 844, 845, 846, 847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 862, 863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 874, 875, 876, 877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 891, 892, 893, 894, 895, 896, 898},
        /*  900 */ {899},
        /*  901 */ {0, 899},
        /*  902 */ {881},
        /*  903 */ {0},
        /*  904 */ {901, 903},
        /*  905 */ {0},
        /*  906 */ {783},
        /*  907 */ {0, 881},
        /*  908 */ {765},
        /*  909 */ {0, 741},
        /*  910 */ {553, 909},
        /*  911 */ {0, 707},
        /*  912 */ {343, 686, 911},
        /*  913 */ {0},
        /*  914 */ {913},
        /*  915 */ {0, 913},
        /*  916 */ {733},
        /*  917 */ {0, 895, 915},
        /*  918 */ {841},
        /*  919 */ {0, 883},
        /*  920 */ {403, 806, 917, 919},
        /*  921 */ {0},
        /*  922 */ {921},
        /*  923 */ {0, 781, 921},
        /*  924 */ {893},
        /*  925 */ {0, 617, 923},
        /*  926 */ {561},
        /*  927 */ {0},
        /*  928 */ {895, 927},
        /*  929 */ {0, 893, 927},
        /*  930 */ {899},
        /*  931 */ {0, 859, 929},
        /*  932 */ {755},
        /*  933 */ {0, 931},
        /*  934 */ {931, 933},
        /*  935 */ {0},
        /*  936 */ {909, 933, 935},
        /*  937 */ {0},
        /*  938 */ {731},
        /*  939 */ {0, 797, 937},
        /*  940 */ {939},
        /*  941 */ {0, 939},
        /*  942 */ {897},
        /*  943 */ {0, 919},
        /*  944 */ {457, 914, 943},
        /*  945 */ {0},
        /*  946 */ {863, 943, 945},
        /*  947 */ {0, 547, 945},
        /*  948 */ {759},
        /*  949 */ {0, 947},
        /*  950 */ {91, 182, 273, 364, 455, 546, 637, 728, 819, 910, 949},
        /*  951 */ {0, 691},
        /*  952 */ {641, 949, 951},
        /*  953 */ {0, 785},
        /*  954 */ {823},
        /*  955 */ {0, 349, 698, 953},
        /*  956 */ {651},
        /*  957 */ {0, 799, 955},
        /*  958 */ {767, 957},
        /*  959 */ {0},
        /*  960 */ {469, 938, 959},
        /*  961 */ {0, 943},
        /*  962 */ {961},
        /*  963 */ {0, 961},
        /*  964 */ {861},
        /*  965 */ {0, 963},
        /*  966 */ {765},
        /*  967 */ {0, 931},
        /*  968 */ {947, 967},
        /*  969 */ {0},
        /*  970 */ {969},
        /*  971 */ {0, 965, 969},
        /*  972 */ {965},
        /*  973 */ {0, 971},
        /*  974 */ {763, 973},
        /*  975 */ {0},
        /*  976 */ {691, 975},
        /*  977 */ {0},
        /*  978 */ {977},
        /*  979 */ {0, 801},
        /*  980 */ {979},
        /*  981 */ {0, 979},
        /*  982 */ {805},
        /*  983 */ {0, 753},
        /*  984 */ {635, 983},
        /*  985 */ {0, 763},
        /*  986 */ {983},
        /*  987 */ {0, 845},
        /*  988 */ {867},
        /*  989 */ {0, 987},
        /*  990 */ {829},
        /*  991 */ {0},
        /*  992 */ {407, 814, 991},
        /*  993 */ {0, 931},
        /*  994 */ {771},
        /*  995 */ {0, 753},
        /*  996 */ {931},
        /*  997 */ {0, 995},
        /*  998 */ {897},
        /*  999 */ {0},
        /* 1000 */ {997, 999},
    };

}
