/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;

final class TestRSA_ECB_PKCS1
extends Test {
    private static final String name = "RSA_ECB_PKCS1";
    private Cipher c;
    private Cipher d;
    private final String s = "ThisIsASecretSecretMessageOfNull";
    private String algo;
    private int KEY_SIZE;

    protected TestRSA_ECB_PKCS1() {
        super(name);
        this.algo = "RSA";
        this.KEY_SIZE = 1024;
    }

    protected TestRSA_ECB_PKCS1(String algo, int KEY_SIZE) {
        super(name);
        this.algo = algo;
        this.KEY_SIZE = KEY_SIZE;
    }

    protected void doIt() throws Exception {
        this.beginTest("ECB with PKCS1");
        this.init();
        this.passIf(this.test(this.c, this.d, "ThisIsASecretSecretMessageOfNull"));
    }

    private void init() throws Exception {
        this.algo = "RSA";
        this.KEY_SIZE = 1024;
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(this.algo);
        kpg.initialize(this.KEY_SIZE);
        KeyPair kp = ((KeyPairGeneratorSpi)kpg).generateKeyPair();
        RSAPrivateKey prk = (RSAPrivateKey)kp.getPrivate();
        RSAPublicKey puk = (RSAPublicKey)kp.getPublic();
        this.algo = String.valueOf(this.algo) + "/ECB/PKCS#1";
        this.c = Cipher.getInstance(this.algo);
        this.d = Cipher.getInstance(this.algo);
        this.c.init(1, puk);
        this.d.init(2, prk);
    }

    private boolean test(Cipher c, Cipher d, String s) throws Exception {
        byte[] b = s.getBytes();
        byte[] ca = d.doFinal(c.doFinal(b));
        return new String(ca).equals(s);
    }
}

