/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.keyfactory;

import cryptix.jce.provider.key.RawSecretKey;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;

public final class PBEKeyFactory
extends SecretKeyFactorySpi {
    private PBEKeySpec pbeKeySpec = null;
    static /* synthetic */ Class array$C;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null || !(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Cannot generate SecretKey using given KeySpec.");
        }
        this.pbeKeySpec = (PBEKeySpec)keySpec;
        RawSecretKey key = new RawSecretKey("PBE", new String(this.pbeKeySpec.getPassword()).getBytes());
        return key;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key == null || keySpec == null) {
            throw new InvalidKeySpecException("Null parameter provided.");
        }
        Class<?> specClass = null;
        try {
            specClass = Class.forName("javax.crypto.spec.PBEKeySpec");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException("Cannot create KeySpec class not found!");
        }
        if (keySpec.isAssignableFrom(specClass)) {
            byte[] keyData = key.getEncoded();
            char[] rawKeyData = new char[keyData.length];
            int i = 0;
            while (i < keyData.length) {
                rawKeyData[i] = (char)keyData[i];
                ++i;
            }
            Object[] initArgs = new Object[]{rawKeyData};
            Class[] constructorArgs = new Class[]{array$C != null ? array$C : (array$C = PBEKeyFactory.class$("[C"))};
            KeySpec pks = null;
            try {
                Constructor specConstructor = keySpec.getConstructor(constructorArgs);
                pks = (KeySpec)specConstructor.newInstance(initArgs);
            }
            catch (InstantiationException instantiationException) {
                throw new InvalidKeySpecException("InvalidKeySpec.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidKeySpecException("IllegalAccess.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidKeySpecException("Illegal constr. argument.");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new InvalidKeySpecException("InvocationTargetException.");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvalidKeySpecException("Method not found.");
            }
            return pks;
        }
        throw new InvalidKeySpecException("Cannot assign to KeySpec.");
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException();
        }
        if (key instanceof RawSecretKey && key.getAlgorithm() == "PBE") {
            return key;
        }
        try {
            KeySpec tmpKs = this.engineGetKeySpec(key, (Class)null);
            return this.engineGenerateSecret(tmpKs);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Translation not possible.");
        }
    }
}

