/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.mac;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

class HMAC
extends MacSpi {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private final MessageDigest md;
    private final int mdBlockSize;
    private final int mdLen;
    private final byte[] iv_i;
    private final byte[] iv_o;

    protected HMAC(String mdName, int mdBlockSize, int mdLen) {
        try {
            this.md = MessageDigest.getInstance(mdName);
            this.mdBlockSize = mdBlockSize;
            this.mdLen = mdLen;
            this.iv_i = new byte[mdBlockSize];
            this.iv_o = new byte[mdBlockSize];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Underlying MesageDigest not found: " + mdName);
        }
    }

    private HMAC(MessageDigest md, int mdBlockSize, int mdLen, byte[] iv_i, byte[] iv_o) {
        this.md = md;
        this.mdBlockSize = mdBlockSize;
        this.mdLen = mdLen;
        this.iv_i = new byte[mdBlockSize];
        this.iv_o = new byte[mdBlockSize];
    }

    public Object clone() throws CloneNotSupportedException {
        MessageDigest md = (MessageDigest)this.md.clone();
        return new HMAC(md, this.mdBlockSize, this.mdLen, (byte[])this.iv_i.clone(), (byte[])this.iv_o.clone());
    }

    protected final byte[] engineDoFinal() {
        byte[] tmp = this.md.digest();
        this.md.reset();
        this.md.update(this.iv_o);
        this.md.update(tmp);
        byte[] output = this.md.digest();
        this.engineReset();
        return output;
    }

    protected final int engineGetMacLength() {
        return this.mdLen;
    }

    protected final void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("HMAC doesn't take AlgorithmParameters.");
        }
        if (!key.getFormat().equals("RAW")) {
            throw new InvalidKeyException("HMAC accepts keys in 'RAW' format only.");
        }
        byte[] keyBytes = key.getEncoded();
        if (keyBytes.length > this.mdBlockSize) {
            this.md.reset();
            keyBytes = this.md.digest(keyBytes);
        }
        int i = 0;
        while (i < this.iv_i.length) {
            this.iv_o[i] = 0;
            this.iv_i[i] = 0;
            ++i;
        }
        System.arraycopy(keyBytes, 0, this.iv_i, 0, keyBytes.length);
        int i2 = 0;
        while (i2 < this.iv_i.length) {
            int n = i2++;
            this.iv_i[n] = (byte)(this.iv_i[n] ^ 0x36);
        }
        System.arraycopy(keyBytes, 0, this.iv_o, 0, keyBytes.length);
        int i3 = 0;
        while (i3 < this.iv_i.length) {
            int n = i3++;
            this.iv_o[n] = (byte)(this.iv_o[n] ^ 0x5C);
        }
        this.engineReset();
    }

    protected final void engineReset() {
        this.md.reset();
        this.md.update(this.iv_i);
    }

    protected final void engineUpdate(byte input) {
        this.md.update(input);
    }

    protected final void engineUpdate(byte[] input, int offset, int len) {
        this.md.update(input, offset, len);
    }
}

