/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.parameters;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public final class BlockParameters
extends AlgorithmParametersSpi {
    private String algorithm;
    private byte[] iv = null;

    protected final byte[] engineGetEncoded() throws IOException {
        return this.iv;
    }

    protected final byte[] engineGetEncoded(String format) throws IOException {
        throw new RuntimeException("Method getEncoded(String format) not implemented");
    }

    protected final AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        try {
            if (!Class.forName("javax.crypto.spec.IvParameterSpec").isAssignableFrom(paramSpec)) {
                throw new InvalidParameterSpecException("Class is not IvParameterSpec assignable");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Class is not IvParameterSpec");
        }
        return new IvParameterSpec(this.iv);
    }

    protected final void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Wrong ParameterSpec");
        }
        this.iv = ((IvParameterSpec)paramSpec).getIV();
    }

    protected final void engineInit(byte[] params) throws IOException {
        this.iv = params;
    }

    protected final void engineInit(byte[] params, String format) throws IOException {
        throw new RuntimeException("Method init(byte[] params, String format) not implemented");
    }

    protected final String engineToString() {
        return "iv:[" + this.hexDump(this.iv) + "]";
    }

    private final String hexDump(byte[] b) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[b.length * 2];
        int j = 0;
        int i = 0;
        while (i < b.length) {
            byte k = b[i];
            buf[j++] = hex[k >>> 4 & 0xF];
            buf[j++] = hex[k & 0xF];
            ++i;
        }
        return new String(buf);
    }
}

