/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.util.Iterator;
import java.util.List;

public abstract class CertPath
implements Serializable {
    private String type;

    protected CertPath(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        CertPath that = (CertPath)o;
        return this.type.equals(that.getType()) && this.getCertificates().equals(that.getCertificates());
    }

    public abstract List getCertificates();

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract Iterator getEncodings();

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        hash = 31 * hash + this.getCertificates().hashCode();
        return hash;
    }

    public String toString() {
        Iterator i = this.getCertificates().iterator();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            sb.append(i.next().toString()).append("\n");
        }
        return sb.toString();
    }

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.type, this.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
    }

    protected static class CertPathRep {
        private String type;
        private byte[] data;

        protected CertPathRep(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        protected Object readResolve() {
            return null;
        }
    }
}

