/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.Support;

public class CertPathBuilder {
    private CertPathBuilderSpi engine;
    private Provider provider;
    private String algorithm;

    protected CertPathBuilder(CertPathBuilderSpi engine, Provider provider, String algorithm) {
        this.engine = engine;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public final CertPathBuilderResult build(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        return this.engine.engineBuild(params);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final String getDefaultType() {
        String defaultType = Security.getProperty("certpathbuilder.type");
        if (defaultType != null) {
            return defaultType;
        }
        return "OpenPGP";
    }

    public static CertPathBuilder getInstance(String algorithm) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("CertPathBuilder", algorithm);
        return new CertPathBuilder((CertPathBuilderSpi)o[0], (Provider)o[1], algorithm);
    }

    public static CertPathBuilder getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("CertPathBuilder", algorithm, provider);
        return new CertPathBuilder((CertPathBuilderSpi)o[0], (Provider)o[1], algorithm);
    }

    public static CertPathBuilder getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("CertPathBuilder", algorithm, provider);
        return new CertPathBuilder((CertPathBuilderSpi)o[0], (Provider)o[1], algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

