/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Support;

public class CertPathValidator {
    private CertPathValidatorSpi engine;
    private Provider provider;
    private String algorithm;
    private static final String propPrefix = "CertPathValidator.";

    public CertPathValidator(CertPathValidatorSpi engine, Provider provider, String algorithm) {
        this.engine = engine;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final String getDefaultType() {
        String defaultType = Security.getProperty("certpathvalidator.type");
        if (defaultType != null) {
            return defaultType;
        }
        return "OpenPGP";
    }

    public static CertPathValidator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("CertPathValidator", algorithm);
        return new CertPathValidator((CertPathValidatorSpi)o[0], (Provider)o[1], algorithm);
    }

    public static CertPathValidator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("CertPathValidator", algorithm, provider);
        return new CertPathValidator((CertPathValidatorSpi)o[0], (Provider)o[1], algorithm);
    }

    public static CertPathValidator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("CertPathValidator", algorithm, provider);
        return new CertPathValidator((CertPathValidatorSpi)o[0], (Provider)o[1], algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertPathValidatorResult validate(CertPath path, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        return this.engine.engineValidate(path, params);
    }
}

