/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Support;
import java.util.Collection;

public class CertStore {
    private CertStoreSpi engine;
    private Provider provider;
    private String type;
    private CertStoreParameters params;
    private static final String propPrefix = "CertStore.";
    static /* synthetic */ Class class$java$security$cert$CertStoreParameters;

    protected CertStore(CertStoreSpi engine, Provider provider, String type, CertStoreParameters params) {
        this.engine = engine;
        this.provider = provider;
        this.type = type;
        this.params = params;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public final Collection getCRLs(CRLSelector selector) throws CertStoreException {
        return this.engine.engineGetCRLs(selector);
    }

    public final Collection getCertificates(CertSelector selector) throws CertStoreException {
        return this.engine.engineGetCertificates(selector);
    }

    public static CertStore getInstance(String algorithm, CertStoreParameters params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Object[] o = Support.getClassName("CertStore", algorithm);
        return new CertStore(CertStore.getSpiInstance((String)o[0], params), (Provider)o[1], algorithm, params);
    }

    public static CertStore getInstance(String algorithm, CertStoreParameters params, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        Object[] o = Support.getClassName("CertStore", algorithm, provider);
        return new CertStore(CertStore.getSpiInstance((String)o[0], params), (Provider)o[1], algorithm, params);
    }

    public static CertStore getInstance(String algorithm, CertStoreParameters params, Provider provider) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Object[] o = Support.getClassName("CertStore", algorithm, provider);
        return new CertStore(CertStore.getSpiInstance((String)o[0], params), (Provider)o[1], algorithm, params);
    }

    private static CertStoreSpi getSpiInstance(String classname, CertStoreParameters params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        try {
            Class<?> spiClass = Class.forName(classname);
            Constructor<?> ctor = spiClass.getConstructor(class$java$security$cert$CertStoreParameters != null ? class$java$security$cert$CertStoreParameters : (class$java$security$cert$CertStoreParameters = CertStore.class$("java.security.cert.CertStoreParameters")));
            CertStoreSpi spi = (CertStoreSpi)ctor.newInstance(params.clone());
            return spi;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("Registered class not found");
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException("Registered class is not a CertStoreSpi");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchAlgorithmException("Registered class does not have the proper constructor");
        }
        catch (InvocationTargetException e) {
            throw new NoSuchAlgorithmException("Class for algorithm couldn't be instantiated: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException("Class for algorithm couldn't be instantiated: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException("Class for algorithm couldn't be instantiated: " + e.getMessage());
        }
    }
}

