/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.Support;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CertificateFactory {
    private CertificateFactorySpi engine;
    private Provider provider;
    private String type;
    private static final String propPrefix = "CertificateFactory.";

    protected CertificateFactory(CertificateFactorySpi engine, Provider provider, String type) {
        this.engine = engine;
        this.provider = provider;
        this.type = type;
    }

    public final CRL generateCRL(InputStream in) throws CRLException {
        return this.engine.engineGenerateCRL(in);
    }

    public final Collection generateCRLs(InputStream in) throws CRLException {
        return this.engine.engineGenerateCRLs(in);
    }

    public final CertPath generateCertPath(InputStream in) throws CertificateException {
        return this.engine.engineGenerateCertPath(in);
    }

    public final CertPath generateCertPath(InputStream in, String encoding) throws CertificateException {
        return this.engine.engineGenerateCertPath(in, encoding);
    }

    public final CertPath generateCertPath(List certificates) throws CertificateException {
        return this.engine.engineGenerateCertPath(certificates);
    }

    public final Certificate generateCertificate(InputStream in) throws CertificateException {
        return this.engine.engineGenerateCertificate(in);
    }

    public final Collection generateCertificates(InputStream in) throws CertificateException {
        return this.engine.engineGenerateCertificates(in);
    }

    public final Iterator getCertPathEncodings() {
        return this.engine.engineGetCertPathEncodings();
    }

    public static CertificateFactory getInstance(String type) throws CertificateException {
        try {
            Object[] o = Support.getImplementation("CertificateFactory", type);
            return new CertificateFactory((CertificateFactorySpi)o[0], (Provider)o[1], type);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException("Type not found");
        }
    }

    public static CertificateFactory getInstance(String type, String provider) throws CertificateException, NoSuchProviderException {
        try {
            Object[] o = Support.getImplementation("CertificateFactory", type, provider);
            return new CertificateFactory((CertificateFactorySpi)o[0], (Provider)o[1], type);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException("Type not found");
        }
    }

    public static CertificateFactory getInstance(String type, Provider provider) throws CertificateException {
        try {
            Object[] o = Support.getImplementation("CertificateFactory", type, provider);
            return new CertificateFactory((CertificateFactorySpi)o[0], (Provider)o[1], type);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException("Type not found");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }
}

