/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.algorithm;

import cryptix.openpgp.algorithm.PGPCompressor;
import cryptix.openpgp.algorithm.PGPPublicKeyAlgorithm;
import cryptix.openpgp.algorithm.PGPStringToKey;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public final class PGPAlgorithmFactory {
    public static final int INIT_DEFAULT = 0;
    public static final int INIT_EMPTY_ALL = 255;
    public static final int INIT_EMPTY_PUBLICKEY = 1;
    public static final int INIT_EMPTY_CIPHER = 2;
    public static final int INIT_EMPTY_HASH = 4;
    public static final int INIT_EMPTY_COMPRESSOR = 8;
    public static final int INIT_EMPTY_S2K = 16;
    private Hashtable PublicKeyClasses = new Hashtable();
    private Hashtable PublicKeyNames = new Hashtable();
    private Hashtable CompressionClasses = new Hashtable();
    private Hashtable S2KClasses = new Hashtable();
    private Hashtable HashStrings = new Hashtable();
    private Hashtable HashTextNames = new Hashtable();
    private Hashtable HashTextNamesReverse = new Hashtable();
    private Hashtable CipherStrings = new Hashtable();
    private Hashtable CipherKeySizes = new Hashtable();
    private Hashtable CipherBlockSizes = new Hashtable();
    private static final int[] defaultPublicKeyIDs = new int[]{1, 2, 3, 16, 17, 20};
    private static final String[] defaultPublicKeyClasses = new String[]{"cryptix.openpgp.algorithm.PGPRSA", "cryptix.openpgp.algorithm.PGPRSA", "cryptix.openpgp.algorithm.PGPRSA", "cryptix.openpgp.algorithm.PGPElGamal", "cryptix.openpgp.algorithm.PGPDSA", "cryptix.openpgp.algorithm.PGPElGamal"};
    private static final String[] defaultPublicKeyNames = new String[]{"RSA", "RSA", "RSA", "ElGamal", "DSA", "ElGamal"};
    private static final int[] defaultCompressionIDs;
    private static final String[] defaultCompressionClasses;
    private static final int[] defaultS2KIDs;
    private static final String[] defaultS2KClasses;
    private static final int[] defaultHashIDs;
    private static final String[] defaultHashStrings;
    private static final String[] defaultHashTextNames;
    private static final int[] defaultCipherIDs;
    private static final int[] defaultCipherKeySizes;
    private static final int[] defaultCipherBlockSizes;
    private static final String[] defaultCipherStrings;
    private static PGPAlgorithmFactory defaultInstance;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        defaultCompressionIDs = nArray;
        defaultCompressionClasses = new String[]{"cryptix.openpgp.algorithm.PGPUncompressed", "cryptix.openpgp.algorithm.PGPZip", "cryptix.openpgp.algorithm.PGPZlib"};
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 3;
        defaultS2KIDs = nArray2;
        defaultS2KClasses = new String[]{"cryptix.openpgp.algorithm.PGPSimpleS2K", "cryptix.openpgp.algorithm.PGPSaltedS2K", "cryptix.openpgp.algorithm.PGPIteratedAndSaltedS2K"};
        defaultHashIDs = new int[]{1, 2, 3, 4, 5, 6, 7};
        defaultHashStrings = new String[]{"MD5", "SHA1", "RIPEMD160", "DW SHA", "MD2", "Tiger", "HAVAL"};
        defaultHashTextNames = new String[]{"MD5", "SHA1", "RIPEMD160", null, "MD2", "TIGER192", "HAVAL-5-160"};
        defaultCipherIDs = new int[]{1, 2, 3, 4, 5, 7, 8, 9, 10};
        defaultCipherKeySizes = new int[]{128, 192, 128, 128, 128, 128, 192, 256, 256};
        defaultCipherBlockSizes = new int[]{64, 64, 64, 64, 64, 128, 128, 128, 128};
        defaultCipherStrings = new String[]{"IDEA", "TripleDES", "CAST5", "Blowfish", "SAFER", "Rijndael", "Rijndael", "Rijndael", "Twofish"};
        defaultInstance = null;
    }

    public PGPAlgorithmFactory() {
        this(0);
    }

    public PGPAlgorithmFactory(int init) {
        if ((init & 1) == 0) {
            this.DefaultPublicKeyAlgorithms();
        }
        if ((init & 8) == 0) {
            this.DefaultCompressionAlgorithms();
        }
        if ((init & 0x10) == 0) {
            this.DefaultS2KAlgorithms();
        }
        if ((init & 4) == 0) {
            this.DefaultHashAlgorithms();
        }
        if ((init & 2) == 0) {
            this.DefaultCipherAlgorithms();
        }
    }

    private void DefaultCipherAlgorithms() {
        int i = 0;
        while (i < defaultCipherIDs.length) {
            this.registerCipherAlgorithm(defaultCipherIDs[i], defaultCipherStrings[i], defaultCipherKeySizes[i], defaultCipherBlockSizes[i]);
            ++i;
        }
    }

    private void DefaultCompressionAlgorithms() {
        int i = 0;
        while (i < defaultCompressionIDs.length) {
            this.registerCompressionAlgorithm(defaultCompressionIDs[i], defaultCompressionClasses[i]);
            ++i;
        }
    }

    private void DefaultHashAlgorithms() {
        int i = 0;
        while (i < defaultHashIDs.length) {
            this.registerHashAlgorithm(defaultHashIDs[i], defaultHashStrings[i], defaultHashTextNames[i]);
            ++i;
        }
    }

    private void DefaultPublicKeyAlgorithms() {
        int i = 0;
        while (i < defaultPublicKeyIDs.length) {
            this.registerPublicKeyAlgorithm(defaultPublicKeyIDs[i], defaultPublicKeyClasses[i], defaultPublicKeyNames[i]);
            ++i;
        }
    }

    private void DefaultS2KAlgorithms() {
        int i = 0;
        while (i < defaultS2KIDs.length) {
            this.registerS2KAlgorithm(defaultS2KIDs[i], defaultS2KClasses[i]);
            ++i;
        }
    }

    public Cipher getCipherAlgorithm(int id, String mode) throws NoSuchAlgorithmException {
        String name = (String)this.CipherStrings.get(new Integer(id));
        if (name == null || "".equals(name)) {
            throw new NoSuchAlgorithmException("Cipher #" + id + " unknown");
        }
        String alg = String.valueOf(name) + "/" + mode + "/NoPadding";
        Provider[] providers = Security.getProviders();
        try {
            Cipher cp = Cipher.getInstance(alg, "CryptixCrypto");
            return cp;
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {}
        int i = 0;
        while (i < providers.length) {
            try {
                Cipher cp = Cipher.getInstance(alg, providers[i].getName());
                return cp;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new InternalError("Provider list inconsistency");
            }
            ++i;
        }
        throw new NoSuchAlgorithmException("Cipher #" + id + " not found");
    }

    public int getCipherBlockSize(int id) throws NoSuchAlgorithmException {
        try {
            Integer size = (Integer)this.CipherBlockSizes.get(new Integer(id));
            return size / 8;
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchAlgorithmException("Cipher algorithm #" + id + " not found");
        }
    }

    public int getCipherKeySize(int id) throws NoSuchAlgorithmException {
        try {
            Integer size = (Integer)this.CipherKeySizes.get(new Integer(id));
            return size / 8;
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchAlgorithmException("Cipher algorithm #" + id + " not found");
        }
    }

    public PGPCompressor getCompressionAlgorithm(int id) throws NoSuchAlgorithmException {
        try {
            String classname = (String)this.CompressionClasses.get(new Integer(id));
            Class<?> cl = Class.forName(classname);
            PGPCompressor comp = (PGPCompressor)cl.newInstance();
            return comp;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Compression algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Compression algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Compression algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchAlgorithmException("Compression algorithm #" + id + " not found");
        }
    }

    public static PGPAlgorithmFactory getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new PGPAlgorithmFactory(0);
        }
        return defaultInstance;
    }

    public MessageDigest getHashAlgorithm(int id) throws NoSuchAlgorithmException {
        try {
            String name = (String)this.HashStrings.get(new Integer(id));
            try {
                MessageDigest md = MessageDigest.getInstance(name, "CryptixCrypto");
                return md;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchProviderException noSuchProviderException) {}
            MessageDigest md = MessageDigest.getInstance(name);
            return md;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Hash algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchAlgorithmException("Hash algorithm #" + id + " not found");
        }
    }

    public int getHashAlgorithmIDFromTextName(String str) {
        return (Integer)this.HashTextNamesReverse.get(str);
    }

    public String getHashAlgorithmString(int id) {
        return (String)this.HashStrings.get(new Integer(id));
    }

    public String getHashTextName(int id) {
        return (String)this.HashTextNames.get(new Integer(id));
    }

    public PGPPublicKeyAlgorithm getPublicKeyAlgorithm(int id) throws NoSuchAlgorithmException {
        try {
            String classname = (String)this.PublicKeyClasses.get(new Integer(id));
            Class<?> cl = Class.forName(classname);
            PGPPublicKeyAlgorithm pka = (PGPPublicKeyAlgorithm)cl.newInstance();
            return pka;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Publickey algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Publickey algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Publickey algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchAlgorithmException("Publickey algorithm #" + id + " not found");
        }
    }

    public String getPublicKeyName(int id) {
        return (String)this.PublicKeyNames.get(new Integer(id));
    }

    public PGPStringToKey getS2KAlgorithm(int id) throws NoSuchAlgorithmException {
        try {
            String classname = (String)this.S2KClasses.get(new Integer(id));
            Class<?> cl = Class.forName(classname);
            PGPStringToKey s2k = (PGPStringToKey)cl.newInstance();
            return s2k;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("String to key algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("String to key algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("String to key algorithm #" + id + " cannot be loaded. This could be a provider problem.");
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchAlgorithmException("String to key algorithm #" + id + " not found");
        }
    }

    public void registerCipherAlgorithm(int id, String name, int keysize, int blocksize) {
        this.CipherStrings.put(new Integer(id), name);
        this.CipherKeySizes.put(new Integer(id), new Integer(keysize));
        this.CipherBlockSizes.put(new Integer(id), new Integer(blocksize));
    }

    public void registerCompressionAlgorithm(int id, String classname) {
        this.CompressionClasses.put(new Integer(id), classname);
    }

    public void registerHashAlgorithm(int id, String jcename, String textname) {
        this.HashStrings.put(new Integer(id), jcename);
        if (textname != null) {
            this.HashTextNames.put(new Integer(id), textname);
            this.HashTextNamesReverse.put(textname, new Integer(id));
        }
    }

    public void registerPublicKeyAlgorithm(int id, String classname, String name) {
        this.PublicKeyClasses.put(new Integer(id), classname);
        this.PublicKeyNames.put(new Integer(id), name);
    }

    public void registerS2KAlgorithm(int id, String classname) {
        this.S2KClasses.put(new Integer(id), classname);
    }

    public void unregisterCipherAlgorithm(int id) {
        this.CipherStrings.remove(new Integer(id));
        this.CipherKeySizes.remove(new Integer(id));
        this.CipherBlockSizes.remove(new Integer(id));
    }

    public void unregisterCompressionAlgorithm(int id) {
        this.CompressionClasses.remove(new Integer(id));
    }

    public void unregisterHashAlgorithm(int id) {
        this.HashStrings.remove(new Integer(id));
    }

    public void unregisterPublicKeyAlgorithm(int id) {
        this.PublicKeyClasses.remove(new Integer(id));
        this.PublicKeyNames.remove(new Integer(id));
    }

    public void unregisterS2KAlgorithm(int id) {
        this.S2KClasses.remove(new Integer(id));
    }
}

