/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.algorithm;

import cryptix.openpgp.algorithm.PGPCompressor;
import cryptix.openpgp.io.PGPCompressorInputStream;
import cryptix.openpgp.io.PGPCompressorOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public abstract class PGPDeflate
implements PGPCompressor {
    private static final int BEST_SPEED = 1;
    private static final int DEFAULT_COMPRESSION = 3;
    private static final int BEST_COMPRESSION = 9;
    private final boolean nowrap;

    protected PGPDeflate(boolean nowrap) {
        this.nowrap = nowrap;
    }

    private Deflater createDeflater() {
        return new Deflater(this.getCompressionLevel(), this.nowrap);
    }

    private Inflater createInflater() {
        return new Inflater(this.nowrap);
    }

    private int getCompressionLevel() {
        return 3;
    }

    public PGPCompressorOutputStream getCompressionStream(OutputStream out) {
        return new ZlibOut(new DeflaterOutputStream(out, this.createDeflater()));
    }

    public PGPCompressorInputStream getExpansionStream(InputStream in) {
        return new ZlibIn(new InflaterInputStream(in, this.createInflater()));
    }

    public boolean needsDummy() {
        return this.nowrap;
    }

    private class ZlibOut
    extends PGPCompressorOutputStream {
        public ZlibOut(DeflaterOutputStream out) {
            super(out);
        }

        protected void finishInternal() throws IOException {
            ((FilterOutputStream)((DeflaterOutputStream)this.out)).flush();
            ((DeflaterOutputStream)this.out).finish();
        }

        protected void writeInternal(byte[] data, int offset, int len) throws IOException {
            this.out.write(data, offset, len);
        }
    }

    private class ZlibIn
    extends PGPCompressorInputStream {
        public ZlibIn(InflaterInputStream in) {
            super(in);
        }

        protected int readInternal(byte[] buffer, int offset, int len) throws IOException {
            return this.in.read(buffer, offset, len);
        }
    }
}

