/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.algorithm;

import cryptix.openpgp.algorithm.PGPIteratedAndSaltedS2K;
import cryptix.openpgp.algorithm.PGPStringToKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;

public class PGPSaltedS2K
implements PGPStringToKey {
    public byte[] generateAndHash(byte[] passphrase, MessageDigest md, int keysize, DataOutput out, SecureRandom sr) throws IOException {
        byte[] salt = new byte[8];
        sr.nextBytes(salt);
        out.write(salt);
        return PGPIteratedAndSaltedS2K.toKey(passphrase, md, keysize, salt, 0, 1);
    }

    public boolean isSalted() {
        return true;
    }

    public byte[] readAndHash(byte[] passphrase, MessageDigest md, int keysize, DataInput in) throws IOException {
        byte[] salt = new byte[8];
        in.readFully(salt);
        return PGPIteratedAndSaltedS2K.toKey(passphrase, md, keysize, salt, 0, 1);
    }
}

