/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.io.PGPLengthDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

public class PGPCipherDataOutputStream
extends PGPLengthDataOutputStream {
    private PGPLengthDataOutputStream out;
    private byte[] buffer = new byte[4096];
    private Cipher c;
    private long chunkBytesWritten = 0L;

    public PGPCipherDataOutputStream(PGPLengthDataOutputStream out, Cipher c) {
        this.out = out;
        this.c = c;
    }

    private void clearBuffer() throws IOException {
        byte[] output = new byte[(int)this.chunkBytesWritten];
        try {
            if (this.c.update(this.buffer, 0, (int)this.chunkBytesWritten, output, 0) != this.buffer.length) {
                throw new RuntimeException("Length of unencrypted data > length of encrypted data");
            }
        }
        catch (ShortBufferException sbe) {
            throw new RuntimeException("Length of unencrypted data < length of encrypted data - " + sbe);
        }
        this.out.writeFully(this.buffer);
        this.chunkBytesWritten = 0L;
    }

    public void close() throws IOException {
        this.clearBuffer();
    }

    protected void writeDirect(int b) throws IOException {
        this.buffer[(int)this.chunkBytesWritten] = (byte)b;
        ++this.chunkBytesWritten;
        if (this.chunkBytesWritten == (long)this.buffer.length) {
            this.clearBuffer();
        }
    }

    protected void writeLength(OutputStream out, long len) throws IOException {
        this.clearBuffer();
        this.out.setLength(len);
    }

    protected void writePartialLength(OutputStream out, long len) throws IOException {
        this.clearBuffer();
        this.out.setPartialLength(len);
    }
}

