/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.util.PGPMPI;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public abstract class PGPDataOutputStream {
    public abstract void close() throws IOException;

    public void writeBoolean(boolean x) throws IOException {
        if (x) {
            this.writeInternal(1);
        } else {
            this.writeInternal(0);
        }
    }

    public void writeByte(byte x) throws IOException {
        this.writeInternal(x);
    }

    public void writeFully(byte[] b) throws IOException {
        this.writeFully(b, 0, b.length);
    }

    public void writeFully(byte[] b, int offset, int len) throws IOException {
        int i = offset;
        while (i < len + offset) {
            this.writeInternal(b[i]);
            ++i;
        }
    }

    public void writeInt(int x) throws IOException {
        this.writeInternal(x >> 24);
        this.writeInternal(x >> 16);
        this.writeInternal(x >> 8);
        this.writeInternal(x);
    }

    protected abstract void writeInternal(int var1) throws IOException;

    public void writeLengthPrependedString(String x) throws IOException {
        byte[] b;
        try {
            b = x.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 encoding not supported");
        }
        if (b.length > 255) {
            throw new IllegalArgumentException("String longer than 255 bytes");
        }
        this.writeByte((byte)b.length);
        this.writeFully(b);
    }

    public void writeLong(long x) throws IOException {
        this.writeInternal((int)(x >> 56));
        this.writeInternal((int)(x >> 48));
        this.writeInternal((int)(x >> 40));
        this.writeInternal((int)(x >> 32));
        this.writeInternal((int)(x >> 24));
        this.writeInternal((int)(x >> 16));
        this.writeInternal((int)(x >> 8));
        this.writeInternal((int)x);
    }

    public void writeMPI(BigInteger x) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        PGPMPI.encode(dos, x);
        this.writeFully(baos.toByteArray());
    }

    public void writeNullTerminatedString(String x) throws IOException {
        this.writeString(x);
        this.writeInternal(0);
    }

    public void writeShort(short x) throws IOException {
        this.writeInternal(x >> 8);
        this.writeInternal(x);
    }

    public void writeString(String x) throws IOException {
        byte[] b;
        try {
            b = x.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 encoding not supported");
        }
        this.writeFully(b);
    }
}

