/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPDataInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public abstract class PGPLengthDataInputStream
extends PGPDataInputStream {
    private long chunkLength = 0L;
    private long chunkBytesRead = -1L;
    private InputStream in;
    private boolean nothingRead = true;

    public PGPLengthDataInputStream() {
        this.in = null;
    }

    public PGPLengthDataInputStream(InputStream in) {
        this.in = in;
    }

    public long available() {
        return this.chunkLength - this.chunkBytesRead;
    }

    public void close() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        if (this.chunkLength != this.chunkBytesRead) {
            byte[] buf = new byte[4096];
            while (this.readBuffer(buf) == 4096) {
            }
            throw new PGPDataFormatException("Extra data in packet.");
        }
    }

    protected abstract long getNewChunkLength(InputStream var1) throws IOException, PGPDataFormatException, PGPFatalDataFormatException;

    public int readBuffer(byte[] b) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        return this.readBuffer(b, 0, b.length);
    }

    public int readBuffer(byte[] b, int offset, int len) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int i = offset;
        while (i < len + offset) {
            if (this.available() <= 0L) {
                return i;
            }
            b[i] = (byte)this.readInternal();
            ++i;
        }
        return b.length;
    }

    public byte[] readByteArray() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = this.readBuffer(buf)) == 4096) {
            baos.write(buf);
        }
        if (len > 0) {
            baos.write(buf, 0, len);
        }
        return baos.toByteArray();
    }

    protected int readDirect() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int result = this.in.read();
        if (result == -1) {
            throw new PGPFatalDataFormatException("Read tried past end of inputstream.");
        }
        return result;
    }

    protected int readInternal() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        ++this.chunkBytesRead;
        if (this.nothingRead) {
            this.nothingRead = false;
            this.chunkLength = 5L;
            this.chunkBytesRead = 0L;
            this.chunkLength = this.getNewChunkLength(this.in);
            if (this.chunkLength == 0L) {
                throw new PGPDataFormatException("Zero length packet.");
            }
            int result = this.readDirect();
            this.chunkBytesRead = 1L;
            return result;
        }
        if (this.chunkLength > this.chunkBytesRead) {
            return this.readDirect();
        }
        if (this.chunkLength == this.chunkBytesRead) {
            int result = this.readDirect();
            this.chunkLength = 5L;
            this.chunkBytesRead = 0L;
            this.chunkLength = this.getNewChunkLength(this.in);
            this.chunkBytesRead = 0L;
            return result;
        }
        throw new PGPDataFormatException("Read tried past end of packet.");
    }

    public String readString() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = this.readBuffer(buf)) == 4096) {
            baos.write(buf);
        }
        if (len > 0) {
            baos.write(buf, 0, len);
        }
        try {
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 encoding not supported");
        }
    }
}

