/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.openpgp.PGPCertificate;
import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPKey;
import cryptix.openpgp.PGPKeyBundle;
import cryptix.openpgp.PGPPrincipal;
import cryptix.openpgp.PGPPrivateKey;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.PGPWrongPassphraseException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.io.PGPHashDataOutputStream;
import cryptix.openpgp.packet.PGPKeyPacket;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPSecretKeyPacket;
import cryptix.openpgp.packet.PGPSecretSubKeyPacket;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.provider.PGPCertificateImpl;
import cryptix.openpgp.provider.PGPKeyIDFactory;
import cryptix.openpgp.signature.PGPDateSP;
import cryptix.openpgp.signature.PGPKeyIDSP;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyBundleException;
import cryptix.pki.KeyID;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.AbstractList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class PGPKeyBundleImpl
extends PGPKeyBundle {
    PGPPublicKey mainkey = null;
    PGPSecretKeyPacket privpkt = null;
    Vector directKeySigs = new Vector();
    Vector principals = new Vector();
    Vector certificates = new Vector();
    HashMap principalsToCertificates = new HashMap();
    Vector subkeys = new Vector();
    HashMap privSubkeys = new HashMap();
    HashMap subkeyBindingSigs = new HashMap();

    PGPKeyBundleImpl() {
        super("OpenPGP");
    }

    private PGPKeyBundleImpl(PGPPublicKey mainkey, PGPSecretKeyPacket privpkt, Vector directKeySigs, Vector principals, Vector certificates, HashMap principalsToCertificates, Vector subkeys, HashMap privSubkeys, HashMap subkeyBindingSigs) {
        super("OpenPGP");
        this.mainkey = mainkey;
        this.privpkt = privpkt;
        this.directKeySigs = directKeySigs;
        this.principals = principals;
        this.certificates = certificates;
        this.principalsToCertificates = principalsToCertificates;
        this.subkeys = subkeys;
        this.privSubkeys = privSubkeys;
        this.subkeyBindingSigs = subkeyBindingSigs;
    }

    public boolean addCertificate(Certificate cert) throws KeyBundleException {
        Vector<Certificate> mapping;
        if (!(cert instanceof PGPCertificate)) {
            throw new KeyBundleException("Invalid certificate type");
        }
        PGPCertificate pgpcert = (PGPCertificate)((Object)cert);
        PGPPublicKey pgppubkey = (PGPPublicKey)((Certificate)((Object)pgpcert)).getPublicKey();
        PGPPrincipal pgpprinc = (PGPPrincipal)pgpcert.getSubject();
        boolean result = false;
        if (this.mainkey == null) {
            this.mainkey = pgppubkey;
            result = true;
        } else if (!this.mainkey.equals(pgppubkey)) {
            throw new KeyBundleException("KeyBundle can only contain certificates for one key. This certificate belonged to another key.");
        }
        if (!this.principals.contains(pgpprinc)) {
            this.principals.add(pgpprinc);
            mapping = new Vector<Certificate>();
            this.principalsToCertificates.put(pgpprinc, mapping);
            result = true;
        } else {
            mapping = (Vector<Certificate>)this.principalsToCertificates.get(pgpprinc);
        }
        if (!mapping.contains((Object)pgpcert)) {
            mapping.add(cert);
            this.certificates.add(cert);
            result = true;
        }
        return result;
    }

    public boolean addPrincipal(Principal princ) throws KeyBundleException {
        if (!(princ instanceof PGPPrincipal)) {
            throw new KeyBundleException("Invalid principal type");
        }
        if (!this.principals.contains(princ)) {
            this.principals.add(princ);
            return true;
        }
        return false;
    }

    public boolean addPrivateKey(PrivateKey privkey, PublicKey pubkey) throws KeyBundleException {
        KeyID two;
        KeyID one;
        if (!(privkey instanceof PGPPrivateKey)) {
            throw new KeyBundleException("Invalid private key type");
        }
        if (!(pubkey instanceof PGPPublicKey)) {
            throw new KeyBundleException("Invalid private key type");
        }
        if (!pubkey.equals(this.mainkey)) {
            throw new KeyBundleException("Public key not found");
        }
        if (this.privpkt != null) {
            return false;
        }
        try {
            one = PGPKeyIDFactory.convert(pubkey);
            two = PGPKeyIDFactory.convert(privkey);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException("Bug found! " + ike);
        }
        if (!one.match(two)) {
            throw new KeyBundleException("Public and private key do not belong together");
        }
        PGPPrivateKey pgpprivkey = (PGPPrivateKey)privkey;
        if (!(pgpprivkey.getPacket() instanceof PGPSecretKeyPacket)) {
            throw new KeyBundleException("Main key expected. Got subkey.");
        }
        PGPSecretKeyPacket pkt = (PGPSecretKeyPacket)pgpprivkey.getPacket();
        this.privpkt = (PGPSecretKeyPacket)pkt.clone();
        return true;
    }

    public boolean addPrivateKey(PrivateKey privkey, PublicKey pubkey, char[] passphrase, SecureRandom sr) throws KeyBundleException {
        int hashid;
        int cipherid;
        int s2kid;
        this.addPrivateKey(privkey, pubkey);
        if (((PGPKey)((Object)privkey)).getPacket().getVersion() == 4) {
            s2kid = 3;
            cipherid = 3;
            hashid = 2;
        } else {
            s2kid = 0;
            cipherid = 1;
            hashid = 1;
        }
        this.privpkt.encrypt(passphrase, s2kid, cipherid, hashid, sr, PGPAlgorithmFactory.getDefaultInstance());
        this.privpkt.forgetSecretData();
        return true;
    }

    public boolean addPrivateSubKey(PrivateKey privsubkey, PublicKey pubsubkey) throws KeyBundleException {
        PGPSecretSubKeyPacket pkt = this.addPrivateSubKeyHelper(privsubkey, pubsubkey);
        if (this.privSubkeys.containsKey(pubsubkey)) {
            return false;
        }
        PGPSecretSubKeyPacket clone = (PGPSecretSubKeyPacket)pkt.clone();
        this.privSubkeys.put(pubsubkey, clone);
        return true;
    }

    public boolean addPrivateSubKey(PrivateKey privsubkey, PublicKey pubsubkey, char[] passphrase, SecureRandom sr) throws KeyBundleException {
        PGPSecretSubKeyPacket pkt = this.addPrivateSubKeyHelper(privsubkey, pubsubkey);
        if (this.privSubkeys.containsKey(pubsubkey)) {
            return false;
        }
        PGPSecretSubKeyPacket clone = (PGPSecretSubKeyPacket)pkt.clone();
        int s2kid = 3;
        int cipherid = 3;
        int hashid = 2;
        clone.encrypt(passphrase, s2kid, cipherid, hashid, sr, PGPAlgorithmFactory.getDefaultInstance());
        clone.forgetSecretData();
        this.privSubkeys.put(pubsubkey, clone);
        return true;
    }

    private PGPSecretSubKeyPacket addPrivateSubKeyHelper(PrivateKey privsubkey, PublicKey pubsubkey) throws KeyBundleException {
        PGPKeyPacket two;
        if (!(privsubkey instanceof PGPPrivateKey)) {
            throw new KeyBundleException("Invalid private key type");
        }
        if (!(pubsubkey instanceof PGPPublicKey)) {
            throw new KeyBundleException("Invalid public key type");
        }
        if (!this.subkeys.contains(pubsubkey)) {
            throw new KeyBundleException("Public key not found");
        }
        PGPPublicKeyPacket one = ((PGPPrivateKey)privsubkey).getPacket().clonePublic();
        if (!one.equals(two = ((PGPPublicKey)pubsubkey).getPacket())) {
            throw new KeyBundleException("Public and private key do not belong together");
        }
        PGPPrivateKey pgpprivkey = (PGPPrivateKey)privsubkey;
        if (!(pgpprivkey.getPacket() instanceof PGPSecretSubKeyPacket)) {
            throw new KeyBundleException("Subkey expected. Got mainkey.");
        }
        PGPSecretSubKeyPacket pkt = (PGPSecretSubKeyPacket)pgpprivkey.getPacket();
        return pkt;
    }

    public boolean addPublicKey(PublicKey pubkey) throws KeyBundleException {
        if (!(pubkey instanceof PGPPublicKey)) {
            throw new KeyBundleException("Invalid public key type");
        }
        if (this.mainkey == null) {
            this.mainkey = (PGPPublicKey)pubkey;
            return true;
        }
        throw new KeyBundleException("KeyBundle can only contain one main key.");
    }

    public boolean addPublicSubKey(PublicKey pubsubkey, KeyBundle other) throws KeyBundleException {
        if (this.subkeys.contains(pubsubkey)) {
            return false;
        }
        if (!(other instanceof PGPKeyBundleImpl)) {
            throw new KeyBundleException("Wrong keybundle type");
        }
        PGPKeyBundleImpl that = (PGPKeyBundleImpl)other;
        if (!that.subkeyBindingSigs.containsKey(pubsubkey)) {
            throw new KeyBundleException("Public key not found");
        }
        this.subkeys.add(pubsubkey);
        this.subkeyBindingSigs.put(pubsubkey, that.subkeyBindingSigs.get(pubsubkey));
        return true;
    }

    public boolean addPublicSubKey(PublicKey pubsubkey, PrivateKey signkey) throws KeyBundleException {
        MessageDigest md;
        KeyID two;
        KeyID one;
        if (!(pubsubkey instanceof PGPPublicKey)) {
            throw new KeyBundleException("Invalid public key type");
        }
        if (!(signkey instanceof PGPPrivateKey)) {
            throw new KeyBundleException("Invalid private key type");
        }
        if (this.subkeys.contains(pubsubkey)) {
            return false;
        }
        try {
            one = PGPKeyIDFactory.convert(this.mainkey);
            two = PGPKeyIDFactory.convert(signkey);
        }
        catch (InvalidKeyException ike) {
            throw new KeyBundleException("Invalid keys - " + ike);
        }
        if (!one.match(two)) {
            throw new KeyBundleException("Given signing key does not correspond to the main public key for this keybundle.");
        }
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        PGPKeyPacket keypacket = ((PGPPrivateKey)signkey).getPacket();
        PGPSigner signer = (PGPSigner)keypacket.getAlgorithm();
        byte algoid = keypacket.getAlgorithmID();
        int hashid = 2;
        PGPDateSP creation = new PGPDateSP();
        creation.setValue(new Date());
        creation.setPacketID((byte)2);
        Vector<PGPDateSP> hashed = new Vector<PGPDateSP>();
        hashed.addElement(creation);
        PGPKeyIDSP keyid = new PGPKeyIDSP();
        try {
            keyid.setValue(PGPKeyIDFactory.convert(signkey).getBytes(8));
        }
        catch (InvalidKeyException ike) {
            throw new KeyBundleException(String.valueOf(String.valueOf(ike)));
        }
        keyid.setPacketID((byte)16);
        Vector<PGPKeyIDSP> unhashed = new Vector<PGPKeyIDSP>();
        unhashed.addElement(keyid);
        PGPSignaturePacket pkt = new PGPSignaturePacket();
        pkt.setData((byte)24, algoid, (byte)hashid, hashed, unhashed);
        pkt.setPacketID((byte)2);
        try {
            md = factory.getHashAlgorithm(hashid);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyBundleException(String.valueOf(String.valueOf(nsae)));
        }
        signer.initSign(hashid, factory);
        try {
            PGPHashDataOutputStream hdos = new PGPHashDataOutputStream(md, signer);
            this.mainkey.getPacket().encodeBody(hdos);
            hdos.close();
            hdos = new PGPHashDataOutputStream(md, signer);
            ((PGPPublicKey)pubsubkey).getPacket().encodeBody(hdos);
            hdos.close();
        }
        catch (IOException ioe) {
            throw new InternalError("IOException on hashing key - " + ioe);
        }
        int bytesWritten = pkt.hashData(md, signer);
        if (pkt.getVersion() == 4) {
            byte[] trailer = new byte[]{pkt.getVersion(), -1, (byte)(bytesWritten >> 24 & 0xFF), (byte)(bytesWritten >> 16 & 0xFF), (byte)(bytesWritten >> 8 & 0xFF), (byte)(bytesWritten & 0xFF)};
            md.update(trailer);
            signer.update(trailer);
        }
        byte[] digestcalc = md.digest();
        pkt.setHash(digestcalc);
        signer.computeSignature();
        pkt.setSignature(signer);
        this.subkeyBindingSigs.put(pubsubkey, pkt);
        this.subkeys.add(pubsubkey);
        return true;
    }

    public Object clone() {
        HashMap p2cClone = new HashMap();
        Iterator keys = this.principalsToCertificates.keySet().iterator();
        Iterator entries = this.principalsToCertificates.entrySet().iterator();
        while (keys.hasNext()) {
            p2cClone.put(keys.next(), ((Vector)entries.next().getValue()).clone());
        }
        return new PGPKeyBundleImpl(this.mainkey, this.privpkt, (Vector)this.directKeySigs.clone(), (Vector)this.principals.clone(), (Vector)this.certificates.clone(), p2cClone, (Vector)this.subkeys.clone(), (HashMap)this.privSubkeys.clone(), (HashMap)this.subkeyBindingSigs.clone());
    }

    public boolean containsPrivateKey() {
        return this.privpkt != null;
    }

    public Iterator getCertificates() {
        return new RemoveNotSupportedIterator(((AbstractList)this.certificates).iterator());
    }

    public Iterator getCertificates(PublicKey key, Principal subject) {
        if (!key.equals(this.mainkey)) {
            return new EmptyIterator();
        }
        Vector mapping = (Vector)this.principalsToCertificates.get(subject);
        if (mapping == null) {
            return new EmptyIterator();
        }
        return new RemoveNotSupportedIterator(((AbstractList)mapping).iterator());
    }

    public byte[] getEncoded() throws KeyBundleException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.privpkt != null) {
                if (this.privSubkeys.size() != this.subkeys.size()) {
                    throw new KeyBundleException("Not all private subkeys present.");
                }
            } else if (this.privSubkeys.size() != 0) {
                throw new KeyBundleException("There are private subkeys present, but no private main key.");
            }
            if (this.privpkt != null) {
                this.privpkt.encode(baos);
            } else {
                baos.write(this.mainkey.getEncoded());
            }
            Iterator it = ((AbstractList)this.directKeySigs).iterator();
            while (it.hasNext()) {
                ((PGPSignaturePacket)it.next()).encode(baos);
            }
            it = ((AbstractList)this.principals).iterator();
            while (it.hasNext()) {
                PGPPrincipal subject = (PGPPrincipal)it.next();
                baos.write(subject.getEncoded());
                Iterator it2 = ((AbstractList)((Vector)this.principalsToCertificates.get(subject))).iterator();
                while (it2.hasNext()) {
                    ((PGPCertificate)((Object)it2.next())).getPacket().encode(baos);
                }
            }
            it = ((AbstractList)this.subkeys).iterator();
            while (it.hasNext()) {
                PGPKey subkey = (PGPKey)it.next();
                if (this.privpkt == null) {
                    baos.write(subkey.getEncoded());
                } else {
                    ((PGPKeyPacket)this.privSubkeys.get(subkey)).encode(baos);
                }
                ((PGPSignaturePacket)this.subkeyBindingSigs.get(subkey)).encode(baos);
            }
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new KeyBundleException(String.valueOf(String.valueOf(ioe)));
        }
    }

    public Date getExpirationDate() throws KeyBundleException {
        PGPKeyPacket kp = this.mainkey.getPacket();
        if (kp.getVersion() <= 3) {
            int expire = kp.getV23ExpirationDate();
            if (expire == 0) {
                return null;
            }
            Date crea = kp.getCreationDate();
            return new Date(crea.getTime() + 86400000L * (long)expire);
        }
        try {
            Date exp = null;
            Iterator certs = this.getCertificates();
            while (certs.hasNext()) {
                PGPSignatureSubPacket sp;
                PGPCertificateImpl cert = (PGPCertificateImpl)((Object)certs.next());
                if (!cert.isSelfSigned() || (sp = cert.getHashedPacket((byte)9)) == null) continue;
                Date date = ((PGPDateSP)sp).getValue();
                Date crea = kp.getCreationDate();
                date = new Date(date.getTime() + crea.getTime());
                if (exp == null) {
                    exp = date;
                    continue;
                }
                if (exp.compareTo(date) <= 0) continue;
                exp = date;
            }
            return exp;
        }
        catch (CertificateParsingException cpe) {
            throw new KeyBundleException("CertificateParsingException: " + cpe.getMessage());
        }
        catch (CertificateException ce) {
            throw new KeyBundleException("CertificateException: " + ce.getMessage());
        }
    }

    public Iterator getPrincipals() {
        return new RemoveNotSupportedIterator(((AbstractList)this.principals).iterator());
    }

    public PrivateKey getPrivateKey(PublicKey key, char[] passphrase) throws UnrecoverableKeyException {
        if (!this.mainkey.equals(key)) {
            return null;
        }
        if (this.privpkt == null) {
            return null;
        }
        PGPSecretKeyPacket clone = (PGPSecretKeyPacket)this.privpkt.clone();
        try {
            clone.decrypt(passphrase, PGPAlgorithmFactory.getDefaultInstance());
        }
        catch (PGPWrongPassphraseException pGPWrongPassphraseException) {
            throw new UnrecoverableKeyException("Invalid passphrase");
        }
        catch (PGPDataFormatException e) {
            throw new UnrecoverableKeyException("Parsing error, invalid decrypted data - " + e);
        }
        return new PGPPrivateKey(clone, key.getAlgorithm());
    }

    public PrivateKey getPrivateSubKey(PublicKey pubsubkey, char[] passphrase) throws UnrecoverableKeyException {
        if (!(pubsubkey instanceof PGPPublicKey)) {
            throw new IllegalArgumentException("Invalid public key type");
        }
        if (!this.privSubkeys.containsKey(pubsubkey)) {
            return null;
        }
        PGPSecretSubKeyPacket pkt = (PGPSecretSubKeyPacket)this.privSubkeys.get(pubsubkey);
        PGPSecretSubKeyPacket clone = (PGPSecretSubKeyPacket)pkt.clone();
        try {
            clone.decrypt(passphrase, PGPAlgorithmFactory.getDefaultInstance());
        }
        catch (PGPWrongPassphraseException pGPWrongPassphraseException) {
            throw new UnrecoverableKeyException("Invalid passphrase");
        }
        catch (PGPDataFormatException e) {
            throw new UnrecoverableKeyException("Parsing error, invalid decrypted data - " + e);
        }
        return new PGPPrivateKey(clone, pubsubkey.getAlgorithm());
    }

    public Iterator getPublicKeys() {
        return new SingleObjectIterator(this.mainkey);
    }

    public Iterator getPublicSubKeys() {
        return new RemoveNotSupportedIterator(((AbstractList)this.subkeys).iterator());
    }

    public boolean isLegacy() {
        return this.mainkey.isLegacy();
    }

    public boolean removeCertificate(Certificate cert) throws KeyBundleException {
        if (!this.certificates.contains(cert)) {
            return false;
        }
        Principal subject = ((PGPCertificate)((Object)cert)).getSubject();
        Vector mapping = (Vector)this.principalsToCertificates.get(subject);
        mapping.remove(cert);
        this.certificates.remove(cert);
        return true;
    }

    public boolean removePrincipal(Principal subject) throws KeyBundleException {
        if (!this.principals.contains(subject)) {
            return false;
        }
        Vector mapping = (Vector)this.principalsToCertificates.get(subject);
        this.certificates.removeAll(mapping);
        this.principals.remove(subject);
        this.principalsToCertificates.remove(subject);
        return true;
    }

    public boolean removePrivateKey(PublicKey key) throws KeyBundleException {
        if (this.privpkt != null || !key.equals(this.mainkey)) {
            return false;
        }
        this.privpkt = null;
        return true;
    }

    public boolean removePrivateSubKey(PublicKey pubsubkey) throws KeyBundleException {
        if (!(pubsubkey instanceof PGPPublicKey)) {
            throw new KeyBundleException("Invalid public key type");
        }
        if (!this.privSubkeys.containsKey(pubsubkey)) {
            return false;
        }
        this.privSubkeys.remove(pubsubkey);
        return true;
    }

    public boolean removePublicKey(PublicKey key) throws KeyBundleException {
        if (!key.equals(this.mainkey)) {
            return true;
        }
        this.mainkey = null;
        this.privpkt = null;
        this.directKeySigs = new Vector();
        this.principals = new Vector();
        this.certificates = new Vector();
        this.principalsToCertificates = new HashMap();
        this.subkeys = new Vector();
        this.privSubkeys = new HashMap();
        this.subkeyBindingSigs = new HashMap();
        return true;
    }

    public boolean removePublicSubKey(PublicKey subkey) throws KeyBundleException {
        if (!(subkey instanceof PGPPublicKey)) {
            throw new KeyBundleException("Invalid public key type");
        }
        if (!this.subkeys.contains(subkey)) {
            return false;
        }
        this.subkeys.remove(subkey);
        this.subkeyBindingSigs.remove(subkey);
        return true;
    }

    private class RemoveNotSupportedIterator
    implements Iterator {
        private Iterator parent;

        public RemoveNotSupportedIterator(Iterator parent) {
            this.parent = parent;
        }

        public boolean hasNext() {
            return this.parent.hasNext();
        }

        public Object next() {
            return this.parent.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not supported. Use the remove methods in KeyBundle.");
        }
    }

    private class EmptyIterator
    implements Iterator {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("Iterator is empty.");
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not supported. Use the remove methods in KeyBundle.");
        }
    }

    private class SingleObjectIterator
    implements Iterator {
        private Object obj;
        private boolean retrieved = false;

        public SingleObjectIterator(Object obj) {
            this.obj = obj;
        }

        public boolean hasNext() {
            return this.retrieved ^ true;
        }

        public Object next() {
            if (this.retrieved) {
                throw new NoSuchElementException("No more elements.");
            }
            this.retrieved = true;
            return this.obj;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not supported. Use the remove methods in KeyBundle.");
        }
    }
}

