/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.LiteralMessageBuilderSpi;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.openpgp.packet.PGPLiteralDataPacket;
import cryptix.openpgp.provider.PGPLiteralMessageImpl;
import cryptix.openpgp.util.PGPArmoury;
import java.security.SecureRandom;

public class PGPLiteralMessageBuilder
extends LiteralMessageBuilderSpi {
    private PGPLiteralDataPacket pkt;

    public Message engineBuild() throws IllegalStateException, MessageException {
        if (this.pkt == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        return new PGPLiteralMessageImpl(this.pkt);
    }

    public void engineInit(String contents, SecureRandom sr) throws IllegalStateException, MessageException {
        if (this.pkt != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.pkt = new PGPLiteralDataPacket();
        this.pkt.setData(PGPArmoury.canonicalize(contents));
        this.pkt.setPacketID((byte)11);
    }

    public void engineInit(byte[] contents, SecureRandom sr) throws IllegalStateException, MessageException {
        if (this.pkt != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.pkt = new PGPLiteralDataPacket();
        this.pkt.setData(contents);
        this.pkt.setPacketID((byte)11);
    }

    public void engineSetAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageException {
        if (this.pkt == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        if (name.equals("filename")) {
            if (!(attr instanceof String)) {
                throw new IllegalArgumentException("String expected for filename");
            }
        } else {
            throw new IllegalArgumentException("Invalid attribute: [" + name + "]");
        }
        this.pkt.setFileName((String)attr);
    }
}

