/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPDetachedSignatureMessage;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.PGPSignedMessage;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.packet.PGPOnePassSignaturePacket;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.provider.PGPDetachedSignatureMessageImpl;
import cryptix.openpgp.provider.PGPKeyIDImpl;
import cryptix.openpgp.provider.PGPLiteralMessageImpl;
import cryptix.openpgp.signature.PGPKeyIDSP;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyID;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class PGPSignedMessageImpl
extends PGPSignedMessage {
    private final PGPSignaturePacket pkt;
    private final PGPLiteralMessageImpl contents;

    public PGPSignedMessageImpl(boolean legacy, PGPSignaturePacket pkt, PGPLiteralMessageImpl contents) {
        super("OpenPGP", legacy);
        if (pkt == null) {
            throw new IllegalArgumentException("pkt == null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents == null");
        }
        this.pkt = pkt;
        this.contents = contents;
    }

    public Object getAttribute(String name) throws IllegalArgumentException, MessageException {
        throw new IllegalArgumentException("Attributes not supported on this object.");
    }

    public Message getContents() throws MessageException {
        return this.contents;
    }

    public PGPDetachedSignatureMessage getDetachedSignature() throws MessageException {
        return new PGPDetachedSignatureMessageImpl(this.pkt);
    }

    public byte[] getEncoded() throws MessageException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] keyid = null;
            if (this.pkt.getVersion() == 4) {
                Vector subpkts = this.pkt.getAllSubPackets();
                int i = 0;
                while (i < subpkts.size()) {
                    PGPKeyIDSP sp;
                    if (subpkts.elementAt(i) instanceof PGPKeyIDSP && (sp = (PGPKeyIDSP)subpkts.elementAt(i)).getPacketID() == 16) {
                        keyid = sp.getValue();
                    }
                    ++i;
                }
            } else {
                keyid = this.pkt.getKeyID();
            }
            if (keyid == null) {
                throw new MessageException("Could not find keyid.");
            }
            if (this.legacy) {
                this.pkt.encode(baos);
                baos.write(this.contents.getEncoded());
            } else {
                PGPOnePassSignaturePacket opspkt = new PGPOnePassSignaturePacket(this.pkt.getType(), this.pkt.getHashID(), this.pkt.getAlgoID(), keyid, false);
                opspkt.setPacketID((byte)4);
                opspkt.encode(baos);
                baos.write(this.contents.getEncoded());
                this.pkt.encode(baos);
            }
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException in ByteArrayOutputStream - " + ioe);
        }
    }

    public KeyID[] getKeyIDHints() throws MessageException {
        try {
            KeyID[] ids;
            byte[] keyid = null;
            if (this.pkt.getVersion() <= 3) {
                keyid = this.pkt.getKeyID();
            } else {
                PGPKeyIDSP idsp;
                Object o;
                this.pkt.parseSignatureSubPackets();
                Vector subpkts = this.pkt.getUnhashedSubPackets();
                Iterator it = ((AbstractList)subpkts).iterator();
                while (it.hasNext()) {
                    o = it.next();
                    if (!(o instanceof PGPKeyIDSP) || (idsp = (PGPKeyIDSP)o).getPacketID() != 16) continue;
                    keyid = idsp.getValue();
                }
                subpkts = this.pkt.getHashedSubPackets();
                it = ((AbstractList)subpkts).iterator();
                while (it.hasNext()) {
                    o = it.next();
                    if (!(o instanceof PGPKeyIDSP) || (idsp = (PGPKeyIDSP)o).getPacketID() != 16) continue;
                    keyid = idsp.getValue();
                }
            }
            if (keyid == null) {
                ids = new KeyID[]{};
            } else {
                PGPKeyIDImpl id3 = new PGPKeyIDImpl(null, keyid, 3);
                PGPKeyIDImpl id4 = new PGPKeyIDImpl(null, keyid, 4);
                ids = new KeyID[]{id4, id3};
            }
            return ids;
        }
        catch (PGPDataFormatException pdfe) {
            throw new MessageException(String.valueOf(String.valueOf(pdfe)));
        }
        catch (PGPFatalDataFormatException pdfe) {
            throw new MessageException(String.valueOf(String.valueOf(pdfe)));
        }
    }

    public boolean verify(KeyBundle pubkey) throws MessageException {
        return this.verify((PublicKey)pubkey.getPublicKeys().next());
    }

    public boolean verify(PublicKey pubkey) throws MessageException {
        byte[] digestinsig;
        byte[] digestcalc;
        boolean ok;
        MessageDigest md;
        if (!(pubkey instanceof PGPPublicKey)) {
            throw new IllegalArgumentException("Not instance of PGPPublicKey");
        }
        PGPPublicKey signkey = (PGPPublicKey)pubkey;
        if (!(signkey.getPacket() instanceof PGPPublicKeyPacket)) {
            throw new IllegalArgumentException("Not a public signing key");
        }
        PGPSigner signer = (PGPSigner)signkey.getPacket().getAlgorithm();
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        try {
            md = factory.getHashAlgorithm(this.pkt.getHashID());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new MessageException(String.valueOf(String.valueOf(nsae)));
        }
        signer.initVerify(this.pkt.getHashID(), factory);
        md.update(this.contents.getBinaryData());
        signer.update(this.contents.getBinaryData());
        int bytesWritten = this.pkt.hashData(md, signer);
        if (this.pkt.getVersion() == 4) {
            byte[] trailer = new byte[]{this.pkt.getVersion(), -1, (byte)(bytesWritten >> 24 & 0xFF), (byte)(bytesWritten >> 16 & 0xFF), (byte)(bytesWritten >> 8 & 0xFF), (byte)(bytesWritten & 0xFF)};
            md.update(trailer);
            signer.update(trailer);
        }
        boolean bl = ok = (digestcalc = md.digest())[0] == (digestinsig = this.pkt.getHash())[0] && digestcalc[1] == digestinsig[1];
        if (!ok) {
            return false;
        }
        try {
            this.pkt.interpretSignature(signer);
        }
        catch (IOException ioe) {
            throw new MessageException("IOException while parsing sig " + ioe);
        }
        catch (PGPDataFormatException pGPDataFormatException) {
            throw new MessageException("Invalid signature");
        }
        return signer.verifySignature();
    }
}

