/* $Id: SignedMessageBuilderSpi.java,v 1.2 2005/03/13 17:46:33 woudt Exp $
 *
 * Copyright (C) 1999-2005 The Cryptix Foundation Limited.
 * All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */

package cryptix.message;


import cryptix.pki.KeyBundle;

import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;


/**
 * Service provider interface for SignedMessageBuilder
 *
 * @author Edwin Woudt <edwin@cryptix.org>
 * @version $Revision: 1.2 $
 */
public abstract class SignedMessageBuilderSpi {

    /**
     * Initializes this builder with the given message.
     *
     * @throws IllegalStateException if this message has been initialized 
     *         before.
     * @throws MessageException on a variety of format specific problems.
     */
    public abstract void engineInit(Message contents, SecureRandom sr)
        throws IllegalStateException, MessageException;
    

    /**
     * Set a format specific attribute.
     *
     * @throws IllegalStateException if this message has not been initialized 
     *         before.
     * @throws IllegalArgumentException if the attribute is not supported or the
     *         given object does not have the right type.
     * @throws MessageException on a variety of format specific problems.
     *
     * @param name a name identifying the attribute
     * @param attr the attribute itself
     */
    public abstract void engineSetAttribute(String name, Object attr)
        throws IllegalStateException, IllegalArgumentException,
               MessageException;


    /**
     * Adds a signer
     *
     * @throws InvalidStateException if this message has not been initialized 
     *         properly or if the build() method has been called
     * @throws MessageException on a variety of format specific problems.
     */
    public abstract void engineAddSigner(PrivateKey signingkey)
        throws IllegalStateException, MessageException;


    /**
     * Adds a signer from a keybundle, decrypting it with the given passphrase.
     *
     * @throws InvalidStateException if this message has not been initialized 
     *         properly or if the build() method has been called
     * @throws MessageException on a variety of format specific problems.
     * @throws UnrecoverableKeyException if the private key cannot be retrieved
     *         from the keybundle (for example because of an incorrect 
     *         passphrase).
     */
    public abstract void engineAddSigner(KeyBundle bundle, char[] passphrase)
        throws IllegalStateException, MessageException, 
               UnrecoverableKeyException;


    /**
     * Returns the signed message
     *
     * @throws InvalidStateException if this message has not been initialized 
     *         properly, if no calls have been made to the addSigner method
     *         or if multiple calls to this build() method are made.
     * @throws MessageException on a variety of format specific problems.
     */
    public abstract Message engineBuild()
        throws IllegalStateException, MessageException;
        
}
