/*
 * Decompiled with CFR 0.152.
 */
package cryptix.random;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SecureRandomSpi;

public final class DevRandom
extends SecureRandomSpi {
    private static final File RANDOM_DEV = new File("/dev/urandom");
    private static FileInputStream randomStream = null;
    private static final Object mutex = new Object();

    public static boolean isAvailable() {
        File file = RANDOM_DEV;
        return file.exists() && file.canRead();
    }

    public DevRandom() {
        try {
            Object object = mutex;
            synchronized (object) {
                if (randomStream == null) {
                    randomStream = new FileInputStream(RANDOM_DEV);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Oops, somebody removed my randomness device?");
        }
    }

    protected void engineSetSeed(byte[] byArray) {
    }

    protected void engineNextBytes(byte[] byArray) {
        try {
            int n = 0;
            int n2 = byArray.length;
            while (n2 > 0) {
                int n3;
                Object object = mutex;
                synchronized (object) {
                    n3 = randomStream.read(byArray, n, n2);
                    if (n3 == -1) {
                        throw new IOException("EOF");
                    }
                }
                n += n3;
                n2 -= n3;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot read from randomness device: " + iOException);
        }
    }

    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }
}

