/*
 * Decompiled with CFR 0.152.
 */
package cryptix.random;

import cryptix.random.CryptixRandom;
import cryptix.random.StatisticalTests;
import java.security.SecureRandom;
import java.security.Security;

public final class Test {
    private static void out(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        System.out.println("Cryptix Randomness Provider Test Driver");
        Test.out("Registering provider...");
        Security.addProvider(new CryptixRandom());
        int n = -1;
        try {
            Test.out("Doing getInstance...");
            SecureRandom secureRandom = SecureRandom.getInstance("DevRandom", "CryptixRandom");
            Test.out("Doing statistical tests...");
            byte[] byArray = new byte[2500];
            n = 0;
            while (n < 1000000) {
                secureRandom.nextBytes(byArray);
                if (n % 1000 == 0) {
                    System.out.print(".");
                }
                if (!StatisticalTests.testMonobit(byArray)) {
                    throw new RuntimeException("Failed Monobit Test");
                }
                if (!StatisticalTests.testPoker(byArray)) {
                    throw new RuntimeException("Failed Poker Test");
                }
                ++n;
            }
            Test.out("");
        }
        catch (Exception exception) {
            Test.out("Failed at run: " + n);
            exception.printStackTrace();
        }
    }
}

