/* $Id: CryptixRandom.java,v 1.1 1999/09/03 09:53:06 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.random;


import java.security.Provider;


// FIXME: Use doPrivilegedAction. See JDK 1.2 doco/tutorial.. ??
// TODO:  Create automatic version number, based on CVS Revision.
//        How does one map 1.1.2.96 to a double in a sensible way?


/**
 * The Cryptix Randomness Provider.
 *
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 * @version $Revision: 1.1 $
 */
public final class CryptixRandom extends Provider
{

// Static variables and onstants
//...........................................................................

    private static final String
        NAME    = "CryptixRandom",
        INFO    = "Cryptix Randomness Provider";
    private static final double
        VERSION = 1.0;


// Constructor
//...........................................................................

    public CryptixRandom() {

        super(NAME, VERSION, INFO);

        System.out.println();
        System.out.println(">> Loading " + INFO + "...");
        if(DevRandom.isAvailable()) {
            System.out.println(">> Enabling DevRandom");
            put("SecureRandom.DevRandom", "cryptix.random.DevRandom");
        } else {
            System.out.println(">> Disabling DevRandom");
        }
        System.out.println(">> Loading Complete.");
        System.out.println();
    }
}
