/* $Id: Test.java,v 1.1 1999/09/03 09:53:06 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.random;


import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;


/**
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 * @version $Revision: 1.1 $
 */
public final class Test 
{
    private static void out(String s) {
        System.out.println(s);
    }
    
    public static void main(String[] argv) {
        
        System.out.println("Cryptix Randomness Provider Test Driver");
        
        out("Registering provider...");
        Security.addProvider(new cryptix.random.CryptixRandom());
        
        int i=-1;
        
        try {
            out("Doing getInstance...");    
            SecureRandom rng = 
                SecureRandom.getInstance("DevRandom", "CryptixRandom");
            
            out("Doing statistical tests...");
            byte[] run = new byte[2500];
            for(i=0; i<1000000; i++) {
                rng.nextBytes(run);
                if(i%1000==0) System.out.print(".");

                if( !StatisticalTests.testMonobit(run) )
                    throw new RuntimeException("Failed Monobit Test");
                
                if( !StatisticalTests.testPoker(run) )
                    throw new RuntimeException("Failed Poker Test");
                    
            }
            out("");

        } catch(Exception e) {
            out("Failed at run: " + i);
            e.printStackTrace();
        }
    }
}
