/*
 * Decompiled with CFR 0.152.
 */
package cryptix.math;

import cryptix.math.MathError;
import cryptix.util.core.Debug;
import java.io.PrintStream;
import java.io.PrintWriter;

public class BigNum
implements Cloneable {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel((String)"BigNum");
    private static final PrintWriter err = Debug.getOutput();
    private static BigNum staticZero;
    private static BigNum staticOne;
    private static final boolean use_native = false;
    static final int BITS = 30;
    static final int RADIX = 0x40000000;
    static final int MASK = 0x3FFFFFFF;
    static final int LBITS = 15;
    static final int LRADIX = 32768;
    static final int LMASK = Short.MAX_VALUE;
    private int[] n = new int[16];
    private int len = 0;
    private boolean negative = false;

    private static void debug(String string) {
        err.println("BigNum: " + string);
    }

    public int byteLength() {
        return (BigNum.bitLength(this) + 7) / 8;
    }

    public void check_state() {
        BigNum.bitLength(this);
    }

    public static int bitLength(BigNum bigNum) {
        int n = bigNum.len;
        if (n == 0) {
            return 0;
        }
        int n2 = (n - 1) * 30;
        int n3 = bigNum.n[n - 1];
        while (n3 != 0) {
            n3 >>>= 1;
            ++n2;
        }
        return n2;
    }

    public static boolean bit(BigNum bigNum, int n) {
        int n2 = n % 30;
        return (n /= 30) < bigNum.len && ((long)bigNum.n[n] & 1L << n2) != 0L;
    }

    public Object clone() {
        BigNum bigNum = new BigNum();
        BigNum.copy(bigNum, this);
        return bigNum;
    }

    public void copy(Object object) {
        BigNum.copy(this, (BigNum)object);
    }

    protected static void copy(BigNum bigNum, BigNum bigNum2) {
        if (bigNum == bigNum2) {
            return;
        }
        bigNum.n = new int[bigNum2.n.length];
        bigNum.negative = bigNum2.negative;
        bigNum.len = bigNum2.len;
        if (bigNum2.len > 0) {
            System.arraycopy(bigNum2.n, 0, bigNum.n, 0, bigNum2.len);
        }
    }

    public static void grow(BigNum bigNum, int n) {
        int[] nArray = bigNum.n;
        if (n <= nArray.length) {
            return;
        }
        int[] nArray2 = new int[n += 16];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        bigNum.n = nArray2;
    }

    public int intoBinary(byte[] byArray) {
        int n = (BigNum.bitLength(this) + 7) / 8;
        if (byArray.length < n) {
            throw new MathError("into-binary buffer too small");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n - 1;
        while (n4 >= 0) {
            int n5 = (int)((long)(this.n[n2] >>> n3) & 0xFFL);
            if ((n3 += 8) >= 30) {
                ++n2;
                if ((n3 -= 30) > 0) {
                    n5 = (int)((long)n5 | (long)(this.n[n2] << 8 - n3) & 0xFFL);
                }
            }
            byArray[n4] = (byte)n5;
            --n4;
        }
        return n;
    }

    protected void fromBinary(byte[] byArray) {
        this.negative = false;
        this.len = (byArray.length * 8 + 30 - 1) / 30;
        BigNum.grow(this, this.len);
        int n = 0;
        this.n[n] = 0;
        int n2 = 0;
        int n3 = byArray.length - 1;
        while (n3 >= 0) {
            int n4 = byArray[n3] & 0xFF;
            int n5 = n++;
            this.n[n5] = this.n[n5] | n4 << n2 & 0x3FFFFFFF;
            if ((n2 += 8) >= 30) {
                this.n[n] = 0;
                if ((n2 -= 30) > 0) {
                    this.n[n] = n4 >>> 8 - n2;
                }
            }
            --n3;
        }
        while (this.len > 0 && this.n[this.len - 1] == 0) {
            --this.len;
        }
    }

    public static void assign(BigNum bigNum, int n) {
        if (n != 0) {
            bigNum.len = 1;
            bigNum.n[0] = n & Integer.MAX_VALUE;
            bigNum.negative = n < 0;
        } else {
            bigNum.len = 0;
            bigNum.n[0] = 0;
            bigNum.negative = false;
        }
    }

    public static void zero(BigNum bigNum) {
        bigNum.n[0] = 0;
        bigNum.negative = false;
        bigNum.len = 0;
    }

    public static void one(BigNum bigNum) {
        bigNum.n[0] = 1;
        bigNum.negative = false;
        bigNum.len = 1;
    }

    public static boolean isOne(BigNum bigNum) {
        return bigNum.len == 1 && bigNum.n[0] == 1;
    }

    public static boolean even(BigNum bigNum) {
        return !(bigNum.len > 0 && (bigNum.n[0] & 1) == 1);
    }

    public static boolean odd(BigNum bigNum) {
        return bigNum.len > 0 && (bigNum.n[0] & 1) == 1;
    }

    public static boolean isZero(BigNum bigNum) {
        if (bigNum.len == 0) {
            return true;
        }
        bigNum.check_state();
        return false;
    }

    public static void inc(BigNum bigNum) {
        BigNum.add(bigNum, 1);
    }

    public static void dec(BigNum bigNum) {
        BigNum.sub(bigNum, 1);
    }

    public static void add(BigNum bigNum, int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            if (bigNum.negative) {
                bigNum.negative = false;
                BigNum.add_unsigned(bigNum, -n);
                bigNum.negative = true;
            } else {
                BigNum.sub_unsigned(bigNum, -n);
            }
        } else if (bigNum.negative) {
            bigNum.negative = false;
            BigNum.sub_unsigned(bigNum, n);
            bigNum.negative = true ^ bigNum.negative;
        } else {
            BigNum.add_unsigned(bigNum, n);
        }
    }

    public static void sub(BigNum bigNum, int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            if (bigNum.negative) {
                bigNum.negative = false;
                BigNum.sub_unsigned(bigNum, -n);
                bigNum.negative = true ^ bigNum.negative;
            } else {
                BigNum.add_unsigned(bigNum, -n);
            }
        } else if (bigNum.negative) {
            bigNum.negative = false;
            BigNum.add_unsigned(bigNum, n);
            bigNum.negative = true;
        } else {
            BigNum.sub_unsigned(bigNum, n);
        }
    }

    public static void add(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        if (bigNum2.len == 0) {
            BigNum.copy(bigNum, bigNum3);
            return;
        }
        if (bigNum3.len == 0) {
            BigNum.copy(bigNum, bigNum2);
            return;
        }
        if (bigNum2.negative) {
            if (bigNum3.negative) {
                BigNum.add_unsigned(bigNum, bigNum2, bigNum3);
                bigNum.negative = true;
            } else {
                BigNum.sub_unsigned(bigNum, bigNum3, bigNum2);
            }
        } else if (bigNum3.negative) {
            BigNum.sub_unsigned(bigNum, bigNum2, bigNum3);
        } else {
            BigNum.add_unsigned(bigNum, bigNum2, bigNum3);
        }
    }

    public static void add_unsigned(BigNum bigNum, int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            throw new MathError("unexpected negative");
        }
        if (bigNum.len == 0) {
            bigNum.n[0] = n;
            bigNum.len = 1;
            bigNum.negative = false;
            return;
        }
        if (bigNum.negative) {
            throw new MathError("unexpected negative");
        }
        BigNum.grow(bigNum, bigNum.len + 1);
        boolean bl = false;
        int[] nArray = bigNum.n;
        int n2 = nArray[0] + n;
        nArray[0] = n2 & 0x3FFFFFFF;
        bl = n2 >= 0x40000000;
        int n3 = 1;
        int n4 = bigNum.len;
        while (bl && n3 < n4) {
            n2 = nArray[n3] + 1;
            if (n2 < 0x40000000) {
                nArray[n3] = n2;
                bl = false;
            } else {
                nArray[n3] = n2 & 0x3FFFFFFF;
            }
            ++n3;
        }
        if (bl) {
            nArray[n3] = 1;
            ++bigNum.len;
        }
    }

    public static void add_unsigned(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        int n;
        if (bigNum2.len < bigNum3.len) {
            BigNum bigNum4 = bigNum2;
            bigNum2 = bigNum3;
            bigNum3 = bigNum4;
        }
        int n2 = bigNum2.len;
        int n3 = bigNum3.len;
        bigNum.len = n2;
        BigNum.grow(bigNum, bigNum.len);
        bigNum.negative = false;
        int[] nArray = bigNum2.n;
        int[] nArray2 = bigNum3.n;
        int[] nArray3 = bigNum.n;
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            n = nArray[n4] + nArray2[n4] + (bl ? 1 : 0);
            nArray3[n4] = n & 0x3FFFFFFF;
            bl = n >= 0x40000000;
            ++n4;
        }
        while (bl && n4 < n2) {
            n = nArray[n4] + 1;
            if (n < 0x40000000) {
                nArray3[n4] = n;
                bl = false;
            } else {
                nArray3[n4] = n & 0x3FFFFFFF;
            }
            ++n4;
        }
        if (bigNum2.len > n4) {
            System.arraycopy(nArray, n4, nArray3, n4, n2 - n4);
        }
        if (bl) {
            ++bigNum.len;
            BigNum.grow(bigNum, bigNum.len);
            bigNum.n[n4] = 1;
        }
    }

    public static void sub(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        if (bigNum2.len == 0) {
            BigNum.copy(bigNum, bigNum3);
            if (bigNum3.len > 0) {
                bigNum.negative = true ^ bigNum3.negative;
            }
            return;
        }
        if (bigNum3.len == 0) {
            BigNum.copy(bigNum, bigNum2);
            return;
        }
        if (bigNum2.negative) {
            if (bigNum3.negative) {
                BigNum.sub_unsigned(bigNum, bigNum3, bigNum2);
            } else {
                BigNum.add_unsigned(bigNum, bigNum3, bigNum2);
                bigNum.negative = true;
            }
        } else if (bigNum3.negative) {
            BigNum.add_unsigned(bigNum, bigNum2, bigNum3);
        } else {
            BigNum.sub_unsigned(bigNum, bigNum2, bigNum3);
        }
    }

    public static void sub_unsigned(BigNum bigNum, int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            throw new MathError("unexpected negative");
        }
        if (bigNum.len == 0) {
            bigNum.n[0] = n;
            bigNum.len = 1;
            bigNum.negative = true;
            return;
        }
        if (bigNum.negative) {
            throw new MathError("unexpected negative");
        }
        int[] nArray = bigNum.n;
        int n2 = bigNum.len;
        if (n2 == 1) {
            if (n == nArray[0]) {
                nArray[0] = 0;
                bigNum.len = 0;
                bigNum.negative = false;
                return;
            }
            if (n < nArray[0]) {
                nArray[0] = nArray[0] - n;
                return;
            }
            bigNum.negative = true;
        }
        int n3 = nArray[0] - n;
        nArray[0] = n3 & 0x3FFFFFFF;
        boolean bl = n3 < 0;
        int n4 = 0;
        while (bl && n4 < n2) {
            n3 = nArray[n4] - 1;
            if (n3 >= 0) {
                nArray[n4] = n3;
                bl = false;
            } else {
                nArray[n4] = n3 & 0x3FFFFFFF;
            }
            ++n4;
        }
        while (n2 > 0 && nArray[n2 - 1] == 0) {
            --n2;
        }
        bigNum.len = n2;
    }

    public static void sub_unsigned(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        Object object;
        Object object2;
        switch (BigNum.ucmp(bigNum2, bigNum3)) {
            case 0: {
                BigNum.zero(bigNum);
                return;
            }
            case -1: {
                object2 = bigNum2;
                bigNum2 = bigNum3;
                bigNum3 = object2;
                bigNum.negative = true;
                break;
            }
            case 1: {
                bigNum.negative = false;
            }
        }
        BigNum.grow(bigNum, bigNum2.len);
        object2 = bigNum2.n;
        int[] nArray = bigNum3.n;
        int[] nArray2 = bigNum.n;
        int n = bigNum2.len;
        int n2 = bigNum3.len;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            object = object2[n3] - nArray[n3] - bl;
            nArray2[n3] = object & 0x3FFFFFFF;
            bl = object < 0;
            ++n3;
        }
        while (bl && n3 < n) {
            object = object2[n3] - true;
            if (object >= 0) {
                nArray2[n3] = object;
                bl = false;
            } else {
                nArray2[n3] = object & 0x3FFFFFFF;
            }
            ++n3;
        }
        if (bigNum2.len > n3) {
            System.arraycopy(object2, n3, nArray2, n3, bigNum2.len - n3);
        }
        object = bigNum2.len;
        while (object > 0 && nArray2[object - 1] == 0) {
            --object;
        }
        bigNum.len = object;
    }

    public static int cmp(BigNum bigNum, BigNum bigNum2) {
        if (bigNum.len == 0 && bigNum2.len == 0) {
            return 0;
        }
        if (bigNum.negative) {
            if (bigNum2.negative) {
                return BigNum.ucmp(bigNum2, bigNum);
            }
            return -1;
        }
        if (bigNum2.negative) {
            return 1;
        }
        return BigNum.ucmp(bigNum, bigNum2);
    }

    public static int ucmp(BigNum bigNum, BigNum bigNum2) {
        int n = bigNum.len;
        int n2 = bigNum2.len;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        int[] nArray = bigNum.n;
        int[] nArray2 = bigNum2.n;
        int n3 = n - 1;
        while (n3 >= 0) {
            if (nArray[n3] < nArray2[n3]) {
                return -1;
            }
            if (nArray[n3] > nArray2[n3]) {
                return 1;
            }
            --n3;
        }
        return 0;
    }

    public static void shiftLeft(BigNum bigNum, BigNum bigNum2, int n) {
        BigNum.shiftLeft(bigNum, bigNum2, (short)n);
    }

    public static void shiftLeft(BigNum bigNum, BigNum bigNum2, short s) {
        int n;
        if (bigNum2.len == 0) {
            BigNum.zero(bigNum);
            return;
        }
        int n2 = s % 30;
        int n3 = s / 30;
        int n4 = bigNum2.len;
        bigNum.len = n4 + n3;
        BigNum.grow(bigNum, bigNum.len);
        int[] nArray = bigNum.n;
        System.arraycopy(bigNum2.n, 0, nArray, n3, n4);
        if (n3 > 0) {
            n = n3 - 1;
            while (n >= 0) {
                nArray[n] = 0;
                --n;
            }
        }
        if (n2 != 0) {
            n = 0;
            int n5 = bigNum.len;
            int n6 = n3;
            while (n6 < n5) {
                int n7 = nArray[n6];
                nArray[n6] = (n7 << n2 | n) & 0x3FFFFFFF;
                n = n7 >>> 30 - n2;
                ++n6;
            }
            if (n != 0) {
                BigNum.grow(bigNum, ++n5);
                bigNum.n[n5 - 1] = n;
                bigNum.len = n5;
            }
        }
    }

    public static void shiftLeftOnce(BigNum bigNum, BigNum bigNum2) {
        BigNum.shiftLeft(bigNum, bigNum2, (short)1);
    }

    public static void shiftRight(BigNum bigNum, BigNum bigNum2, int n) {
        BigNum.shiftRight(bigNum, bigNum2, (short)n);
    }

    public static void shiftRight(BigNum bigNum, BigNum bigNum2, short s) {
        int n = s % 30;
        int n2 = s / 30;
        if (n2 >= bigNum2.len) {
            BigNum.zero(bigNum);
            return;
        }
        bigNum.len = bigNum2.len - n2;
        BigNum.grow(bigNum, bigNum.len);
        System.arraycopy(bigNum2.n, n2, bigNum.n, 0, bigNum.len);
        if (n != 0) {
            int n3 = 0;
            int[] nArray = bigNum.n;
            int n4 = bigNum.len;
            int n5 = n4 - 1;
            while (n5 > 0) {
                int n6 = nArray[n5];
                nArray[n5] = n6 >>> n | n3;
                n3 = n6 << 30 - n & 0x3FFFFFFF;
                --n5;
            }
            n5 = nArray[0];
            nArray[0] = n5 >>> n | n3;
            if (n4 > 0 && nArray[n4 - 1] == 0) {
                --bigNum.len;
            }
        }
    }

    public static void shiftRightOnce(BigNum bigNum, BigNum bigNum2) {
        BigNum.shiftRight(bigNum, bigNum2, (short)1);
    }

    public static void mul(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        if (bigNum == bigNum2 || bigNum == bigNum3) {
            throw new MathError("Result must not be either Parameter (a or b)");
        }
        if (bigNum2.len == 0 || bigNum3.len == 0) {
            BigNum.zero(bigNum);
            return;
        }
        bigNum.negative = bigNum2.negative ^ bigNum3.negative;
        bigNum.len = bigNum2.len + bigNum3.len;
        BigNum.grow(bigNum, bigNum.len);
        int[] nArray = bigNum2.n;
        int[] nArray2 = bigNum3.n;
        int[] nArray3 = bigNum.n;
        int n = bigNum2.len;
        int n2 = bigNum3.len;
        int n3 = bigNum.len;
        int n4 = n3 - 1;
        while (n4 >= 0) {
            nArray3[n4] = 0;
            --n4;
        }
        n4 = 0;
        while (n4 < bigNum2.len) {
            long l = 0L;
            long l2 = nArray[n4];
            int n5 = n4;
            int n6 = 0;
            while (n6 < bigNum3.len) {
                long l3 = nArray3[n5];
                l = (l3 += (long)nArray2[n6] * l2 + l) >>> 30;
                nArray3[n5++] = (int)l3 & 0x3FFFFFFF;
                ++n6;
            }
            nArray3[n5] = (int)l;
            ++n4;
        }
        if (nArray3[n3 - 1] == 0) {
            --bigNum.len;
        }
    }

    public static void mod(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        if (bigNum == bigNum2) {
            throw new MathError("Result must not be the same object as m");
        }
        BigNum.copy(bigNum, bigNum2);
        if (BigNum.ucmp(bigNum2, bigNum3) < 0) {
            return;
        }
        int n = BigNum.bitLength(bigNum2) - BigNum.bitLength(bigNum3);
        BigNum bigNum4 = new BigNum();
        BigNum.shiftLeft(bigNum4, bigNum3, n);
        while (n >= 0) {
            if (BigNum.cmp(bigNum, bigNum4) >= 0) {
                BigNum.sub(bigNum, bigNum, bigNum4);
            }
            BigNum.shiftRight(bigNum4, bigNum4, (short)1);
            --n;
        }
    }

    public static void div(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        BigNum.div(bigNum, null, bigNum2, bigNum3);
    }

    public static void div(BigNum bigNum, BigNum bigNum2, BigNum bigNum3, BigNum bigNum4) {
        if (bigNum4.len == 0) {
            throw new MathError("divide by zero");
        }
        if (BigNum.cmp(bigNum3, bigNum4) < 0) {
            if (bigNum2 != null) {
                BigNum.copy(bigNum2, bigNum3);
            }
            if (bigNum != null) {
                BigNum.zero(bigNum);
            }
            return;
        }
        if (bigNum == null) {
            bigNum = new BigNum();
        }
        if (bigNum2 == null) {
            bigNum2 = new BigNum();
        }
        BigNum bigNum5 = new BigNum();
        BigNum.copy(bigNum2, bigNum3);
        BigNum.zero(bigNum);
        int n = BigNum.bitLength(bigNum3) - BigNum.bitLength(bigNum4);
        BigNum.shiftLeft(bigNum5, bigNum4, n);
        while (n >= 0) {
            if (bigNum.len == 0) {
                if (BigNum.cmp(bigNum2, bigNum5) >= 0) {
                    BigNum.one(bigNum);
                    BigNum.sub(bigNum2, bigNum2, bigNum5);
                }
            } else {
                BigNum.shiftLeftOnce(bigNum, bigNum);
                if (BigNum.cmp(bigNum2, bigNum5) >= 0) {
                    bigNum.n[0] = bigNum.n[0] | 1;
                    BigNum.sub(bigNum2, bigNum2, bigNum5);
                }
            }
            BigNum.shiftRightOnce(bigNum5, bigNum5);
            --n;
        }
        bigNum.negative = bigNum3.negative ^ bigNum4.negative;
    }

    public static void modExp(BigNum bigNum, BigNum bigNum2, BigNum bigNum3, BigNum bigNum4) {
        BigNum bigNum5 = new BigNum();
        BigNum bigNum6 = new BigNum();
        BigNum.mod(bigNum6, bigNum2, bigNum4);
        int n = BigNum.bitLength(bigNum3);
        if ((bigNum3.n[0] & 1) != 0) {
            BigNum.mod(bigNum, bigNum2, bigNum4);
        } else {
            BigNum.one(bigNum);
        }
        int n2 = BigNum.recip(bigNum5, bigNum4);
        int n3 = 1;
        while (n3 < n) {
            BigNum.modMulRecip(bigNum6, bigNum6, bigNum6, bigNum4, bigNum5, (short)n2);
            if (BigNum.bit(bigNum3, n3)) {
                BigNum.modMulRecip(bigNum, bigNum, bigNum6, bigNum4, bigNum5, (short)n2);
            }
            ++n3;
        }
    }

    public static void modMul(BigNum bigNum, BigNum bigNum2, BigNum bigNum3, BigNum bigNum4) {
        BigNum bigNum5 = new BigNum();
        BigNum.mul(bigNum5, bigNum2, bigNum3);
        BigNum.mod(bigNum, bigNum5, bigNum4);
    }

    public static int recip(BigNum bigNum, BigNum bigNum2) {
        BigNum bigNum3 = new BigNum();
        BigNum.one(bigNum3);
        int n = BigNum.bitLength(bigNum2);
        BigNum.shiftLeft(bigNum3, bigNum3, 2 * n);
        BigNum.div(bigNum, null, bigNum3, bigNum2);
        return n + 1;
    }

    public static void euclid(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        BigNum bigNum4 = new BigNum();
        BigNum bigNum5 = new BigNum();
        BigNum.copy(bigNum4, bigNum2);
        BigNum.copy(bigNum5, bigNum3);
        int n = 0;
        while (bigNum5.len != 0) {
            BigNum bigNum6;
            if ((bigNum4.n[0] & 1) != 0) {
                if ((bigNum5.n[0] & 1) != 0) {
                    BigNum.sub(bigNum4, bigNum4, bigNum5);
                    BigNum.shiftRightOnce(bigNum4, bigNum4);
                    if (BigNum.cmp(bigNum4, bigNum5) >= 0) continue;
                    bigNum6 = bigNum4;
                    bigNum4 = bigNum5;
                    bigNum5 = bigNum6;
                    continue;
                }
                BigNum.shiftRightOnce(bigNum5, bigNum5);
                if (BigNum.cmp(bigNum4, bigNum5) >= 0) continue;
                bigNum6 = bigNum4;
                bigNum4 = bigNum5;
                bigNum5 = bigNum6;
                continue;
            }
            if ((bigNum5.n[0] & 1) != 0) {
                BigNum.shiftRightOnce(bigNum4, bigNum4);
                if (BigNum.cmp(bigNum4, bigNum5) >= 0) continue;
                bigNum6 = bigNum4;
                bigNum4 = bigNum5;
                bigNum5 = bigNum6;
                continue;
            }
            BigNum.shiftRightOnce(bigNum4, bigNum4);
            BigNum.shiftRightOnce(bigNum5, bigNum5);
            ++n;
        }
        if (n > 0) {
            BigNum.shiftLeft(bigNum, bigNum4, n);
        } else {
            BigNum.copy(bigNum, bigNum4);
        }
    }

    public static void gcd(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        if (BigNum.cmp(bigNum2, bigNum3) > 0) {
            BigNum.euclid(bigNum, bigNum2, bigNum3);
        } else {
            BigNum.euclid(bigNum, bigNum3, bigNum2);
        }
    }

    public static void modMulRecip(BigNum bigNum, BigNum bigNum2, BigNum bigNum3, BigNum bigNum4, BigNum bigNum5, short s) {
        BigNum bigNum6 = new BigNum();
        BigNum bigNum7 = new BigNum();
        BigNum bigNum8 = new BigNum();
        BigNum bigNum9 = new BigNum();
        BigNum.mul(bigNum6, bigNum2, bigNum3);
        BigNum.shiftRight(bigNum9, bigNum6, s - 1);
        BigNum.mul(bigNum7, bigNum9, bigNum5);
        BigNum.shiftRight(bigNum8, bigNum7, s - 1);
        BigNum.mul(bigNum7, bigNum4, bigNum8);
        BigNum.sub(bigNum, bigNum6, bigNum7);
        int n = 0;
        while (BigNum.cmp(bigNum, bigNum4) >= 0) {
            if (n++ > 2) {
                throw new MathError("modulo reciprocal failed");
            }
            BigNum.sub(bigNum, bigNum, bigNum4);
        }
    }

    public static void extended_euclid(BigNum bigNum, BigNum bigNum2, BigNum bigNum3, BigNum bigNum4, BigNum bigNum5) {
    }

    public static void inverseModN(BigNum bigNum, BigNum bigNum2, BigNum bigNum3) {
        if (bigNum2.negative || bigNum3.negative) {
            throw new MathError("invalid negative argument");
        }
        BigNum bigNum4 = new BigNum();
        BigNum bigNum5 = new BigNum();
        BigNum bigNum6 = bigNum2;
        BigNum bigNum7 = new BigNum();
        BigNum bigNum8 = new BigNum();
        BigNum bigNum9 = bigNum3;
        BigNum.one(bigNum4);
        BigNum.one(bigNum8);
        BigNum.zero(bigNum5);
        BigNum.zero(bigNum7);
        while (bigNum9.len != 0) {
            BigNum bigNum10 = new BigNum();
            BigNum bigNum11 = new BigNum();
            BigNum bigNum12 = new BigNum();
            BigNum bigNum13 = new BigNum();
            BigNum bigNum14 = new BigNum();
            BigNum.div(bigNum13, bigNum12, bigNum6, bigNum9);
            BigNum.mul(bigNum10, bigNum13, bigNum8);
            BigNum.sub(bigNum11, bigNum5, bigNum10);
            BigNum.mul(bigNum14, bigNum13, bigNum7);
            BigNum.sub(bigNum10, bigNum4, bigNum14);
            bigNum4 = bigNum7;
            bigNum5 = bigNum8;
            bigNum6 = bigNum9;
            bigNum7 = bigNum10;
            bigNum8 = bigNum11;
            bigNum9 = bigNum12;
        }
        if (bigNum4.negative) {
            BigNum.add(bigNum4, bigNum4, bigNum3);
        }
        BigNum.copy(bigNum, bigNum4);
    }

    protected void finalize() {
    }

    public static void display(PrintStream printStream, BigNum bigNum) {
        printStream.println("Length: " + bigNum.len);
        printStream.println("Sign flag: " + bigNum.negative);
    }

    public static void display(PrintWriter printWriter, BigNum bigNum) {
        printWriter.println("Length: " + bigNum.len);
        printWriter.println("Sign flag: " + bigNum.negative);
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private static String native_clinit() {
        return BigNum.bignum_test() == 0 ? null : "bignum_test failed";
    }

    private static native int bignum_test();

    private native int bignum_new();

    private native void bignum_free();

    private static native int bignum_copy(BigNum var0, BigNum var1);

    private static native int bignum_iszero(BigNum var0);

    private static native int bignum_grow(BigNum var0, int var1);

    private static native int bignum_bytelen();

    private static native int bignum_bitlen(BigNum var0);

    private native int bignum_into_bytes(byte[] var1);

    private native int bignum_from_bytes(byte[] var1);

    private native int setToOne();

    private native int setToZero();

    private static native int bignum_add_word(BigNum var0, int var1);

    private static native int bignum_set_word(BigNum var0, int var1);

    private static native int bignum_add(BigNum var0, BigNum var1, BigNum var2);

    private static native int bignum_sub(BigNum var0, BigNum var1, BigNum var2);

    private static native int bignum_cmp(BigNum var0, BigNum var1);

    private static native int bignum_ucmp(BigNum var0, BigNum var1);

    public native int bignum_hashCode();

    private static native int bignum_mul(BigNum var0, BigNum var1, BigNum var2);

    private static native int bignum_mod(BigNum var0, BigNum var1, BigNum var2);

    private static native int bignum_div(BigNum var0, BigNum var1, BigNum var2, BigNum var3);

    private static native int bignum_lshift(BigNum var0, BigNum var1, short var2);

    private static native int bignum_lshift1(BigNum var0, BigNum var1);

    private static native int bignum_rshift(BigNum var0, BigNum var1, short var2);

    private static native int bignum_rshift1(BigNum var0, BigNum var1);

    private static native int bignum_mod_exp(BigNum var0, BigNum var1, BigNum var2, BigNum var3);

    private static native int bignum_modmul_recip(BigNum var0, BigNum var1, BigNum var2, BigNum var3, BigNum var4, short var5);

    private static native int bignum_mod_mul(BigNum var0, BigNum var1, BigNum var2, BigNum var3);

    private static native int bignum_reciprocal(BigNum var0, BigNum var1);

    private static native int bignum_gcd(BigNum var0, BigNum var1, BigNum var2);

    private static native int bignum_inverse_modn(BigNum var0, BigNum var1, BigNum var2);

    public static void main(String[] stringArray) {
        try {
            BigNum.self_test(new PrintWriter(System.out, true));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void self_test(PrintWriter printWriter) throws Exception {
        printWriter.print("not implemented");
    }

    protected BigNum() {
    }

    static {
        staticOne = new BigNum();
        BigNum.one(staticOne);
    }
}

