/*
 * Decompiled with CFR 0.152.
 */
package cryptix.math;

import cryptix.math.BigInteger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MPI {
    public static BigInteger read(DataInput dataInput) throws IOException {
        int n = dataInput.readShort() & 0xFFFF;
        byte[] byArray = new byte[(n + 7) / 8];
        dataInput.readFully(byArray);
        return new BigInteger(byArray);
    }

    public static void write(DataOutput dataOutput, BigInteger bigInteger) throws IOException {
        dataOutput.writeShort(bigInteger.bitLength());
        dataOutput.write(bigInteger.toByteArray());
    }

    public static BigInteger load(byte[] byArray) throws IOException {
        return MPI.load(byArray, 0);
    }

    public static BigInteger load(byte[] byArray, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (n > 0) {
            ((InputStream)byteArrayInputStream).skip(n);
        }
        return MPI.read(new DataInputStream(byteArrayInputStream));
    }

    public static byte[] save(BigInteger bigInteger) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MPI.write(new DataOutputStream(byteArrayOutputStream), bigInteger);
        return byteArrayOutputStream.toByteArray();
    }

    private MPI() {
    }
}

