/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.mime.LegacyString;
import cryptix.pgp.Armoury;
import cryptix.pgp.CompressedData;
import cryptix.pgp.ConvEncryptedData;
import cryptix.pgp.DecryptException;
import cryptix.pgp.FileRandomStream;
import cryptix.pgp.FormatException;
import cryptix.pgp.InvalidChecksumException;
import cryptix.pgp.KeyGlob;
import cryptix.pgp.KeyID;
import cryptix.pgp.LiteralData;
import cryptix.pgp.Packet;
import cryptix.pgp.PacketFactory;
import cryptix.pgp.PacketInputStream;
import cryptix.pgp.PacketOutputStream;
import cryptix.pgp.Passphrase;
import cryptix.pgp.PublicKeyEncrypted;
import cryptix.pgp.Signature;
import cryptix.security.MD5;
import cryptix.security.rsa.PublicKey;
import cryptix.security.rsa.SecretKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public final class ArmouredMessage {
    private static final String LINEFEED = "\r\n";
    private String ciphertext_;
    private String plaintext_;
    private String signedBy_;
    private boolean authenticated_;
    private boolean encrypted_;
    private SecretKey from;
    private Vector to;
    private PublicKeyEncrypted PKE;
    private ConvEncryptedData CKE;

    public final String ciphertext() {
        return this.ciphertext_;
    }

    public final String plaintext() {
        return this.plaintext_;
    }

    public final String signedBy() {
        return this.signedBy_;
    }

    public final boolean authenticated() {
        return this.authenticated_;
    }

    public final boolean encrypted() {
        return this.encrypted_;
    }

    private Signature sign(byte[] byArray) throws IOException {
        MD5 mD5 = new MD5();
        mD5.add(byArray);
        return new Signature(this.from, mD5);
    }

    public static byte[] byteEncode(String string) {
        return LegacyString.toByteArray(string);
    }

    private String dashAdd(String string) {
        int n = 0;
        while ((n = string.indexOf("\r\n-", n)) != -1) {
            string = string.substring(0, n + 2) + "- " + string.substring(n + 2);
            n += 3;
        }
        return string;
    }

    private String dashSubtract(String string) {
        int n = 0;
        while ((n = string.indexOf("\r\n- -", n)) != -1) {
            string = string.substring(0, n + 2) + string.substring(n + 4);
            n += 3;
        }
        return string;
    }

    public ArmouredMessage(String string, SecretKey secretKey, Vector vector) throws IOException {
        this.plaintext_ = string;
        this.from = secretKey;
        this.to = vector;
        byte[] byArray = new byte[16];
        FileRandomStream fileRandomStream = new FileRandomStream();
        fileRandomStream.read(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PacketOutputStream packetOutputStream = new PacketOutputStream(byteArrayOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PacketOutputStream packetOutputStream2 = new PacketOutputStream(byteArrayOutputStream2);
        if (this.from == null && (this.to == null || this.to.isEmpty())) {
            this.ciphertext_ = string;
        } else if (this.from == null) {
            int n = 0;
            while (n < this.to.size()) {
                this.PKE = new PublicKeyEncrypted((PublicKey)this.to.elementAt(n), byArray, fileRandomStream);
                packetOutputStream.writePacket(this.PKE);
                ++n;
            }
            LiteralData literalData = new LiteralData(ArmouredMessage.byteEncode(string), "stuff.txt", 't');
            this.CKE = new ConvEncryptedData(PacketFactory.save(literalData), byArray, fileRandomStream);
            packetOutputStream.writePacket(this.CKE);
            this.ciphertext_ = Armoury.message("MESSAGE", byteArrayOutputStream.toByteArray());
            this.encrypted_ = true;
        } else if (this.to == null || this.to.isEmpty()) {
            Signature signature = this.sign(ArmouredMessage.byteEncode(string));
            this.ciphertext_ = "-----BEGIN PGP SIGNED MESSAGE-----\r\n\r\n";
            this.ciphertext_ = this.ciphertext_ + this.dashAdd(string) + LINEFEED;
            this.ciphertext_ = this.ciphertext_ + Armoury.message("SIGNATURE", PacketFactory.save(signature));
            this.authenticated_ = true;
        } else {
            int n = 0;
            while (n < this.to.size()) {
                this.PKE = new PublicKeyEncrypted((PublicKey)this.to.elementAt(n), byArray, fileRandomStream);
                packetOutputStream.writePacket(this.PKE);
                ++n;
            }
            LiteralData literalData = new LiteralData(ArmouredMessage.byteEncode(string), "stuff.txt", 't');
            Signature signature = this.sign(literalData.data());
            packetOutputStream2.writePacket(signature);
            packetOutputStream2.writePacket(literalData);
            this.CKE = new ConvEncryptedData(byteArrayOutputStream2.toByteArray(), byArray, fileRandomStream);
            packetOutputStream.writePacket(this.PKE);
            packetOutputStream.writePacket(this.CKE);
            this.ciphertext_ = Armoury.message("MESSAGE", byteArrayOutputStream.toByteArray());
            this.authenticated_ = true;
            this.encrypted_ = true;
        }
    }

    public ArmouredMessage(String string, KeyGlob keyGlob, Passphrase passphrase) throws DecryptException, FormatException, IOException, InvalidChecksumException {
        this.ciphertext_ = string;
        if (string.indexOf("-----BEGIN PGP SIGNED MESSAGE-----") != -1) {
            String string2 = "";
            String string3 = "";
            Signature signature = null;
            PublicKey publicKey = null;
            int n = 0;
            n = string.indexOf("-----BEGIN PGP SIGNED MESSAGE-----");
            n = string.indexOf("\r\n\r\n", n);
            string2 = string.substring(n + 4, string.indexOf("\r\n-----BEGIN PGP SIGNATURE-----"));
            string3 = string.substring(string.indexOf("-----BEGIN PGP SIGNATURE-----"));
            this.plaintext_ = string2 = this.dashSubtract(string2);
            byte[] byArray = Armoury.strip(string3);
            signature = (Signature)PacketFactory.load(byArray);
            publicKey = keyGlob.getKey(signature.getKeyId());
            if (publicKey != null) {
                MD5 mD5 = new MD5();
                mD5.add(ArmouredMessage.byteEncode(string2));
                if (!signature.check(publicKey, mD5)) {
                    throw new DecryptException("Signature does not match message.");
                }
                this.authenticated_ = true;
                this.signedBy_ = keyGlob.getUserName(signature.getKeyId());
            }
        } else if (string.indexOf("-----BEGIN PGP MESSAGE-----") != -1) {
            Object object;
            byte[] byArray = Armoury.strip(string);
            PacketInputStream packetInputStream = new PacketInputStream(new ByteArrayInputStream(byArray));
            byte[] byArray2 = null;
            Packet packet = null;
            PacketInputStream packetInputStream2 = null;
            byte[] byArray3 = null;
            SecretKey secretKey = null;
            Signature signature = null;
            Packet packet2 = null;
            byte[] byArray4 = null;
            this.encrypted_ = true;
            while ((packet2 = packetInputStream.readPacket()) instanceof PublicKeyEncrypted) {
                if (byArray3 != null || (secretKey = keyGlob.getSecretKey((KeyID)(object = ((PublicKeyEncrypted)packet2).secretKeyID()), passphrase)) == null) continue;
                byArray3 = ((PublicKeyEncrypted)packet2).getKey(secretKey);
            }
            if (byArray3 == null) {
                throw new DecryptException("You don't possess the secret key needed to read this message");
            }
            if (!(packet2 instanceof ConvEncryptedData)) {
                throw new FormatException("Unexpected PGP packet: " + packet2.getClass().getName());
            }
            byArray2 = ((ConvEncryptedData)packet2).data(byArray3);
            packet = PacketFactory.read(new DataInputStream(new ByteArrayInputStream(byArray2)));
            packetInputStream2 = packet instanceof CompressedData ? ((CompressedData)packet).getData().toPacketInputStream() : new PacketInputStream(new ByteArrayInputStream(byArray2));
            while ((packet2 = packetInputStream2.readPacket()) != null) {
                if (packet2 instanceof Signature) {
                    signature = (Signature)packet2;
                    continue;
                }
                if (!(packet2 instanceof LiteralData)) continue;
                if (((LiteralData)packet2).mode() == 't') {
                    byArray4 = ((LiteralData)packet2).data();
                    this.plaintext_ = LegacyString.toString(byArray4);
                    continue;
                }
                throw new FormatException("Message contains binary data - PGP is needed to read it.");
            }
            if (signature != null) {
                MD5 mD5 = new MD5();
                object = keyGlob.getKey(signature.getKeyId());
                if (object != null) {
                    mD5.add(byArray4);
                    if (!signature.check((PublicKey)object, mD5)) {
                        throw new DecryptException("Signature does not match message.");
                    }
                    this.authenticated_ = true;
                    this.signedBy_ = keyGlob.getUserName(signature.getKeyId());
                }
            }
        } else {
            throw new FormatException("This class can only decrypt PGP *messages*");
        }
    }
}

