/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.Algorithm;
import cryptix.pgp.FormatException;
import cryptix.pgp.Packet;
import cryptix.pgp.PacketByteArray;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class CompressedData
extends Packet
implements Algorithm {
    private int algorithm;
    private PacketByteArray data;

    public int getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(int n) throws FormatException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.algorithm = n;
                break;
            }
            default: {
                throw new FormatException("Unknown compression algorithm (" + n + ")");
            }
        }
    }

    public PacketByteArray getData() {
        return this.data;
    }

    public void read(DataInput dataInput, int n) throws IOException, FormatException {
        byte[] byArray = null;
        this.setAlgorithm(dataInput.readByte());
        if (--n >= 0) {
            byArray = new byte[n - 1];
            dataInput.readFully(byArray);
        } else {
            InputStream inputStream = (InputStream)((Object)dataInput);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = bufferedInputStream.read();
            while (n2 != -1) {
                byteArrayOutputStream.write(n2);
                n2 = bufferedInputStream.read();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        this.data = new PacketByteArray(this.inflate(byArray));
    }

    public int write(DataOutput dataOutput) throws IOException {
        byte[] byArray = this.deflate(this.data.toByteArray());
        dataOutput.writeByte((byte)this.algorithm);
        dataOutput.write(byArray);
        return 1 + byArray.length;
    }

    public int getType() {
        return 8;
    }

    private byte[] inflate(byte[] byArray) throws IOException {
        try {
            InflaterInputStream inflaterInputStream;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            switch (this.algorithm) {
                case 1: {
                    Inflater inflater = new Inflater(true);
                    inflaterInputStream = new InflaterInputStream(byteArrayInputStream, inflater);
                    break;
                }
                default: {
                    return byArray;
                }
            }
            int n = ((InputStream)inflaterInputStream).read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = ((InputStream)inflaterInputStream).read();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IOException("Sorry - you need Java 1.1 to inflate compressed data");
        }
    }

    private byte[] deflate(byte[] byArray) throws IOException {
        try {
            DeflaterOutputStream deflaterOutputStream;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            switch (this.algorithm) {
                case 1: {
                    Deflater deflater = new Deflater(-1, true);
                    deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
                    break;
                }
                default: {
                    return byArray;
                }
            }
            int n = byteArrayInputStream.read();
            while (n != -1) {
                ((OutputStream)deflaterOutputStream).write(n);
                n = byteArrayInputStream.read();
            }
            ((OutputStream)deflaterOutputStream).flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IOException("Sorry - you need Java 1.1 to inflate compressed data");
        }
    }

    public CompressedData(PacketByteArray packetByteArray) {
        this.data = packetByteArray;
        this.algorithm = 1;
    }

    public CompressedData(PacketByteArray packetByteArray, int n) throws FormatException {
        this.data = packetByteArray;
        this.setAlgorithm(n);
    }

    public CompressedData(DataInput dataInput, int n) throws IOException {
        super(dataInput, n);
    }
}

