/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.math.BigInteger;
import cryptix.math.RandomStream;
import cryptix.security.HashMD5;
import cryptix.security.HashSHA;
import cryptix.security.MessageHash;
import cryptix.security.rsa.PublicKey;
import cryptix.util.core.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class HashFactory {
    private static final int NONE_IDENT = 0;
    private static final int MD5_IDENT = 1;
    private static final int SHA_IDENT = 2;
    private static final byte[] PADDING = new byte[]{0, 48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};

    public static MessageHash load(byte[] byArray) throws IOException {
        return HashFactory.read(new DataInputStream(new ByteArrayInputStream(byArray)));
    }

    public static byte[] save(MessageHash messageHash) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HashFactory.write(new DataOutputStream(byteArrayOutputStream), messageHash);
        return byteArrayOutputStream.toByteArray();
    }

    public static MessageHash read(DataInput dataInput) throws IOException {
        int n = dataInput.readByte() & 0xFF;
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                byte[] byArray = new byte[16];
                dataInput.readFully(byArray);
                return new HashMD5(byArray);
            }
            case 2: {
                byte[] byArray = new byte[20];
                dataInput.readFully(byArray);
                return new HashSHA(byArray);
            }
        }
        throw new IOException("Hash type (" + n + ") not recognized");
    }

    public static void write(DataOutput dataOutput, MessageHash messageHash) throws IOException {
        if (messageHash == null) {
            dataOutput.writeByte(0);
        } else {
            if (messageHash instanceof HashMD5) {
                dataOutput.writeByte(1);
            } else if (messageHash instanceof HashSHA) {
                dataOutput.writeByte(2);
            } else {
                throw new IOException("Hash type (" + messageHash + ") not recognized");
            }
            dataOutput.write(messageHash.toByteArray());
        }
    }

    public static String toString(MessageHash messageHash) {
        if (messageHash == null) {
            return "NONE:";
        }
        return messageHash.toString();
    }

    public static MessageHash fromString(String string) {
        if (string.startsWith("MD5")) {
            return new HashMD5(Hex.fromString((String)string.substring(4)));
        }
        if (string.startsWith("SHA")) {
            return new HashSHA(Hex.fromString((String)string.substring(4)));
        }
        if (string.startsWith("NONE")) {
            return null;
        }
        throw new RuntimeException("string is not a hash" + string);
    }

    public static String toFilename(MessageHash messageHash) {
        if (messageHash == null) {
            return "MT";
        }
        return messageHash.toString().replace(':', '_');
    }

    public static BigInteger bigIntFromHash(PublicKey publicKey, byte[] byArray, RandomStream randomStream) {
        int n;
        if (randomStream == null) {
            return HashFactory.bigIntFromHash(publicKey, byArray);
        }
        if (byArray.length != 16) {
            throw new Error("The code for hashes of lengths other than 16 is not in place yet.");
        }
        int n2 = publicKey.bitLength() / 8;
        int n3 = n2 - (6 + byArray.length);
        byte[] byArray2 = new byte[n2];
        int n4 = 0;
        byArray2[n4++] = 0;
        byArray2[n4++] = 2;
        int n5 = n3;
        while (n5 > 0) {
            while ((n = (int)randomStream.read()) == 0) {
            }
            byArray2[n4++] = n;
            --n5;
        }
        byArray2[n4++] = 0;
        byArray2[n4++] = 1;
        System.arraycopy(byArray, 0, byArray2, n4, byArray.length);
        n5 = 0;
        n = byArray.length - 1;
        while (n >= 0) {
            n5 += byArray[n] & 0xFF;
            --n;
        }
        n4 += byArray.length;
        byArray2[n4++] = (byte)(n5 >>> 8 & 0xFF);
        byArray2[n4++] = (byte)(n5 & 0xFF);
        return publicKey.encrypt(new BigInteger(byArray2));
    }

    public static BigInteger bigIntFromHash(PublicKey publicKey, byte[] byArray) {
        if (byArray.length != 16) {
            throw new Error("The code for hashes of lengths other than 16 is not in place yet.");
        }
        int n = publicKey.bitLength() / 8;
        int n2 = n - (19 + byArray.length);
        byte[] byArray2 = new byte[n];
        byArray2[0] = 0;
        byArray2[1] = 1;
        int n3 = 2;
        while (n3 < n2) {
            byArray2[n3] = -1;
            ++n3;
        }
        System.arraycopy(PADDING, 0, byArray2, n2, 19);
        System.arraycopy(byArray, 0, byArray2, n2 + 19, byArray.length);
        return new BigInteger(byArray2);
    }

    public static byte[] hashFromBigInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length - 18;
        if (n < 0) {
            throw new Error("The code for hashes of lengths other than 16 is not in place yet.");
        }
        int n2 = 0;
        int n3 = n;
        while (n3 < n + 16) {
            n2 += byArray[n3] & 0xFF;
            ++n3;
        }
        if (n2 >> 8 != (byArray[n + 16] & 0xFF)) {
            return null;
        }
        if ((n2 & 0xFF) != (byArray[n + 17] & 0xFF)) {
            return null;
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n, byArray2, 0, 16);
        return byArray2;
    }

    private HashFactory() {
    }
}

