/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.FormatException;
import cryptix.pgp.Packet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class KeyRingTrust
extends Packet {
    public static final KeyRingTrust UNDEF = new KeyRingTrust(0);
    public static final KeyRingTrust UNKNOWN = new KeyRingTrust(1);
    public static final KeyRingTrust NOTUSUALLY = new KeyRingTrust(2);
    public static final KeyRingTrust INTRODUCER1 = new KeyRingTrust(3);
    public static final KeyRingTrust INTRODUCER2 = new KeyRingTrust(4);
    public static final KeyRingTrust USUALLY = new KeyRingTrust(5);
    public static final KeyRingTrust ALWAYS = new KeyRingTrust(6);
    public static final KeyRingTrust SECRING = new KeyRingTrust(7);
    private byte trust;

    public int trustValue() {
        return this.trust;
    }

    public void read(DataInput dataInput, int n) throws IOException {
        if (n != 1) {
            throw new FormatException("Length invalid.");
        }
        this.trust = dataInput.readByte();
    }

    public int write(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.trust);
        return 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("trust packet: ");
        if ((this.trust & 0x20) != 0) {
            return stringBuffer.append("DISABLED").toString();
        }
        switch (this.trust & 7) {
            case 0: {
                stringBuffer.append("undef trust");
                break;
            }
            case 1: {
                stringBuffer.append("unknown trust");
                break;
            }
            case 2: {
                stringBuffer.append("usually NOT trusted");
                break;
            }
            case 3: {
                stringBuffer.append("introducer 1");
                break;
            }
            case 4: {
                stringBuffer.append("introducer 2");
                break;
            }
            case 5: {
                stringBuffer.append("usually DO trust");
                break;
            }
            case 6: {
                stringBuffer.append("always trust");
                break;
            }
            case 7: {
                stringBuffer.append("secring trust");
                break;
            }
        }
        if ((this.trust & 0x80) != 0) {
            stringBuffer.append(" BUCK STOPS here");
        }
        return stringBuffer.toString();
    }

    public int getType() {
        return 12;
    }

    public int getDefaultLengthSpecifier() {
        return 1;
    }

    public KeyRingTrust(byte by) {
        this.trust = by;
    }

    public KeyRingTrust(DataInput dataInput, int n) throws IOException {
        super(dataInput, n);
    }
}

