/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class Packet {
    private static final int CTB_DESIGNATOR = 128;
    private static final int CTB_TYPE_MASK = 124;
    private static final int CTB_TYPE_SHIFT = 2;
    private static final int CTB_LLEN_MASK = 3;
    public static final int PUBLIC_KEY_ENCRYPTED = 1;
    public static final int SIGNATURE = 2;
    public static final int MESSAGE_DIGEST = 3;
    public static final int SECRET_KEY = 5;
    public static final int PUBLIC_KEY = 6;
    public static final int COMPRESSED = 8;
    public static final int CONV_ENCRYPTED = 9;
    public static final int PLAINTEXT = 11;
    public static final int TRUST = 12;
    public static final int USER_ID = 13;
    public static final int COMMENT = 14;

    public static final boolean isCTB(int n) {
        return (n & 0x80) == 128;
    }

    public static final int ctbToType(int n) {
        return (n & 0x7C) >> 2;
    }

    public static final int ctbToLengthSpecifier(int n) {
        return n & 3;
    }

    public static final int makeCTB(int n, int n2) {
        return 0x80 | n << 2 | n2;
    }

    public static boolean isLegalPacketType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public final void load(byte[] byArray) throws IOException {
        this.load(byArray, 0, byArray.length);
    }

    public final void load(byte[] byArray, int n) throws IOException {
        int n2 = byArray.length - n;
        if (n2 <= 0) {
            throw new IOException("Offset too big or buffer too short.");
        }
        this.load(byArray, n, n2);
    }

    public final void load(byte[] byArray, int n, int n2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (n > 0) {
            ((InputStream)byteArrayInputStream).skip(n);
        }
        this.read(new DataInputStream(byteArrayInputStream), n2);
    }

    public final byte[] save() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(new DataOutputStream(byteArrayOutputStream));
        return byteArrayOutputStream.toByteArray();
    }

    public int getDefaultLengthSpecifier() {
        return 2;
    }

    public abstract int getType();

    public abstract void read(DataInput var1, int var2) throws IOException;

    public abstract int write(DataOutput var1) throws IOException;

    protected Packet() {
    }

    protected Packet(DataInput dataInput, int n) throws IOException {
        this.read(dataInput, n);
    }
}

