/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.math.BigInteger;
import cryptix.math.MPI;
import cryptix.pgp.Certificate;
import cryptix.pgp.FormatException;
import cryptix.security.rsa.PublicKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class PublicKeyCertificate
extends Certificate {
    private PublicKey publicKey;

    public void read(DataInput dataInput, int n) throws IOException {
        super.read(dataInput, n);
        if (dataInput.readByte() != 1) {
            throw new FormatException("Incorrect algorithm identifier.");
        }
        BigInteger bigInteger = MPI.read(dataInput);
        BigInteger bigInteger2 = MPI.read(dataInput);
        this.publicKey = new PublicKey(bigInteger, bigInteger2);
    }

    public int write(DataOutput dataOutput) throws IOException {
        int n = super.write(dataOutput) + 1;
        dataOutput.write(1);
        byte[] byArray = MPI.save(this.publicKey.n());
        dataOutput.write(byArray);
        n += byArray.length;
        byArray = MPI.save(this.publicKey.e());
        dataOutput.write(byArray);
        return n += byArray.length;
    }

    public PublicKey publicKey() {
        return this.publicKey;
    }

    public PublicKey publickey() {
        return this.publicKey;
    }

    public String toString() {
        return "Public Key Certificate: " + super.toString() + "\n" + this.publicKey.toString();
    }

    public PublicKeyCertificate(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PublicKeyCertificate(DataInput dataInput, int n) throws IOException {
        super(dataInput, n);
    }
}

