/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.KeyID;
import cryptix.pgp.KeyRing;
import cryptix.pgp.KeyRingEntry;
import cryptix.pgp.KeyRingTrust;
import cryptix.pgp.PacketInputStream;
import cryptix.security.rsa.PublicKey;
import cryptix.util.EmailAddress;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class PublicKeyRing
extends KeyRing {
    public PublicKey getKey(String string) throws IOException {
        PublicKey publicKey;
        KeyID keyID = (KeyID)this.users.get(string);
        if (keyID != null && (publicKey = this.getKey(keyID)) != null) {
            return publicKey;
        }
        return this.getIfBegins(this.users.keys(), string);
    }

    public PublicKey getKey(KeyID keyID) throws IOException {
        return this.getPublicKey(keyID);
    }

    public PublicKey getKey(EmailAddress emailAddress) throws IOException {
        return this.getPublicKey(emailAddress);
    }

    protected final void init(PacketInputStream packetInputStream) throws IOException {
        KeyRingEntry keyRingEntry;
        while ((keyRingEntry = packetInputStream.readKeyRingEntry(KeyRingTrust.UNDEF)) != null) {
            if (keyRingEntry.certificate().expired()) continue;
            this.add(keyRingEntry);
        }
    }

    public PublicKeyRing() {
    }

    public PublicKeyRing(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public PublicKeyRing(String string) throws FileNotFoundException, IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        this.init(new PacketInputStream(fileInputStream));
        fileInputStream.close();
    }
}

