/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.provider.key.RawSecretKey;
import cryptix.security.CryptoError;
import java.security.Cipher;
import java.security.Key;

public abstract class BlockCipher {
    private int userKeyLength;
    private RawSecretKey key;
    protected Cipher cipher;
    protected int blockSize;

    public final int blockLength() {
        return this.cipher.blockSize();
    }

    public final int keyLength() {
        return this.userKeyLength;
    }

    public final void encrypt(byte[] byArray) {
        this.encrypt(byArray, byArray);
    }

    public final void encrypt(byte[] byArray, byte[] byArray2) {
        if (byArray.length != this.blockSize || byArray2.length != this.blockSize) {
            throw new CryptoError(this.cipher.getAlgorithm() + ": Encrypt buffer length is incorrect");
        }
        this.encrypt(byArray, 0, byArray2, 0);
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(this.cipher.getAlgorithm() + ": Negative offset not allowed");
        }
        if ((long)n + (long)this.blockSize > (long)byArray.length || (long)n2 + (long)this.blockSize > (long)byArray2.length) {
            throw new ArrayIndexOutOfBoundsException(this.cipher.getAlgorithm() + ": Offset past end of array");
        }
        try {
            if (this.cipher.getState() != 1) {
                this.cipher.initEncrypt((Key)this.key);
            }
            this.cipher.update(byArray, n, this.blockSize, byArray2, n2);
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public final void decrypt(byte[] byArray) {
        this.decrypt(byArray, byArray);
    }

    public final void decrypt(byte[] byArray, byte[] byArray2) {
        if (byArray.length != this.blockSize || byArray2.length != this.blockSize) {
            throw new CryptoError(this.cipher.getAlgorithm() + ": Decrypt buffer length is incorrect");
        }
        this.decrypt(byArray, 0, byArray2, 0);
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(this.cipher.getAlgorithm() + ": Negative offset not allowed");
        }
        if ((long)n + (long)this.blockSize > (long)byArray.length || (long)n2 + (long)this.blockSize > (long)byArray2.length) {
            throw new ArrayIndexOutOfBoundsException(this.cipher.getAlgorithm() + ": Offset past end of array");
        }
        try {
            if (this.cipher.getState() != 2) {
                this.cipher.initDecrypt((Key)this.key);
            }
            this.cipher.update(byArray, n, this.blockSize, byArray2, n2);
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    protected BlockCipher(Cipher cipher, byte[] byArray) {
        this.cipher = cipher;
        this.userKeyLength = byArray.length;
        this.key = new RawSecretKey(cipher.getAlgorithm(), byArray);
        this.blockSize = cipher.blockSize();
    }
}

