/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.security.BlockCipher;
import cryptix.security.StreamCipher;

public class CipherFeedback
extends StreamCipher {
    protected byte[] ivBlock;
    protected byte[] xorBlock;
    protected BlockCipher cipher;
    protected int currentByte;
    protected int length;

    public int keyLength() {
        return this.cipher.keyLength();
    }

    public void reset(byte[] byArray) {
        this.ivBlock = byArray;
        this.currentByte = 0;
        this.cipher.encrypt(this.ivBlock, this.xorBlock);
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n4 + n2] = this.encryptByte(byArray[n4 + n]);
            ++n4;
        }
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n4 + n2] = this.decryptByte(byArray[n4 + n]);
            ++n4;
        }
    }

    private byte encryptByte(byte by) {
        if (this.currentByte >= this.length) {
            this.currentByte = 0;
            this.cipher.encrypt(this.ivBlock, this.xorBlock);
        }
        this.ivBlock[this.currentByte] = by = (byte)(by ^ this.xorBlock[this.currentByte]);
        ++this.currentByte;
        return by;
    }

    private byte decryptByte(byte by) {
        if (this.currentByte >= this.length) {
            this.currentByte = 0;
            this.cipher.encrypt(this.ivBlock, this.xorBlock);
        }
        this.ivBlock[this.currentByte] = by;
        by = (byte)(by ^ this.xorBlock[this.currentByte]);
        ++this.currentByte;
        return by;
    }

    public CipherFeedback(BlockCipher blockCipher, byte[] byArray) {
        this.length = blockCipher.blockLength();
        this.cipher = blockCipher;
        this.xorBlock = new byte[this.length];
        this.reset(byArray);
    }
}

