/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.mime.LegacyString;
import cryptix.security.CryptoError;
import cryptix.security.HashSHA0;
import cryptix.security.MessageDigest;
import cryptix.util.core.Hex;
import java.io.PrintWriter;

public class SHA0
extends MessageDigest
implements Cloneable {
    public static final int HASH_LENGTH = 20;
    public static final int DATA_LENGTH = 64;

    private static java.security.MessageDigest getDigestImpl() {
        try {
            return java.security.MessageDigest.getInstance("SHA-0", "Cryptix");
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static byte[] hash(String string) {
        try {
            return java.security.MessageDigest.getInstance("SHA-0", "Cryptix").digest(LegacyString.toByteArray(string));
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static byte[] hash(byte[] byArray) {
        try {
            return java.security.MessageDigest.getInstance("SHA-0", "Cryptix").digest(byArray);
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static HashSHA0 hashAsMessageHash(String string) {
        try {
            return new HashSHA0(java.security.MessageDigest.getInstance("SHA-0", "Cryptix").digest(LegacyString.toByteArray(string)));
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static HashSHA0 hashAsMessageHash(byte[] byArray) {
        try {
            return new HashSHA0(java.security.MessageDigest.getInstance("SHA-0", "Cryptix").digest(byArray));
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static HashSHA0 CreateHash(byte[] byArray) {
        return new HashSHA0(byArray);
    }

    public static void main(String[] stringArray) {
        try {
            SHA0.self_test(new PrintWriter(System.out, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void self_test(PrintWriter printWriter) throws Exception {
        SHA0.test(printWriter, "", "F96CEA198AD1DD5617AC084A3D92C6107708C0EF");
        SHA0.test(printWriter, "abc", "0164B8A914CD2A5E74C4F7FF082C4D97F1EDF880");
        SHA0.test(printWriter, "message digest", "C1B0F222D150EBB9AA36A40CAFDC8BCBED830B14");
    }

    private static void test(PrintWriter printWriter, String string, String string2) throws Exception {
        java.security.MessageDigest messageDigest = java.security.MessageDigest.getInstance("SHA-0", "Cryptix");
        messageDigest.update(LegacyString.toByteArray(string));
        String string3 = Hex.toString((byte[])messageDigest.digest());
        printWriter.println("Message:   \"" + string + "\"");
        printWriter.println("calc hash: " + string3);
        printWriter.println("real hash: " + string2);
        if (!string2.equalsIgnoreCase(string3)) {
            printWriter.println("************ SHA-0 FAILED ************");
            throw new Exception("SHA-0 (V2.2) Failed test <" + string + ">");
        }
        printWriter.println("Good");
    }

    public SHA0() {
        super(SHA0.getDigestImpl());
    }
}

