/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security.rsa;

import cryptix.math.BigInteger;
import cryptix.security.MD5;

public class PublicKey {
    protected BigInteger n_;
    protected BigInteger e_;

    public final BigInteger n() {
        return new BigInteger(this.n_);
    }

    public final BigInteger e() {
        return new BigInteger(this.e_);
    }

    public void copy(Object object) {
        PublicKey publicKey = (PublicKey)object;
        this.n_ = new BigInteger(publicKey.n_);
        this.e_ = new BigInteger(publicKey.e_);
    }

    public boolean equals(Object object) {
        if (object instanceof PublicKey) {
            PublicKey publicKey = (PublicKey)object;
            if (this.n_.equals(publicKey.n_) && this.e_.equals(publicKey.e_)) {
                return true;
            }
        }
        return false;
    }

    public final byte[] id() {
        byte[] byArray = this.n_.toByteArray();
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, byArray.length - 8, byArray2, 0, 8);
        return byArray2;
    }

    public final byte[] fingerPrint() {
        byte[] byArray = this.e_.toByteArray();
        byte[] byArray2 = this.n_.toByteArray();
        MD5 mD5 = new MD5();
        mD5.add(byArray2);
        mD5.add(byArray);
        return mD5.digest();
    }

    public final int bitLength() {
        return this.n_.bitLength();
    }

    public BigInteger encrypt(BigInteger bigInteger) {
        return new BigInteger(bigInteger).modExp(this.e_, this.n_);
    }

    public String toString() {
        return "n:" + this.n_ + "\ne:" + this.e_;
    }

    protected PublicKey() {
    }

    public PublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.n_ = new BigInteger(bigInteger);
        this.e_ = new BigInteger(bigInteger2);
    }

    public PublicKey(PublicKey publicKey) {
        this.copy(publicKey);
    }
}

