/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public final class EmailAddress {
    private String address;
    private int atPos;
    private Vector hostpath;

    public String toString() {
        return this.address;
    }

    public String user() {
        return this.address.substring(0, this.atPos);
    }

    public String host() {
        return this.address.substring(this.atPos + 1);
    }

    public Vector hostPath() {
        if (this.hostpath == null) {
            int n;
            this.hostpath = new Vector();
            int n2 = this.atPos;
            while ((n = this.address.indexOf(".", n2 + 1)) != -1) {
                this.hostpath.addElement(this.address.substring(n2 + 1, n));
                n2 = n;
            }
            this.hostpath.addElement(this.address.substring(n2 + 1));
        }
        return this.hostpath;
    }

    public boolean equals(Object object) {
        if (object instanceof EmailAddress) {
            EmailAddress emailAddress = (EmailAddress)object;
            return emailAddress.toString().equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public static void main(String[] stringArray) {
        try {
            EmailAddress.self_test(new PrintWriter(System.out, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void self_test(PrintWriter printWriter) throws IOException {
        EmailAddress emailAddress = new EmailAddress("Ian Brown <Ian.Brown@newcastle.ac.uk>");
        printWriter.println("User: " + emailAddress.user());
        Vector vector = emailAddress.hostPath();
        int n = 0;
        while (n < vector.size()) {
            printWriter.println("Next domain: " + vector.elementAt(n));
            ++n;
        }
    }

    public EmailAddress(String string) throws IOException {
        int n = string.indexOf("<") + 1;
        int n2 = string.lastIndexOf(">");
        this.address = n != 0 && n2 != -1 && n2 > n ? string.substring(n, n2) : string;
        this.address = this.address.toLowerCase();
        this.atPos = this.address.indexOf("@");
        if (this.atPos == -1) {
            throw new IOException("Invalid Internet e-mail address: " + this.address);
        }
    }
}

