/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.Cipher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SymmetricCipher;

public final class Square
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel;
    private static final PrintWriter err;
    private static NativeLink linkStatus;
    private static final byte[] SE;
    private static final byte[] SD;
    private static final int[] TE;
    private static final int[] TD;
    private static final int BLOCK_SIZE = 16;
    private static final int R = 8;
    private static final int ROOT = 501;
    private static final int[] OFFSET;
    private static final String[][] tests;
    private long native_cookie;
    private Object native_lock;
    private int[][] sKey = new int[9][4];

    private static void debug(String string) {
        err.println("Square: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(Square.getLibMajorVersion(), Square.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    Square.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                Square.debug("Using native library? " + (this.native_lock != null));
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    Square.debug(string + " in native_finalize");
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 16;
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.makeKey(key, true);
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException {
        this.makeKey(key, false);
    }

    protected int engineUpdate(byte[] object, int n, int n2, byte[] byArray, int n3) {
        Object object2;
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = n2 / 16;
        n2 = n4 * 16;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            object2 = new byte[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
            n = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n < 0 || (long)n + (long)n2 > (long)((byte[])object).length || n3 < 0 || (long)n3 + (long)n2 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(this.getAlgorithm() + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n5 = 0;
                while (n5 < n4) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n, byArray, n3, bl) == 0) {
                        throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                    }
                    n += 16;
                    n3 += 16;
                    ++n5;
                }
            }
        } else if (bl) {
            int n6 = 0;
            while (n6 < n4) {
                this.square((byte[])object, n, byArray, n3, TE, SE);
                n += 16;
                n3 += 16;
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < n4) {
                this.square((byte[])object, n, byArray, n3, TD, SD);
                n += 16;
                n3 += 16;
                ++n7;
            }
        }
        return n2;
    }

    private void makeKey(Key key, boolean bl) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var5_7 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        Square.debug(error + ". Will use 100% Java.");
                    }
                }
            }
        }
        int n = 0;
        if (bl) {
            int n2 = 0;
            while (n2 < 4) {
                this.sKey[0][n2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                ++n2;
            }
            n2 = 1;
            while (n2 < 9) {
                n = n2 - 1;
                this.sKey[n2][0] = this.sKey[n][0] ^ Square.rot32L(this.sKey[n][3], 8) ^ OFFSET[n];
                this.sKey[n2][1] = this.sKey[n][1] ^ this.sKey[n2][0];
                this.sKey[n2][2] = this.sKey[n][2] ^ this.sKey[n2][1];
                this.sKey[n2][3] = this.sKey[n][3] ^ this.sKey[n2][2];
                Square.transform(this.sKey[n], this.sKey[n]);
                ++n2;
            }
        } else {
            int[][] nArray = new int[9][4];
            int n3 = 0;
            while (n3 < 4) {
                nArray[0][n3] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                ++n3;
            }
            n3 = 1;
            while (n3 < 9) {
                n = n3 - 1;
                nArray[n3][0] = nArray[n][0] ^ Square.rot32L(nArray[n][3], 8) ^ OFFSET[n];
                nArray[n3][1] = nArray[n][1] ^ nArray[n3][0];
                nArray[n3][2] = nArray[n][2] ^ nArray[n3][1];
                nArray[n3][3] = nArray[n][3] ^ nArray[n3][2];
                ++n3;
            }
            n3 = 0;
            while (n3 < 8) {
                System.arraycopy(nArray[8 - n3], 0, this.sKey[n3], 0, 4);
                ++n3;
            }
            Square.transform(nArray[0], this.sKey[8]);
        }
    }

    private static void transform(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < 4) {
            int n2 = nArray[n];
            int n3 = n2 >>> 8;
            int n4 = n2 >>> 16;
            int n5 = n2 >>> 24;
            int n6 = ((Square.mul(n5, 2) ^ Square.mul(n4, 3) ^ n3 ^ n2) & 0xFF) << 24;
            n6 ^= ((n5 ^ Square.mul(n4, 2) ^ Square.mul(n3, 3) ^ n2) & 0xFF) << 16;
            n6 ^= ((n5 ^ n4 ^ Square.mul(n3, 2) ^ Square.mul(n2, 3)) & 0xFF) << 8;
            nArray2[n] = n6 ^= (Square.mul(n5, 3) ^ n4 ^ n3 ^ Square.mul(n2, 2)) & 0xFF;
            ++n;
        }
    }

    private static int rot32L(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static int rot32R(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    private static final int mul(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        n &= 0xFF;
        n2 &= 0xFF;
        int n3 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n3 ^= n;
            }
            if ((n <<= 1) > 255) {
                n ^= 0x1F5;
            }
            n2 >>>= 1;
        }
        return n3 & 0xFF;
    }

    private void square(byte[] byArray, int n, byte[] byArray2, int n2, int[] nArray, byte[] byArray3) {
        int n3 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n4 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n5 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n6 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        n3 ^= this.sKey[0][0];
        n4 ^= this.sKey[0][1];
        n5 ^= this.sKey[0][2];
        n6 ^= this.sKey[0][3];
        int n7 = 1;
        while (n7 < 8) {
            int n8 = nArray[n3 >>> 24 & 0xFF] ^ Square.rot32R(nArray[n4 >>> 24 & 0xFF], 8) ^ Square.rot32R(nArray[n5 >>> 24 & 0xFF], 16) ^ Square.rot32R(nArray[n6 >>> 24 & 0xFF], 24) ^ this.sKey[n7][0];
            int n9 = nArray[n3 >>> 16 & 0xFF] ^ Square.rot32R(nArray[n4 >>> 16 & 0xFF], 8) ^ Square.rot32R(nArray[n5 >>> 16 & 0xFF], 16) ^ Square.rot32R(nArray[n6 >>> 16 & 0xFF], 24) ^ this.sKey[n7][1];
            int n10 = nArray[n3 >>> 8 & 0xFF] ^ Square.rot32R(nArray[n4 >>> 8 & 0xFF], 8) ^ Square.rot32R(nArray[n5 >>> 8 & 0xFF], 16) ^ Square.rot32R(nArray[n6 >>> 8 & 0xFF], 24) ^ this.sKey[n7][2];
            int n11 = nArray[n3 & 0xFF] ^ Square.rot32R(nArray[n4 & 0xFF], 8) ^ Square.rot32R(nArray[n5 & 0xFF], 16) ^ Square.rot32R(nArray[n6 & 0xFF], 24) ^ this.sKey[n7][3];
            n3 = n8;
            n4 = n9;
            n5 = n10;
            n6 = n11;
            ++n7;
        }
        n7 = 0;
        int n12 = 24;
        while (n7 < 4) {
            int n13 = (byArray3[n3 >>> n12 & 0xFF] & 0xFF) << 24 | (byArray3[n4 >>> n12 & 0xFF] & 0xFF) << 16 | (byArray3[n5 >>> n12 & 0xFF] & 0xFF) << 8 | byArray3[n6 >>> n12 & 0xFF] & 0xFF;
            byArray2[n2++] = (byte)((n13 ^= this.sKey[8][n7]) >>> 24 & 0xFF);
            byArray2[n2++] = (byte)(n13 >>> 16 & 0xFF);
            byArray2[n2++] = (byte)(n13 >>> 8 & 0xFF);
            byArray2[n2++] = (byte)(n13 & 0xFF);
            ++n7;
            n12 -= 8;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            Square.self_test();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void self_test() throws Exception {
        Cipher cipher = Cipher.getInstance("Square", "Cryptix");
        int n = 0;
        while (n < tests.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("Square", Hex.fromString(tests[n][0]));
            byte[] byArray = Hex.fromString(tests[n][1]);
            byte[] byArray2 = Hex.fromString(tests[n][2]);
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray3 = cipher.crypt(byArray);
            if (!ArrayUtil.areEqual(byArray2, byArray3)) {
                System.out.println("     input: " + Hex.toString(byArray));
                System.out.println("  computed: " + Hex.toString(byArray3));
                System.out.println(" certified: " + Hex.toString(byArray2));
                throw new CryptixException("encrypt #" + n + " failed");
            }
            cipher.initDecrypt(rawSecretKey);
            byArray3 = cipher.crypt(byArray2);
            if (!ArrayUtil.areEqual(byArray, byArray3)) {
                throw new CryptixException("decrypt #" + n + " failed");
            }
            ++n;
        }
        if (debuglevel > 0) {
            Square.debug("Self-test OK");
        }
    }

    public Square() {
        super(false, false, "Cryptix");
        this.link();
    }

    static {
        int n;
        debuglevel = Debug.getLevel("Square");
        err = Debug.getOutput();
        linkStatus = new NativeLink("Square", 2, 3);
        SE = new byte[256];
        SD = new byte[256];
        TE = new int[256];
        TD = new int[256];
        OFFSET = new int[8];
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byArray[0] = 1;
        int n2 = 1;
        while (n2 < 256) {
            n = byArray[n2 - 1] << 1;
            if ((n & 0x100) != 0) {
                n ^= 0x1F5;
            }
            byArray[n2] = (byte)n;
            byArray2[n & 0xFF] = (byte)n2;
            ++n2;
        }
        Square.SE[0] = 0;
        Square.SE[1] = 1;
        n2 = 2;
        while (n2 < 256) {
            Square.SE[n2] = byArray[255 - byArray2[n2] & 0xFF];
            ++n2;
        }
        int[] nArray = new int[]{1, 3, 5, 15, 31, 61, 123, 214};
        n2 = 0;
        while (n2 < 256) {
            int n3 = 177;
            n = 0;
            while (n < 8) {
                int n4 = SE[n2] & nArray[n] & 0xFF;
                n4 ^= n4 >>> 4;
                n4 ^= n4 >>> 2;
                n4 ^= n4 >>> 1;
                n3 ^= (n4 &= 1) << n;
                ++n;
            }
            Square.SE[n2] = (byte)n3;
            Square.SD[n3] = (byte)n2;
            ++n2;
        }
        Square.OFFSET[0] = 1;
        n2 = 1;
        while (n2 < 8) {
            Square.OFFSET[n2] = Square.mul(OFFSET[n2 - 1], 2);
            int n5 = n2 - 1;
            OFFSET[n5] = OFFSET[n5] << 24;
            ++n2;
        }
        OFFSET[7] = OFFSET[7] << 24;
        n2 = 0;
        while (n2 < 256) {
            int n6 = SE[n2] & 0xFF;
            int n7 = SD[n2] & 0xFF;
            Square.TE[n2] = SE[n2 & 3] == 0 ? 0 : Square.mul(n6, 2) << 24 | n6 << 16 | n6 << 8 | Square.mul(n6, 3);
            Square.TD[n2] = SD[n2 & 3] == 0 ? 0 : Square.mul(n7, 14) << 24 | Square.mul(n7, 9) << 16 | Square.mul(n7, 13) << 8 | Square.mul(n7, 11);
            ++n2;
        }
        tests = new String[][]{{"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F"}, {"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F7C3491D94994E70F0EC2E7A5CCB5A14F"}};
    }
}

