/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.provider.md.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.security.InvalidParameterTypeException;
import java.security.MessageDigest;
import java.security.NoSuchParameterException;
import java.security.Parameterized;
import java.security.Security;
import java.security.VariableLengthDigest;

public class HAVAL
extends MessageDigest
implements Parameterized,
VariableLengthDigest,
Cloneable {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("HAVAL");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("HAVAL", 2, 3);
    private static final int VERSION = 1;
    private static final int DEFAULT_PASSES = 3;
    private static final int DEFAULT_BITLENGTH = 256;
    private static final int BLOCK_LENGTH = 128;
    private static final int CONTEXT_LENGTH = 8;
    private boolean native_ok;
    private int passes = 3;
    private int bitLength = 256;
    private long count;
    private int[] context = new int[8];
    private byte[] buffer = new byte[128];
    private int[] X = new int[32];

    private static void debug(String string) {
        err.println("HAVAL: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(HAVAL.getLibMajorVersion(), HAVAL.getLibMinorVersion());
                    }
                    if (linkStatus.useNative()) {
                        this.native_ok = true;
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    HAVAL.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                HAVAL.debug("Using native library? " + this.native_ok);
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private static native String native_hash(int[] var0, byte[] var1, int var2, int var3);

    public Object clone() {
        return new HAVAL(this);
    }

    protected void engineReset() {
        this.context[0] = 608135816;
        this.context[1] = -2052912941;
        this.context[2] = 320440878;
        this.context[3] = 57701188;
        this.context[4] = -1542899678;
        this.context[5] = 698298832;
        this.context[6] = 137296536;
        this.context[7] = -330404727;
        this.count = 0L;
        int n = 0;
        while (n < 128) {
            this.buffer[n] = 0;
            ++n;
        }
    }

    protected void engineUpdate(byte by) {
        int n = (int)(this.count % 128L);
        ++this.count;
        this.buffer[n] = by;
        if (n == 127) {
            this.transform(this.buffer, 0);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || (long)n + (long)n2 > (long)byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = (int)(this.count % 128L);
        this.count += (long)n2;
        int n4 = 128 - n3;
        int n5 = 0;
        if (n2 >= n4) {
            System.arraycopy(byArray, n, this.buffer, n3, n4);
            this.transform(this.buffer, 0);
            n5 = n4;
            while (n5 + 128 - 1 < n2) {
                this.transform(byArray, n + n5);
                n5 += 128;
            }
            n3 = 0;
        }
        if (n5 < n2) {
            System.arraycopy(byArray, n + n5, this.buffer, n3, n2 - n5);
        }
    }

    protected byte[] engineDigest() {
        int n = (int)(this.count % 128L);
        int n2 = n < 118 ? 118 - n : 246 - n;
        byte[] byArray = new byte[n2 + 10];
        byArray[0] = 1;
        byArray[n2] = (byte)((this.bitLength & 3) << 6 | (this.passes & 7) << 3 | 1);
        byArray[n2 + 1] = (byte)(this.bitLength >>> 2);
        int n3 = 0;
        while (n3 < 8) {
            byArray[n2 + 2 + n3] = (byte)(this.count * 8L >>> 8 * n3);
            ++n3;
        }
        this.engineUpdate(byArray, 0, byArray.length);
        this.tailorDigestBits();
        byte[] byArray2 = new byte[this.bitLength / 8];
        int n4 = 0;
        while (n4 < this.bitLength / 32) {
            int n5 = 0;
            while (n5 < 4) {
                byArray2[n4 * 4 + n5] = (byte)(this.context[n4] >>> 8 * n5);
                ++n5;
            }
            ++n4;
        }
        this.engineReset();
        return byArray2;
    }

    protected int engineGetDigestLength() {
        return this.bitLength / 8;
    }

    public void setParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        this.engineSetParameter(string, object);
    }

    public Object getParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        return this.engineGetParameter(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (string.equalsIgnoreCase("passes")) {
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("passes.HAVAL");
            this.setPasses((Integer)object);
            return;
        } else {
            if (!string.equalsIgnoreCase("bitLength")) throw new NoSuchParameterException(string + ".HAVAL");
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("bitLength.HAVAL");
            this.setBitLength((Integer)object);
        }
    }

    protected Object engineGetParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        if (string.equalsIgnoreCase("passes")) {
            return new Integer(this.passes);
        }
        if (string.equalsIgnoreCase("bitLength")) {
            return new Integer(this.bitLength);
        }
        throw new NoSuchParameterException(string + ".HAVAL");
    }

    public void setPasses(int n) {
        if (n < 3 || n > 5) {
            throw new InvalidParameterException();
        }
        this.passes = n;
        this.engineReset();
    }

    public void setBitLength(int n) {
        if (n % 32 != 0 || n < 128 || n > 256) {
            throw new InvalidParameterException();
        }
        this.bitLength = n;
        this.engineReset();
    }

    public void setDigestLength(int n) {
        this.setBitLength(n * 8);
    }

    private void transform(byte[] byArray, int n) {
        if (this.native_ok) {
            if (this.context.length != 8 || n < 0 || (long)n + 128L > (long)byArray.length) {
                throw new InternalError(this.getAlgorithm() + ": context.length != " + "8" + " || offset < 0 || " + "(long)offset + " + "128" + " > block.length");
            }
            linkStatus.check(HAVAL.native_hash(this.context, byArray, n, this.passes));
            return;
        }
        int n2 = 0;
        while (n2 < 32) {
            this.X[n2] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            ++n2;
        }
        n2 = this.context[0];
        int n3 = this.context[1];
        int n4 = this.context[2];
        int n5 = this.context[3];
        int n6 = this.context[4];
        int n7 = this.context[5];
        int n8 = this.context[6];
        int n9 = this.context[7];
        n9 = this.FF_1(n9, n8, n7, n6, n5, n4, n3, n2, this.X[0]);
        n8 = this.FF_1(n8, n7, n6, n5, n4, n3, n2, n9, this.X[1]);
        n7 = this.FF_1(n7, n6, n5, n4, n3, n2, n9, n8, this.X[2]);
        n6 = this.FF_1(n6, n5, n4, n3, n2, n9, n8, n7, this.X[3]);
        n5 = this.FF_1(n5, n4, n3, n2, n9, n8, n7, n6, this.X[4]);
        n4 = this.FF_1(n4, n3, n2, n9, n8, n7, n6, n5, this.X[5]);
        n3 = this.FF_1(n3, n2, n9, n8, n7, n6, n5, n4, this.X[6]);
        n2 = this.FF_1(n2, n9, n8, n7, n6, n5, n4, n3, this.X[7]);
        n9 = this.FF_1(n9, n8, n7, n6, n5, n4, n3, n2, this.X[8]);
        n8 = this.FF_1(n8, n7, n6, n5, n4, n3, n2, n9, this.X[9]);
        n7 = this.FF_1(n7, n6, n5, n4, n3, n2, n9, n8, this.X[10]);
        n6 = this.FF_1(n6, n5, n4, n3, n2, n9, n8, n7, this.X[11]);
        n5 = this.FF_1(n5, n4, n3, n2, n9, n8, n7, n6, this.X[12]);
        n4 = this.FF_1(n4, n3, n2, n9, n8, n7, n6, n5, this.X[13]);
        n3 = this.FF_1(n3, n2, n9, n8, n7, n6, n5, n4, this.X[14]);
        n2 = this.FF_1(n2, n9, n8, n7, n6, n5, n4, n3, this.X[15]);
        n9 = this.FF_1(n9, n8, n7, n6, n5, n4, n3, n2, this.X[16]);
        n8 = this.FF_1(n8, n7, n6, n5, n4, n3, n2, n9, this.X[17]);
        n7 = this.FF_1(n7, n6, n5, n4, n3, n2, n9, n8, this.X[18]);
        n6 = this.FF_1(n6, n5, n4, n3, n2, n9, n8, n7, this.X[19]);
        n5 = this.FF_1(n5, n4, n3, n2, n9, n8, n7, n6, this.X[20]);
        n4 = this.FF_1(n4, n3, n2, n9, n8, n7, n6, n5, this.X[21]);
        n3 = this.FF_1(n3, n2, n9, n8, n7, n6, n5, n4, this.X[22]);
        n2 = this.FF_1(n2, n9, n8, n7, n6, n5, n4, n3, this.X[23]);
        n9 = this.FF_1(n9, n8, n7, n6, n5, n4, n3, n2, this.X[24]);
        n8 = this.FF_1(n8, n7, n6, n5, n4, n3, n2, n9, this.X[25]);
        n7 = this.FF_1(n7, n6, n5, n4, n3, n2, n9, n8, this.X[26]);
        n6 = this.FF_1(n6, n5, n4, n3, n2, n9, n8, n7, this.X[27]);
        n5 = this.FF_1(n5, n4, n3, n2, n9, n8, n7, n6, this.X[28]);
        n4 = this.FF_1(n4, n3, n2, n9, n8, n7, n6, n5, this.X[29]);
        n3 = this.FF_1(n3, n2, n9, n8, n7, n6, n5, n4, this.X[30]);
        n2 = this.FF_1(n2, n9, n8, n7, n6, n5, n4, n3, this.X[31]);
        n9 = this.FF_2(n9, n8, n7, n6, n5, n4, n3, n2, this.X[5], 1160258022);
        n8 = this.FF_2(n8, n7, n6, n5, n4, n3, n2, n9, this.X[14], 953160567);
        n7 = this.FF_2(n7, n6, n5, n4, n3, n2, n9, n8, this.X[26], -1101764913);
        n6 = this.FF_2(n6, n5, n4, n3, n2, n9, n8, n7, this.X[18], 887688300);
        n5 = this.FF_2(n5, n4, n3, n2, n9, n8, n7, n6, this.X[11], -1062458953);
        n4 = this.FF_2(n4, n3, n2, n9, n8, n7, n6, n5, this.X[28], -914599715);
        n3 = this.FF_2(n3, n2, n9, n8, n7, n6, n5, n4, this.X[7], 1065670069);
        n2 = this.FF_2(n2, n9, n8, n7, n6, n5, n4, n3, this.X[16], -1253635817);
        n9 = this.FF_2(n9, n8, n7, n6, n5, n4, n3, n2, this.X[0], -1843997223);
        n8 = this.FF_2(n8, n7, n6, n5, n4, n3, n2, n9, this.X[23], -1988494565);
        n7 = this.FF_2(n7, n6, n5, n4, n3, n2, n9, n8, this.X[20], -785314906);
        n6 = this.FF_2(n6, n5, n4, n3, n2, n9, n8, n7, this.X[22], -1730169428);
        n5 = this.FF_2(n5, n4, n3, n2, n9, n8, n7, n6, this.X[1], 805139163);
        n4 = this.FF_2(n4, n3, n2, n9, n8, n7, n6, n5, this.X[10], -803545161);
        n3 = this.FF_2(n3, n2, n9, n8, n7, n6, n5, n4, this.X[4], -1193168915);
        n2 = this.FF_2(n2, n9, n8, n7, n6, n5, n4, n3, this.X[8], 1780907670);
        n9 = this.FF_2(n9, n8, n7, n6, n5, n4, n3, n2, this.X[30], -1166241723);
        n8 = this.FF_2(n8, n7, n6, n5, n4, n3, n2, n9, this.X[3], -248741991);
        n7 = this.FF_2(n7, n6, n5, n4, n3, n2, n9, n8, this.X[21], 614570311);
        n6 = this.FF_2(n6, n5, n4, n3, n2, n9, n8, n7, this.X[9], -1282315017);
        n5 = this.FF_2(n5, n4, n3, n2, n9, n8, n7, n6, this.X[17], 134345442);
        n4 = this.FF_2(n4, n3, n2, n9, n8, n7, n6, n5, this.X[24], -2054226922);
        n3 = this.FF_2(n3, n2, n9, n8, n7, n6, n5, n4, this.X[29], 1667834072);
        n2 = this.FF_2(n2, n9, n8, n7, n6, n5, n4, n3, this.X[6], 1901547113);
        n9 = this.FF_2(n9, n8, n7, n6, n5, n4, n3, n2, this.X[19], -1537671517);
        n8 = this.FF_2(n8, n7, n6, n5, n4, n3, n2, n9, this.X[12], -191677058);
        n7 = this.FF_2(n7, n6, n5, n4, n3, n2, n9, n8, this.X[15], 227898511);
        n6 = this.FF_2(n6, n5, n4, n3, n2, n9, n8, n7, this.X[13], 1921955416);
        n5 = this.FF_2(n5, n4, n3, n2, n9, n8, n7, n6, this.X[2], 1904987480);
        n4 = this.FF_2(n4, n3, n2, n9, n8, n7, n6, n5, this.X[25], -2112533778);
        n3 = this.FF_2(n3, n2, n9, n8, n7, n6, n5, n4, this.X[31], 2069144605);
        n2 = this.FF_2(n2, n9, n8, n7, n6, n5, n4, n3, this.X[27], -1034266187);
        n9 = this.FF_3(n9, n8, n7, n6, n5, n4, n3, n2, this.X[19], -1674521287);
        n8 = this.FF_3(n8, n7, n6, n5, n4, n3, n2, n9, this.X[9], 720527379);
        n7 = this.FF_3(n7, n6, n5, n4, n3, n2, n9, n8, this.X[4], -976113629);
        n6 = this.FF_3(n6, n5, n4, n3, n2, n9, n8, n7, this.X[20], 677414384);
        n5 = this.FF_3(n5, n4, n3, n2, n9, n8, n7, n6, this.X[28], -901678824);
        n4 = this.FF_3(n4, n3, n2, n9, n8, n7, n6, n5, this.X[17], -1193592593);
        n3 = this.FF_3(n3, n2, n9, n8, n7, n6, n5, n4, this.X[8], -1904616272);
        n2 = this.FF_3(n2, n9, n8, n7, n6, n5, n4, n3, this.X[22], 1614419982);
        n9 = this.FF_3(n9, n8, n7, n6, n5, n4, n3, n2, this.X[29], 1822297739);
        n8 = this.FF_3(n8, n7, n6, n5, n4, n3, n2, n9, this.X[14], -1340175810);
        n7 = this.FF_3(n7, n6, n5, n4, n3, n2, n9, n8, this.X[25], -686458943);
        n6 = this.FF_3(n6, n5, n4, n3, n2, n9, n8, n7, this.X[12], -1120842969);
        n5 = this.FF_3(n5, n4, n3, n2, n9, n8, n7, n6, this.X[24], 2024746970);
        n4 = this.FF_3(n4, n3, n2, n9, n8, n7, n6, n5, this.X[30], 1432378464);
        n3 = this.FF_3(n3, n2, n9, n8, n7, n6, n5, n4, this.X[16], -430627341);
        n2 = this.FF_3(n2, n9, n8, n7, n6, n5, n4, n3, this.X[26], -1437226092);
        n9 = this.FF_3(n9, n8, n7, n6, n5, n4, n3, n2, this.X[31], 1464375394);
        n8 = this.FF_3(n8, n7, n6, n5, n4, n3, n2, n9, this.X[15], 1676153920);
        n7 = this.FF_3(n7, n6, n5, n4, n3, n2, n9, n8, this.X[7], 1439316330);
        n6 = this.FF_3(n6, n5, n4, n3, n2, n9, n8, n7, this.X[3], 715854006);
        n5 = this.FF_3(n5, n4, n3, n2, n9, n8, n7, n6, this.X[1], -1261675468);
        n4 = this.FF_3(n4, n3, n2, n9, n8, n7, n6, n5, this.X[0], 289532110);
        n3 = this.FF_3(n3, n2, n9, n8, n7, n6, n5, n4, this.X[18], -1588296017);
        n2 = this.FF_3(n2, n9, n8, n7, n6, n5, n4, n3, this.X[27], 2087905683);
        n9 = this.FF_3(n9, n8, n7, n6, n5, n4, n3, n2, this.X[13], -1276242927);
        n8 = this.FF_3(n8, n7, n6, n5, n4, n3, n2, n9, this.X[6], 1668267050);
        n7 = this.FF_3(n7, n6, n5, n4, n3, n2, n9, n8, this.X[21], 732546397);
        n6 = this.FF_3(n6, n5, n4, n3, n2, n9, n8, n7, this.X[10], 1947742710);
        n5 = this.FF_3(n5, n4, n3, n2, n9, n8, n7, n6, this.X[23], -832815594);
        n4 = this.FF_3(n4, n3, n2, n9, n8, n7, n6, n5, this.X[11], -1685613794);
        n3 = this.FF_3(n3, n2, n9, n8, n7, n6, n5, n4, this.X[5], -1344882125);
        n2 = this.FF_3(n2, n9, n8, n7, n6, n5, n4, n3, this.X[2], 1814351708);
        if (this.passes >= 4) {
            n9 = this.FF_4(n9, n8, n7, n6, n5, n4, n3, n2, this.X[24], 2050118529);
            n8 = this.FF_4(n8, n7, n6, n5, n4, n3, n2, n9, this.X[4], 680887927);
            n7 = this.FF_4(n7, n6, n5, n4, n3, n2, n9, n8, this.X[0], 999245976);
            n6 = this.FF_4(n6, n5, n4, n3, n2, n9, n8, n7, this.X[14], 1800124847);
            n5 = this.FF_4(n5, n4, n3, n2, n9, n8, n7, n6, this.X[2], -994056165);
            n4 = this.FF_4(n4, n3, n2, n9, n8, n7, n6, n5, this.X[7], 1713906067);
            n3 = this.FF_4(n3, n2, n9, n8, n7, n6, n5, n4, this.X[28], 1641548236);
            n2 = this.FF_4(n2, n9, n8, n7, n6, n5, n4, n3, this.X[23], -81679983);
            n9 = this.FF_4(n9, n8, n7, n6, n5, n4, n3, n2, this.X[26], 1216130144);
            n8 = this.FF_4(n8, n7, n6, n5, n4, n3, n2, n9, this.X[6], 1575780402);
            n7 = this.FF_4(n7, n6, n5, n4, n3, n2, n9, n8, this.X[30], -276538019);
            n6 = this.FF_4(n6, n5, n4, n3, n2, n9, n8, n7, this.X[20], -377129551);
            n5 = this.FF_4(n5, n4, n3, n2, n9, n8, n7, n6, this.X[18], -601480446);
            n4 = this.FF_4(n4, n3, n2, n9, n8, n7, n6, n5, this.X[25], -345695352);
            n3 = this.FF_4(n3, n2, n9, n8, n7, n6, n5, n4, this.X[19], 596196993);
            n2 = this.FF_4(n2, n9, n8, n7, n6, n5, n4, n3, this.X[3], -745100091);
            n9 = this.FF_4(n9, n8, n7, n6, n5, n4, n3, n2, this.X[22], 258830323);
            n8 = this.FF_4(n8, n7, n6, n5, n4, n3, n2, n9, this.X[11], -2081144263);
            n7 = this.FF_4(n7, n6, n5, n4, n3, n2, n9, n8, this.X[31], 772490370);
            n6 = this.FF_4(n6, n5, n4, n3, n2, n9, n8, n7, this.X[21], -1534844924);
            n5 = this.FF_4(n5, n4, n3, n2, n9, n8, n7, n6, this.X[8], 1774776394);
            n4 = this.FF_4(n4, n3, n2, n9, n8, n7, n6, n5, this.X[27], -1642095778);
            n3 = this.FF_4(n3, n2, n9, n8, n7, n6, n5, n4, this.X[12], 566650946);
            n2 = this.FF_4(n2, n9, n8, n7, n6, n5, n4, n3, this.X[9], -152474470);
            n9 = this.FF_4(n9, n8, n7, n6, n5, n4, n3, n2, this.X[1], 1728879713);
            n8 = this.FF_4(n8, n7, n6, n5, n4, n3, n2, n9, this.X[29], -1412200208);
            n7 = this.FF_4(n7, n6, n5, n4, n3, n2, n9, n8, this.X[5], 1783734482);
            n6 = this.FF_4(n6, n5, n4, n3, n2, n9, n8, n7, this.X[15], -665571480);
            n5 = this.FF_4(n5, n4, n3, n2, n9, n8, n7, n6, this.X[17], -1777359064);
            n4 = this.FF_4(n4, n3, n2, n9, n8, n7, n6, n5, this.X[10], -1420741725);
            n3 = this.FF_4(n3, n2, n9, n8, n7, n6, n5, n4, this.X[16], 1861159788);
            n2 = this.FF_4(n2, n9, n8, n7, n6, n5, n4, n3, this.X[13], 326777828);
        }
        if (this.passes == 5) {
            n9 = this.FF_5(n9, n8, n7, n6, n5, n4, n3, n2, this.X[27], -1170476976);
            n8 = this.FF_5(n8, n7, n6, n5, n4, n3, n2, n9, this.X[3], 2130389656);
            n7 = this.FF_5(n7, n6, n5, n4, n3, n2, n9, n8, this.X[21], -1578015459);
            n6 = this.FF_5(n6, n5, n4, n3, n2, n9, n8, n7, this.X[26], 967770486);
            n5 = this.FF_5(n5, n4, n3, n2, n9, n8, n7, n6, this.X[17], 1724537150);
            n4 = this.FF_5(n4, n3, n2, n9, n8, n7, n6, n5, this.X[11], -2109534584);
            n3 = this.FF_5(n3, n2, n9, n8, n7, n6, n5, n4, this.X[20], -1930525159);
            n2 = this.FF_5(n2, n9, n8, n7, n6, n5, n4, n3, this.X[29], 1164943284);
            n9 = this.FF_5(n9, n8, n7, n6, n5, n4, n3, n2, this.X[19], 2105845187);
            n8 = this.FF_5(n8, n7, n6, n5, n4, n3, n2, n9, this.X[0], 998989502);
            n7 = this.FF_5(n7, n6, n5, n4, n3, n2, n9, n8, this.X[12], -529566248);
            n6 = this.FF_5(n6, n5, n4, n3, n2, n9, n8, n7, this.X[7], -2050940813);
            n5 = this.FF_5(n5, n4, n3, n2, n9, n8, n7, n6, this.X[13], 1075463327);
            n4 = this.FF_5(n4, n3, n2, n9, n8, n7, n6, n5, this.X[8], 1455516326);
            n3 = this.FF_5(n3, n2, n9, n8, n7, n6, n5, n4, this.X[31], 1322494562);
            n2 = this.FF_5(n2, n9, n8, n7, n6, n5, n4, n3, this.X[10], 910128902);
            n9 = this.FF_5(n9, n8, n7, n6, n5, n4, n3, n2, this.X[5], 469688178);
            n8 = this.FF_5(n8, n7, n6, n5, n4, n3, n2, n9, this.X[9], 1117454909);
            n7 = this.FF_5(n7, n6, n5, n4, n3, n2, n9, n8, this.X[14], 936433444);
            n6 = this.FF_5(n6, n5, n4, n3, n2, n9, n8, n7, this.X[30], -804646328);
            n5 = this.FF_5(n5, n4, n3, n2, n9, n8, n7, n6, this.X[18], -619713837);
            n4 = this.FF_5(n4, n3, n2, n9, n8, n7, n6, n5, this.X[6], 1240580251);
            n3 = this.FF_5(n3, n2, n9, n8, n7, n6, n5, n4, this.X[28], 122909385);
            n2 = this.FF_5(n2, n9, n8, n7, n6, n5, n4, n3, this.X[24], -2137449605);
            n9 = this.FF_5(n9, n8, n7, n6, n5, n4, n3, n2, this.X[2], 634681816);
            n8 = this.FF_5(n8, n7, n6, n5, n4, n3, n2, n9, this.X[23], -152510729);
            n7 = this.FF_5(n7, n6, n5, n4, n3, n2, n9, n8, this.X[16], -469872614);
            n6 = this.FF_5(n6, n5, n4, n3, n2, n9, n8, n7, this.X[22], -1233564613);
            n5 = this.FF_5(n5, n4, n3, n2, n9, n8, n7, n6, this.X[4], -1754472259);
            n4 = this.FF_5(n4, n3, n2, n9, n8, n7, n6, n5, this.X[1], 79693498);
            n3 = this.FF_5(n3, n2, n9, n8, n7, n6, n5, n4, this.X[25], -1045868618);
            n2 = this.FF_5(n2, n9, n8, n7, n6, n5, n4, n3, this.X[15], 1084186820);
        }
        this.context[0] = this.context[0] + n2;
        this.context[1] = this.context[1] + n3;
        this.context[2] = this.context[2] + n4;
        this.context[3] = this.context[3] + n5;
        this.context[4] = this.context[4] + n6;
        this.context[5] = this.context[5] + n7;
        this.context[6] = this.context[6] + n8;
        this.context[7] = this.context[7] + n9;
    }

    private void tailorDigestBits() {
        if (this.bitLength == 128) {
            int n = this.context[7] & 0xFF | this.context[6] & 0xFF000000 | this.context[5] & 0xFF0000 | this.context[4] & 0xFF00;
            this.context[0] = this.context[0] + (n >>> 8 | n << 24);
            n = this.context[7] & 0xFF00 | this.context[6] & 0xFF | this.context[5] & 0xFF000000 | this.context[4] & 0xFF0000;
            this.context[1] = this.context[1] + (n >>> 16 | n << 16);
            n = this.context[7] & 0xFF0000 | this.context[6] & 0xFF00 | this.context[5] & 0xFF | this.context[4] & 0xFF000000;
            this.context[2] = this.context[2] + (n >>> 24 | n << 8);
            n = this.context[7] & 0xFF000000 | this.context[6] & 0xFF0000 | this.context[5] & 0xFF00 | this.context[4] & 0xFF;
            this.context[3] = this.context[3] + n;
        } else if (this.bitLength == 160) {
            int n = this.context[7] & 0x3F | this.context[6] & 0xFE000000 | this.context[5] & 0x1F80000;
            this.context[0] = this.context[0] + (n >>> 19 | n << 13);
            n = this.context[7] & 0xFC0 | this.context[6] & 0x3F | this.context[5] & 0xFE000000;
            this.context[1] = this.context[1] + (n >>> 25 | n << 7);
            n = this.context[7] & 0x7F000 | this.context[6] & 0xFC0 | this.context[5] & 0x3F;
            this.context[2] = this.context[2] + n;
            n = this.context[7] & 0x1F80000 | this.context[6] & 0x7F000 | this.context[5] & 0xFC0;
            this.context[3] = this.context[3] + (n >>> 6);
            n = this.context[7] & 0xFE000000 | this.context[6] & 0x1F80000 | this.context[5] & 0x7F000;
            this.context[4] = this.context[4] + (n >>> 12);
        } else if (this.bitLength == 192) {
            int n = this.context[7] & 0x1F | this.context[6] & 0xFC000000;
            this.context[0] = this.context[0] + (n >>> 26 | n << 6);
            n = this.context[7] & 0x3E0 | this.context[6] & 0x1F;
            this.context[1] = this.context[1] + n;
            n = this.context[7] & 0xFC00 | this.context[6] & 0x3E0;
            this.context[2] = this.context[2] + (n >>> 5);
            n = this.context[7] & 0x1F0000 | this.context[6] & 0xFC00;
            this.context[3] = this.context[3] + (n >>> 10);
            n = this.context[7] & 0x3E00000 | this.context[6] & 0x1F0000;
            this.context[4] = this.context[4] + (n >>> 16);
            n = this.context[7] & 0xFC000000 | this.context[6] & 0x3E00000;
            this.context[5] = this.context[5] + (n >>> 21);
        } else if (this.bitLength == 224) {
            this.context[0] = this.context[0] + (this.context[7] >>> 27 & 0x1F);
            this.context[1] = this.context[1] + (this.context[7] >>> 22 & 0x1F);
            this.context[2] = this.context[2] + (this.context[7] >>> 18 & 0xF);
            this.context[3] = this.context[3] + (this.context[7] >>> 13 & 0x1F);
            this.context[4] = this.context[4] + (this.context[7] >>> 9 & 0xF);
            this.context[5] = this.context[5] + (this.context[7] >>> 4 & 0x1F);
            this.context[6] = this.context[6] + (this.context[7] & 0xF);
        }
    }

    private int FF_1(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        switch (this.passes) {
            case 3: {
                n10 = this.f_1(n7, n8, n5, n3, n2, n6, n4);
                break;
            }
            case 4: {
                n10 = this.f_1(n6, n2, n7, n4, n3, n5, n8);
                break;
            }
            default: {
                n10 = this.f_1(n5, n4, n7, n8, n3, n6, n2);
            }
        }
        return (n10 >>> 7 | n10 << 25) + (n >>> 11 | n << 21) + n9;
    }

    private int FF_2(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        switch (this.passes) {
            case 3: {
                n11 = this.f_2(n4, n6, n7, n8, n3, n5, n2);
                break;
            }
            case 4: {
                n11 = this.f_2(n5, n3, n6, n8, n7, n2, n4);
                break;
            }
            default: {
                n11 = this.f_2(n2, n6, n7, n8, n5, n4, n3);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int FF_3(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        switch (this.passes) {
            case 3: {
                n11 = this.f_3(n2, n7, n6, n5, n4, n3, n8);
                break;
            }
            case 4: {
                n11 = this.f_3(n7, n4, n5, n2, n8, n6, n3);
                break;
            }
            default: {
                n11 = this.f_3(n6, n2, n8, n4, n5, n7, n3);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int FF_4(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        switch (this.passes) {
            case 4: {
                n11 = this.f_4(n2, n4, n8, n3, n6, n7, n5);
                break;
            }
            default: {
                n11 = this.f_4(n7, n3, n5, n6, n8, n4, n2);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int FF_5(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11 = this.f_5(n6, n3, n8, n2, n4, n5, n7);
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int f_1(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n6 & (n7 ^ n3) ^ n5 & n2 ^ n4 & n ^ n7;
    }

    private int f_2(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n5 & (n6 & ~n4 ^ n3 & n2 ^ n ^ n7) ^ n3 & (n6 ^ n2) ^ n4 & n2 ^ n7;
    }

    private int f_3(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n4 & (n6 & n5 ^ n ^ n7) ^ n6 & n3 ^ n5 & n2 ^ n7;
    }

    private int f_4(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n3 & (n2 & ~n5 ^ n4 & ~n ^ n6 ^ n ^ n7) ^ n4 & (n6 & n5 ^ n2 ^ n) ^ n5 & n ^ n7;
    }

    private int f_5(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n7 & (n6 & n5 & n4 ^ ~n2) ^ n6 & n3 ^ n5 & n2 ^ n4 & n;
    }

    public HAVAL() {
        super("HAVAL");
        int n;
        String string;
        try {
            string = Security.getAlgorithmProperty("HAVAL", "passes");
            n = Integer.parseInt(string);
            if (n >= 3 && n <= 5) {
                this.passes = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = Security.getAlgorithmProperty("HAVAL", "bitLength");
            n = Integer.parseInt(string);
            if (n % 32 == 0 && n >= 128 && n <= 256) {
                this.bitLength = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.engineReset();
        this.link();
    }

    private HAVAL(HAVAL hAVAL) {
        this();
        this.passes = hAVAL.passes;
        this.bitLength = hAVAL.bitLength;
        this.count = hAVAL.count;
        this.context = (int[])hAVAL.context.clone();
        this.buffer = (byte[])hAVAL.buffer.clone();
    }
}

