/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.mode;

import cryptix.CryptixException;
import cryptix.provider.mode.FeedbackMode;
import cryptix.util.core.ArrayUtil;
import java.security.Cipher;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;

public class PCBC
extends FeedbackMode {
    private byte[] xorBlock;

    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.xorBlock = new byte[this.length];
    }

    protected int engineBlockSize() {
        return this.length;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        ArrayUtil.clear(this.xorBlock);
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.cipher.initDecrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        ArrayUtil.clear(this.xorBlock);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("PCBC: IV is not set");
        }
        if (n2 <= 0) {
            return 0;
        }
        switch (this.getState()) {
            case 1: {
                int n4 = 0;
                while (n4 < this.length) {
                    int n5 = n4;
                    this.ivBlock[n5] = (byte)(this.ivBlock[n5] ^ byArray[n + n4]);
                    int n6 = n4;
                    this.xorBlock[n6] = (byte)(this.xorBlock[n6] ^ this.ivBlock[n4]);
                    ++n4;
                }
                this.cipher.update(this.xorBlock, 0, this.length, this.ivBlock, 0);
                System.arraycopy(this.ivBlock, 0, byArray2, n3, this.length);
                System.arraycopy(byArray, n, this.xorBlock, 0, this.length);
                break;
            }
            case 2: {
                this.cipher.update(byArray, n, this.length, this.xorBlock, 0);
                int n7 = 0;
                while (n7 < this.length) {
                    byArray2[n3 + n7] = (byte)(this.ivBlock[n7] ^ this.xorBlock[n7]);
                    this.ivBlock[n7] = (byte)(byArray[n + n7] ^ byArray2[n3 + n7]);
                    ++n7;
                }
                break;
            }
            default: {
                throw new CryptixException("PCBC: Cipher not initialized");
            }
        }
        return this.length;
    }

    public PCBC() {
        super(false, false, "Cryptix");
    }

    public PCBC(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public PCBC(Cipher cipher, byte[] byArray) {
        this(cipher);
        this.setInitializationVector(byArray);
    }
}

