/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.security.Cipher;

class TestDES_EDE3
extends BaseTest {
    private static final String[][] testData1 = new String[][]{{"010101010101010101010101010101010101010101010101", "95F8A5E5DD31D900", "8000000000000000"}, {"010101010101010101010101010101010101010101010101", "9D64555A9A10B852", "0000001000000000"}, {"3849674C2602319E3849674C2602319E3849674C2602319E", "51454B582DDF440A", "7178876E01F19B2A"}, {"04B915BA43FEB5B604B915BA43FEB5B604B915BA43FEB5B6", "42FD443059577FA2", "AF37FB421F8C4095"}, {"0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF", "736F6D6564617461", "3D124FE2198BA318"}, {"0123456789ABCDEF55555555555555550123456789ABCDEF", "736F6D6564617461", "FBABA1FF9D05E9B1"}, {"0123456789ABCDEF5555555555555555FEDCBA9876543210", "736F6D6564617461", "18d748e563620572"}, {"0352020767208217860287665908219864056ABDFEA93457", "7371756967676C65", "c07d2a0fa566fa30"}, {"010101010101010180010101010101010101010101010102", "0000000000000000", "e6e6dd5b7e722974"}, {"10461034899880209107D0158919010119079210981A0101", "0000000000000000", "e1ef62c332fe825b"}};

    public static void main(String[] stringArray) {
        TestDES_EDE3.super.commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        boolean bl = false;
        int n = 0;
        String[][] stringArray = testData1;
        Cipher cipher = Cipher.getInstance("DES-EDE3", "Cryptix");
        this.setExpectedPasses(2 * stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.out.println("     key:" + stringArray[n2][0]);
            RawSecretKey rawSecretKey = new RawSecretKey("DES_EDE3", Hex.fromString(stringArray[n2][0]));
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray = cipher.crypt(Hex.fromString(stringArray[n2][1]));
            String string = Hex.toString(byArray);
            cipher.initDecrypt(rawSecretKey);
            byte[] byArray2 = cipher.crypt(byArray);
            String string2 = Hex.toString(byArray2);
            this.out.println("     p:" + stringArray[n2][1] + " enc:" + string + " calc:" + stringArray[n2][2]);
            boolean bl2 = string.equalsIgnoreCase(stringArray[n2][2]);
            this.passIf(bl2, "Data Set #" + (n2 + 1));
            if (bl2) {
                this.out.println("   * Encrypt good");
            } else {
                this.out.println("===> Encrypt (#" + ++n + ") FAILED <===");
            }
            this.out.println("   enc:" + Hex.toString(byArray) + " dec:" + string2 + " calc:" + stringArray[n2][1]);
            bl2 = string2.equalsIgnoreCase(stringArray[n2][1]);
            this.passIf(bl2, "Data Set #" + (n2 + 1));
            if (bl2) {
                this.out.println("   * Decrypt good");
            } else {
                this.out.println("===> Decrypt (#" + ++n + ") FAILED  <===");
            }
            this.out.println("");
            ++n2;
        }
        this.out.println("\nDES_EDE3 succeeded (" + n2 + " data tests)");
    }

    TestDES_EDE3() {
    }
}

