/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.util.core.BI;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.math.BigInteger;
import java.security.Cipher;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ElGamalPrivateKey;
import java.security.interfaces.ElGamalPublicKey;

public class TestElGamal
extends BaseTest {
    private static final byte[] message = ("Je ne veux que du magnifique, et je ne travaille pas pour le " + "vulgaire des lecteurs --Giambattista BODONI (1740-1813)").getBytes();
    private static final SecureRandom prng = new SecureRandom();

    public static void main(String[] stringArray) {
        TestElGamal.super.commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        int n = 2;
        this.setExpectedPasses(n * 9);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ElGamal");
        Signature[] signatureArray = new Signature[]{Signature.getInstance("MD2/ElGamal/PKCS#1"), Signature.getInstance("MD5/ElGamal/PKCS#1"), Signature.getInstance("SHA-1/ElGamal/PKCS#1"), Signature.getInstance("RIPEMD160/ElGamal/PKCS#1")};
        Cipher cipher = null;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 384 + 128 * n2;
            this.out.println("\nTest #" + (n2 + 1) + " (" + n3 + "-bit modulus)\n");
            this.out.println("  Generating keypair...\n");
            keyPairGenerator.initialize(n3, prng);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            int n4 = 0;
            while (n4 < signatureArray.length) {
                this.testSignature(n3, publicKey, privateKey, signatureArray[n4]);
                ++n4;
            }
            this.testEncryption(n3, publicKey, privateKey, cipher);
            ++n2;
        }
    }

    private void testSignature(int n, PublicKey publicKey, PrivateKey privateKey, Signature signature) {
        try {
            this.out.println("\n  Signing with a " + n + "-bit key using " + signature.getAlgorithm() + "...");
            signature.initSign(privateKey);
            signature.update(message);
            byte[] byArray = signature.sign();
            this.out.println("  Verifying with same " + n + "-bit key using " + signature.getAlgorithm() + "...");
            signature.initVerify(publicKey);
            signature.update(message);
            boolean bl = signature.verify(byArray);
            this.passIf(bl, "Signature verification");
            if (!bl) {
                this.out.println("---- begin debugging -----\n");
                this.out.println("Computed signature: " + Hex.dumpString(byArray));
                this.out.println("ElGamal parameters:");
                BigInteger bigInteger = ((ElGamalPublicKey)publicKey).getP();
                BigInteger bigInteger2 = ((ElGamalPublicKey)publicKey).getG();
                BigInteger bigInteger3 = ((ElGamalPublicKey)publicKey).getY();
                this.out.println("  Public key material:");
                this.out.println("    p: " + BI.dumpString(bigInteger));
                this.out.println("    g: " + BI.dumpString(bigInteger2));
                this.out.println("    y: " + BI.dumpString(bigInteger3));
                BigInteger bigInteger4 = ((ElGamalPrivateKey)privateKey).getX();
                this.out.println("  Private key material:");
                this.out.println("    x: " + BI.dumpString(bigInteger4));
                BigInteger bigInteger5 = new BigInteger(byArray);
                this.out.println("  The signature as a BigInteger:");
                this.out.println(" sig: " + BI.dumpString(bigInteger5));
                this.out.println("---- end debugging -----");
            }
            byArray[0] = (byte)(byArray[0] ^ 1);
            signature.initVerify(publicKey);
            signature.update(message);
            bl = !signature.verify(byArray);
            this.passIf(bl, "Incorrect signature should not verify");
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void testEncryption(int n, PublicKey publicKey, PrivateKey privateKey, Cipher cipher) {
        this.skip("Encryption test not implemented");
    }
}

