/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Cipher;
import java.security.CipherInputStream;
import java.security.CipherOutputStream;
import java.security.FeedbackCipher;
import java.util.Random;

public class TestIJCE
extends BaseTest {
    private static byte[] input = new byte[288];
    private static final byte[] b = new byte[]{66, 67, 27, -92, 13, 41, 31, -127, -42, 96, -125, -58, 5, -45, -92, -42};
    private static final byte[] anIV = new byte[]{116, 83, 110, -67, -62, 17, 72, 74};
    private static final RawSecretKey aKey = new RawSecretKey("SAFER", b);

    public static void main(String[] stringArray) {
        TestIJCE.super.commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(4);
        int n = 0;
        while (n < 2) {
            int n2 = 1;
            while (n2 < 9) {
                TestIJCE.input[16 * n + n2 + 7] = (byte)n2;
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < 256) {
            TestIJCE.input[32 + n] = (byte)n;
            ++n;
        }
        this.out.println("input data\n" + Hex.dumpString(input));
        this.test1();
        this.test2();
    }

    private void test1() throws Exception {
        this.out.println("\nSAFER (K-128) in CBC mode (crypt vs. update):\nKey = 42431BA40D291F81D66083C605D3A4D6, IV = 74536EBDC211484A\n");
        Cipher cipher = Cipher.getInstance("SAFER/CBC/PKCS#7", "Cryptix");
        cipher.setParameter("variant", "K-128");
        ((FeedbackCipher)((Object)cipher)).setInitializationVector(anIV);
        cipher.initEncrypt(aKey);
        byte[] byArray = cipher.crypt(input);
        int n = input.length / 2 - 3;
        cipher.initEncrypt(aKey);
        byte[] byArray2 = new byte[byArray.length];
        int n2 = cipher.update(input, 0, n, byArray2, 0);
        cipher.crypt(input, n, input.length - n, byArray2, n2);
        this.compareIt(byArray, byArray2);
        this.out.println("\nSAFER (SK-128) in CFB mode (crypt vs. update):\nKey = 42431BA40D291F81D66083C605D3A4D6; IV = 74536EBDC211484A\n");
        cipher = Cipher.getInstance("SAFER/CFB");
        cipher.setParameter("variant", "K-128");
        ((FeedbackCipher)((Object)cipher)).setInitializationVector(anIV);
        cipher.initEncrypt(aKey);
        byArray = cipher.crypt(input);
        n = input.length / 2 - 3;
        cipher.initEncrypt(aKey);
        byArray2 = new byte[byArray.length];
        n2 = cipher.update(input, 0, n, byArray2, 0);
        cipher.crypt(input, n, input.length - n, byArray2, n2);
        this.compareIt(byArray, byArray2);
    }

    private void test2() throws Exception {
        int[] nArray = new int[]{251, 221, 148, 3, 222, 99, 246, 105, 226, 42, 71, 84, 68, 15, 77, 253, 159, 242, 171, 246, 112, 85, 1, 17, 201, 140, 36, 25, 241, 217, 207, 44, 80, 203, 156, 123, 6, 117, 108, 33, 253, 118, 156, 50, 215, 83, 192, 211, 192, 96, 132, 205, 118, 92, 206, 254, 202, 230, 171, 236, 51, 135, 233, 194, 53, 57, 72, 89, 0, 227, 222, 39, 185, 94, 100, 159, 46, 224, 186, 134, 232, 36, 54, 169, 81, 223, 150, 161, 105, 97, 100, 184, 37, 205, 111, 144, 43, 156, 135, 129, 56, 57, 2, 115, 59, 120, 171, 26, 204, 97, 254, 53, 164, 17, 135, 22, 23, 121, 49, 144, 173, 38, 181, 61, 227, 132, 145, 40, 75, 69, 65, 164, 65, 64, 25, 9, 199, 38, 132, 165, 135, 97, 129, 144, 4, 179, 112, 60, 182, 250, 222, 252, 248, 23, 59, 228, 191, 0, 56, 237, 163, 20, 30, 104, 216, 45, 209, 254, 107, 188, 169, 97, 173, 41, 205, 249, 164, 128, 120, 201, 215, 188, 35, 103, 108, 202, 174, 140, 138, 95, 241, 71, 83, 199, 70, 162, 73, 226, 87, 84, 43, 17, 178, 203, 21, 250, 128, 159, 137, 190, 174, 11, 215, 22, 155, 34, 34, 169, 13, 95, 208, 118, 231, 89, 88, 179, 4, 29, 176, 17, 64, 235, 58, 88, 114, 65, 57, 96, 211, 163, 188, 18, 100, 4, 91, 45, 233, 80, 217, 90, 45, 93, 144, 82, 60, 203, 224, 81, 113, 231, 159, 185, 171, 128, 109, 224, 154, 141, 33, 66, 255, 44, 112, 41, 125, 205, 154, 174, 226, 225, 173, 243, 107, 172, 214, 234, 22, 186};
        this.out.println("\nSAFER (K-128) in CBC mode:\nKey = 42431BA40D291F81D66083C605D3A4D6, IV = 74536EBDC211484A\n");
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        this.out.println("Checking an encryptor input stream...\n");
        Cipher cipher = Cipher.getInstance("SAFER/CBC", "Cryptix");
        cipher.setParameter("variant", "K-128");
        ((FeedbackCipher)((Object)cipher)).setInitializationVector(anIV);
        cipher.initEncrypt(aKey);
        CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(input), cipher);
        byte[] byArray2 = new byte[288];
        Random random = new Random();
        int n2 = 0;
        int n3 = 0;
        while (n2 != -1) {
            n2 = cipherInputStream.read(byArray2, n3 += n2, random.nextInt() & 0xF);
        }
        cipherInputStream.close();
        this.compareIt(byArray2, byArray);
        this.out.println("\nChecking a decryptor output stream...\n");
        cipher.initDecrypt(aKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        cipherOutputStream.write(byArray2, 0, 100);
        cipherOutputStream.write(byArray2, 100, 100);
        cipherOutputStream.write(byArray2, 200, 88);
        cipherOutputStream.flush();
        cipherOutputStream.close();
        this.compareIt(byteArrayOutputStream.toByteArray(), input);
    }

    private void compareIt(byte[] byArray, byte[] byArray2) {
        this.out.println(" computed output: " + Hex.dumpString(byArray));
        this.out.println("certified output: " + Hex.dumpString(byArray2));
        this.passIf(ArrayUtil.areEqual(byArray, byArray2), "IJCE test");
    }
}

