/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.security.Cipher;

class TestRC4
extends BaseTest {
    private Cipher alg;

    public static void main(String[] stringArray) {
        TestRC4.super.commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(5);
        this.alg = Cipher.getInstance("RC4", "Cryptix");
        this.test1();
        this.test2();
    }

    private void test1() throws Exception {
        String[][] stringArray = new String[][]{{"0123456789ABCDEF", "0123456789ABCDEF", "75B7878099E0C596"}, {"0123456789ABCDEF", "7494C2E7104B0879", "0000000000000000"}, {"0000000000000000", "0000000000000000", "DE188941A3375D3A"}, {"EF012345", "00000000000000000000", "D6A141A7EC3C38DFBD61"}};
        int n = 0;
        while (n < stringArray.length) {
            this.out.println("\nTest vector " + (n + 1) + ":\n");
            this.alg.initEncrypt(new RawSecretKey("RC4", Hex.fromString(stringArray[n][0])));
            this.compareIt(this.alg.crypt(Hex.fromString(stringArray[n][1])), Hex.fromString(stringArray[n][2]));
            ++n;
        }
    }

    private void test2() throws Exception {
        int[] nArray = new int[]{117, 149, 195, 230, 17, 74, 9, 120, 12, 74, 212, 82, 51, 142, 31, 253, 154, 27, 233, 73, 143, 129, 61, 118, 83, 52, 73, 182, 119, 141, 202, 216, 199, 138, 141, 43, 169, 172, 102, 8, 93, 14, 83, 213, 156, 38, 194, 209, 196, 144, 193, 235, 190, 12, 230, 109, 27, 107, 27, 19, 182, 185, 25, 184, 71, 194, 90, 145, 68, 122, 149, 231, 94, 78, 241, 103, 121, 205, 232, 191, 10, 149, 133, 14, 50, 175, 150, 137, 68, 79, 211, 119, 16, 143, 152, 253, 203, 212, 231, 38, 86, 117, 0, 153, 11, 204, 126, 12, 163, 196, 170, 163, 4, 163, 135, 210, 15, 59, 143, 187, 205, 66, 161, 189, 49, 29, 122, 67, 3, 221, 165, 171, 7, 136, 150, 174, 128, 193, 139, 10, 246, 109, 255, 49, 150, 22, 235, 120, 78, 73, 90, 210, 206, 144, 215, 247, 114, 168, 23, 71, 182, 95, 98, 9, 59, 30, 13, 185, 229, 186, 83, 47, 175, 236, 71, 80, 131, 35, 230, 113, 50, 125, 249, 68, 68, 50, 203, 115, 103, 206, 200, 47, 93, 68, 192, 208, 11, 103, 214, 80, 160, 117, 205, 75, 112, 222, 221, 119, 235, 155, 16, 35, 27, 107, 91, 116, 19, 71, 57, 109, 98, 137, 116, 33, 212, 61, 249, 180, 46, 68, 110, 53, 142, 156, 17, 169, 178, 24, 78, 203, 239, 12, 216, 231, 168, 119, 239, 150, 143, 19, 144, 236, 155, 61, 53, 165, 88, 92, 176, 9, 41, 14, 47, 205, 231, 181, 236, 102, 217, 8, 75, 228, 64, 85, 166, 25, 217, 221, 127, 195, 22, 111, 148, 135, 247, 203, 39, 41, 18, 66, 100, 69, 153, 133, 20, 193, 93, 83, 161, 140, 134, 76, 227, 162, 183, 85, 87, 147, 152, 129, 38, 82, 14, 172, 242, 227, 6, 110, 35, 12, 145, 190, 228, 221, 83, 4, 245, 253, 4, 5, 179, 91, 217, 156, 115, 19, 93, 61, 155, 195, 53, 238, 4, 158, 246, 155, 56, 103, 191, 45, 123, 209, 234, 165, 149, 216, 191, 192, 6, 111, 248, 211, 21, 9, 235, 12, 108, 170, 0, 108, 128, 122, 98, 62, 248, 76, 61, 51, 193, 149, 210, 62, 227, 32, 196, 13, 224, 85, 129, 87, 200, 34, 212, 184, 197, 105, 216, 73, 174, 213, 157, 78, 15, 215, 243, 121, 88, 107, 75, 127, 246, 132, 237, 106, 24, 159, 116, 134, 212, 155, 156, 75, 173, 155, 162, 75, 150, 171, 249, 36, 55, 44, 138, 143, 255, 177, 13, 85, 53, 73, 0, 167, 122, 61, 181, 242, 5, 225, 185, 159, 205, 134, 96, 134, 58, 21, 154, 212, 171, 228, 15, 164, 137, 52, 22, 61, 221, 229, 66, 166, 88, 85, 64, 253, 104, 60, 191, 216, 192, 15, 18, 18, 154, 40, 77, 234, 204, 76, 222, 254, 88, 190, 113, 55, 84, 28, 4, 113, 38, 200, 212, 158, 39, 85, 171, 24, 26, 183, 233, 64, 176, 192};
        byte[] byArray = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        byte[] byArray2 = new byte[512];
        byte[] byArray3 = new byte[512];
        this.out.println("\nTest vector 5:\n");
        int n = 0;
        while (n < nArray.length) {
            byArray2[n] = 1;
            byArray3[n] = (byte)nArray[n];
            ++n;
        }
        this.alg.initEncrypt(new RawSecretKey("RC4", byArray));
        this.compareIt(this.alg.crypt(byArray2), byArray3);
    }

    private void compareIt(byte[] byArray, byte[] byArray2) {
        this.out.print("  computed output:" + Hex.dumpString(byArray));
        boolean bl = ArrayUtil.areEqual(byArray, byArray2);
        if (!bl) {
            this.out.print("\n certified output:" + Hex.dumpString(byArray2));
        }
        this.passIf(bl, " *** RC4 OUTPUT");
    }

    TestRC4() {
    }
}

