/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawKeyGenerator;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.security.Cipher;
import java.security.FeedbackCipher;
import java.security.KeyGenerator;
import java.security.SecretKey;

class TestSquare
extends BaseTest {
    private static final byte[] key = new byte[16];
    private SecretKey aKey;

    public static void main(String[] stringArray) {
        TestSquare.super.commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(10);
        RawKeyGenerator rawKeyGenerator = (RawKeyGenerator)KeyGenerator.getInstance("Square", "Cryptix");
        this.aKey = rawKeyGenerator.generateKey(key);
        this.test1();
        this.test2();
        this.test3();
        this.test4();
        this.test5();
    }

    private void test1() throws Exception {
        byte[] byArray = new byte[16];
        int n = 0;
        while (n < 16) {
            byArray[n] = (byte)n;
            ++n;
        }
        byte[] byArray2 = new byte[]{124, 52, -111, -39, 73, -108, -25, 15, 14, -62, -25, -91, -52, -75, -95, 79};
        this.out.println("\nTest vector (raw/ECB):\nEncrypting:");
        Cipher cipher = Cipher.getInstance("Square", "Cryptix");
        cipher.initEncrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray), byArray2);
        this.out.println("\nDecrypting:");
        cipher.initDecrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray2), byArray);
    }

    private void test2() throws Exception {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < 16) {
            byte by = (byte)n;
            byArray[n + 16] = by;
            byArray[n] = by;
            ++n;
        }
        byte[] byArray2 = new byte[]{124, 52, -111, -39, 73, -108, -25, 15, 14, -62, -25, -91, -52, -75, -95, 79, 124, 52, -111, -39, 73, -108, -25, 15, 14, -62, -25, -91, -52, -75, -95, 79};
        this.out.println("\nTest vector (ECB):\nEncrypting:");
        Cipher cipher = Cipher.getInstance("Square/ECB", "Cryptix");
        cipher.initEncrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray), byArray2);
        this.out.println("\nDecrypting:");
        cipher.initDecrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray2), byArray);
    }

    private void test3() throws Exception {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < 16) {
            byte by = (byte)n;
            byArray[n + 16] = by;
            byArray[n] = by;
            ++n;
        }
        byte[] byArray2 = new byte[]{124, 52, -111, -39, 73, -108, -25, 15, 14, -62, -25, -91, -52, -75, -95, 79, 65, -46, -15, -99, 126, -121, -115, -75, 108, 116, 70, -44, 36, -61, -83, -4};
        this.out.println("\nTest vector (CBC):\nEncrypting:");
        Cipher cipher = Cipher.getInstance("Square/CBC", "Cryptix");
        FeedbackCipher feedbackCipher = (FeedbackCipher)((Object)cipher);
        feedbackCipher.setInitializationVector(new byte[feedbackCipher.getInitializationVectorLength()]);
        cipher.initEncrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray), byArray2);
        this.out.println("\nDecrypting:");
        cipher.initDecrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray2), byArray);
    }

    private void test4() throws Exception {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < 16) {
            byte by = (byte)n;
            byArray[n + 16] = by;
            byArray[n] = by;
            ++n;
        }
        byte[] byArray2 = new byte[]{-1, 88, 109, -91, 108, -70, -59, 6, 74, 9, -92, 10, -18, -74, -82, -81, -43, -53, 83, -114, -22, 40, -105, 79, 124, 117, -25, -101, -53, 13, 77, 14};
        this.out.println("\nTest vector (CFB):\nEncrypting:");
        Cipher cipher = Cipher.getInstance("Square/CFB", "Cryptix");
        ((FeedbackCipher)((Object)cipher)).setInitializationVector(new byte[16]);
        cipher.initEncrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray), byArray2);
        this.out.println("\nDecrypting:");
        cipher.initDecrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray2), byArray);
    }

    private void test5() throws Exception {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < 16) {
            byte by = (byte)n;
            byArray[n + 16] = by;
            byArray[n] = by;
            ++n;
        }
        byte[] byArray2 = new byte[]{-1, 88, 109, -91, 108, -70, -59, 6, 74, 9, -92, 10, -18, -74, -82, -81, 53, -56, 51, -45, 92, 41, 68, 55, 53, -46, 37, -68, -107, 40, -61, -56};
        this.out.println("\nTest vector (OFB):\nEncrypting:");
        Cipher cipher = Cipher.getInstance("Square/OFB", "Cryptix");
        FeedbackCipher feedbackCipher = (FeedbackCipher)((Object)cipher);
        feedbackCipher.setInitializationVector(new byte[feedbackCipher.getInitializationVectorLength()]);
        cipher.initEncrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray), byArray2);
        this.out.println("\nDecrypting:");
        cipher.initDecrypt(this.aKey);
        this.compareIt(cipher.crypt(byArray2), byArray);
    }

    private void compareIt(byte[] byArray, byte[] byArray2) {
        this.out.print("  computed output:" + Hex.dumpString(byArray));
        boolean bl = ArrayUtil.areEqual(byArray, byArray2);
        if (!bl) {
            this.out.print("\n certified output:" + Hex.dumpString(byArray2));
        }
        this.passIf(bl, " *** Square OUTPUT");
    }

    TestSquare() {
    }

    static {
        int n = 0;
        while (n < 16) {
            TestSquare.key[n] = (byte)n;
            ++n;
        }
    }
}

