/*
 * Decompiled with CFR 0.152.
 */
package cryptix.tools;

import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Cipher;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecretKey;
import java.util.StringTokenizer;

public final class MCT {
    static final String VERSION = "$Revision: 1.4 $";
    static final String SUBMITTER = "<as stated on the submission cover sheet>";
    boolean ecb = false;
    boolean cbc = false;
    String dirName = null;
    String keylengths = null;
    String provider = null;
    String cipherName = null;
    File destination = null;
    int[] keys = new int[]{128, 192, 256};
    final String eeFileName;
    final String edFileName;
    final String ceFileName;
    final String cdFileName;
    long encBlocks;
    long decBlocks;
    long keyCount;
    Class algorithm = null;
    Method blockSize = null;
    Method makeKey = null;
    Method encrypt = null;
    Method decrypt = null;
    Cipher cipher = null;
    boolean useReflection = true;

    public static void main(String[] stringArray) {
        System.out.println("NIST Monte-Carlo Tests data generator/exerciser\n\n$Revision: 1.4 $\nCopyright (c) 1998 Systemics Ltd. on behalf of\nthe Cryptix Development Team.  All rights reserved.\n\n");
        MCT mCT = new MCT();
        mCT.processOptions(stringArray);
        mCT.run();
    }

    void processOptions(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            this.printUsage();
        }
        System.out.println("(type \"java cryptix.tools.MCT\" with no arguments for help)\n\n");
        int n2 = -1;
        String string = "";
        boolean bl = true;
        while (true) {
            if (bl) {
                if (++n2 >= n) break;
                string = stringArray[n2];
            } else {
                string = "-" + string.substring(2);
            }
            if (string.startsWith("-e")) {
                this.ecb = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-c")) {
                this.cbc = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-l")) {
                this.keylengths = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            if (string.startsWith("-d")) {
                this.dirName = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            if (string.startsWith("-p")) {
                this.provider = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            this.cipherName = string;
        }
        if (this.cipherName == null) {
            MCT.halt("Missing cipher algorithm name");
        }
        if (this.cipherName.length() > 1 && (this.cipherName.startsWith("\"") || this.cipherName.startsWith("'"))) {
            this.cipherName = this.cipherName.substring(2, this.cipherName.length() - 2);
        }
        if (this.provider == null) {
            this.provider = this.cipherName;
        }
        if (this.keylengths != null) {
            int n3 = 0;
            int[] nArray = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(this.keylengths, ", \t\"");
            while (stringTokenizer.hasMoreTokens()) {
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                if (n4 <= 0) {
                    MCT.halt("Negative key length not allowed: " + n4);
                }
                if (n3 == 3) {
                    MCT.halt("Only three key-length values are allowed.");
                }
                nArray[n3++] = n4;
            }
            if (n3 != 0) {
                this.keys = new int[n3];
                System.arraycopy(nArray, 0, this.keys, 0, n3);
            }
        }
        if (!this.ecb && !this.cbc) {
            this.cbc = true;
            this.ecb = true;
        }
        if (this.dirName == null) {
            this.dirName = System.getProperty("user.dir");
        }
        this.destination = new File(this.dirName);
        if (!this.destination.isDirectory()) {
            MCT.halt("Destination <" + this.destination.getName() + "> is not a directory");
        }
        try {
            this.algorithm = Class.forName(this.provider + "." + this.cipherName + "_Algorithm");
            Method[] methodArray = this.algorithm.getDeclaredMethods();
            n2 = 0;
            while (n2 < methodArray.length) {
                String string2 = methodArray[n2].getName();
                int n5 = methodArray[n2].getParameterTypes().length;
                if (string2.equals("blockSize")) {
                    this.blockSize = methodArray[n2];
                } else if (string2.equals("makeKey") && n5 == 1) {
                    this.makeKey = methodArray[n2];
                } else if (string2.equals("blockEncrypt") && n5 == 3) {
                    this.encrypt = methodArray[n2];
                } else if (string2.equals("blockDecrypt") && n5 == 3) {
                    this.decrypt = methodArray[n2];
                }
                ++n2;
            }
            if (this.blockSize == null) {
                throw new NoSuchMethodException("blockSize()");
            }
            if (this.makeKey == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.encrypt == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.decrypt == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            MCT.notify("Unable to find a " + this.cipherName + "_Algorithm class");
            this.algorithm = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MCT.notify("Unable to find method " + noSuchMethodException.getMessage() + " in " + this.cipherName + "_Algorithm class");
            this.algorithm = null;
        }
        try {
            this.cipher = Cipher.getInstance(this.cipherName + "/ECB", this.provider);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            MCT.halt("Unable to locate Security Provider: " + this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            MCT.halt("Unable to locate an implementation for Cipher: " + this.cipherName + "/ECB");
        }
        this.useReflection = this.algorithm != null;
    }

    static void halt(String string) {
        System.err.println("\n*** " + string + "...");
        System.exit(-1);
    }

    static void notify(String string) {
        System.out.println("MCT: " + string + "...");
    }

    void printUsage() {
        System.out.println("NAME\n  MCT: A Monte Carlo Tests data generator/exerciser for any block\n  cipher algorithm.\n\nSYNTAX\n  java cryptix.tools.MCT\n    [ -e | -c ]\n    [ -l <comma-separated-key-lengths>]\n    [ -d <output-directory>]\n    [ -p <provider>]\n    <cipher>\n\nDESCRIPTION\n  For a designated symmetric block cipher algorithm, this command\n  generates and exercises Monte Carlo Tests data for both Encryption\n  and Decryption in Electronic Codebook (ECB) and Cipher Block Chaining\n  (CBC) modes.\n  MCT's output file format is in conformance with the layout described\n  in Section 4 of NIST's document \"Description of Known Answer Tests\n  and Monte Carlo Tests for Advanced Encryption Standard (AES) Candidate\n  Algorithm Submissions\" dated January 7, 1998.\n\nOPTIONS\n  -e   Generate both Encryption and Decryption data for the cipher in\n       ECB mode only.  By default MCT generates both ECB and CBC test\n       suites.\n\n  -c   Generate both Encryption and Decryption data for the cipher in\n       CBC mode only.  By default MCT generates both ECB and CBC test\n       suites.\n\n  -l <comma-separated-key-lengths>\n       Comma separated list (maximum of three) of key lengths to use\n       for the tests.  If omitted, the following three values are\n       assumed: 128, 192 and 256.\n\n  -d <output-directory>\n       Pathname of the directory where the output files: \"ecb_e_m.txt\",\n       \"ecb_d_m.txt\", \"cbc_e_m.txt\" and \"cbc_d_m.txt\" will be generated.\n       If this destination directory is not specified, those files will\n       be placed in the current user directory.\n\n  -p <provider>\n       Name of the Security Provider for the designated algorithm.\n       If omitted, then assumes provider has the same name as the\n       algorithm itself.\n\n  <cipher>\n       Cipher algorithm name.\n\nCOPYRIGHT\n  Copyright (c) 1998 Systemics Ltd. on behalf of\n  the Cryptix Development Team.  All rights reserved.\n");
        System.exit(0);
    }

    void run() {
        long l = System.currentTimeMillis();
        try {
            if (this.ecb) {
                this.ecbMCT("ecb_e_m.txt", "ecb_d_m.txt");
            }
            if (this.cbc) {
                this.cbcMCT("cbc_e_m.txt", "cbc_d_m.txt");
            }
        }
        catch (KeyException keyException) {
            keyException.printStackTrace();
            MCT.halt("Key Exception encountered\n" + keyException.getMessage());
        }
        MCT.notify("Java interpreter used: Version " + System.getProperty("java.version"));
        MCT.notify("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        MCT.notify("Total execution time (ms): " + (System.currentTimeMillis() - l));
        MCT.notify("During this time, " + this.cipherName + ":");
        MCT.notify("  Encrypted " + this.encBlocks + " blocks");
        MCT.notify("  Decrypted " + this.decBlocks + " blocks");
        MCT.notify("  Created " + this.keyCount + " session keys");
    }

    void ecbMCT(String string, String string2) throws KeyException {
        PrintWriter printWriter = null;
        File file = new File(this.destination, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        PrintWriter printWriter2 = null;
        File file2 = new File(this.destination, string2);
        try {
            printWriter2 = new PrintWriter((Writer)new FileWriter(file2), true);
        }
        catch (IOException iOException) {
            MCT.halt("Unable to initialize <" + string2 + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode - ENCRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        printWriter2.println();
        printWriter2.println("=========================");
        printWriter2.println();
        printWriter2.println("FILENAME:  \"" + string2 + "\"");
        printWriter2.println();
        printWriter2.println("Electronic Codebook (ECB) Mode - DECRYPTION");
        printWriter2.println("Monte Carlo Test");
        printWriter2.println();
        printWriter2.println("Algorithm Name: " + this.cipherName);
        printWriter2.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter2.println();
        boolean bl = true;
        if (this.useReflection) {
            try {
                int n = 0;
                while (n < this.keys.length) {
                    this.ecbForKeyReflect(this.keys[n], printWriter, printWriter2);
                    ++n;
                }
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                MCT.notify("Exception while invoking a method in " + this.cipherName + "_Algorithm class");
            }
            catch (InvocationTargetException invocationTargetException) {
                MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + invocationTargetException.getMessage());
                bl = false;
            }
        }
        if (bl) {
            int n = 0;
            while (n < this.keys.length) {
                this.ecbForKeyIjce(this.keys[n], printWriter, printWriter2);
                ++n;
            }
        }
        printWriter.println("==========");
        printWriter2.println("==========");
        printWriter.close();
        printWriter2.close();
    }

    void ecbForKeyReflect(int n, PrintWriter printWriter, PrintWriter printWriter2) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in ECB mode (long); key size: " + n);
        MCT.notify("Using Reflection API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        printWriter2.println("==========");
        printWriter2.println();
        printWriter2.println("KEYSIZE=" + n);
        printWriter2.println();
        Object[] objectArray = new Object[]{};
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = (Integer)this.blockSize.invoke(null, objectArray);
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            String string = Hex.toString(byArray);
            objectArray = new Object[]{byArray};
            Object object = this.makeKey.invoke(null, objectArray);
            ++this.keyCount;
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + string);
            printWriter.println("PT=" + Hex.toString(byArray2));
            objectArray = new Object[]{byArray2, new Integer(0), object};
            byte[] byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
            int n6 = 1;
            while (n6 < 9999) {
                objectArray[0] = byArray3;
                byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
                ++this.encBlocks;
                ++n6;
            }
            objectArray[0] = byArray3;
            byte[] byArray4 = (byte[])this.encrypt.invoke(null, objectArray);
            ++this.encBlocks;
            String string2 = Hex.toString(byArray4);
            printWriter.println("CT=" + string2);
            printWriter2.println("I=" + n4);
            printWriter2.println("KEY=" + string);
            printWriter2.println("CT=" + string2);
            objectArray[0] = byArray4;
            byte[] byArray5 = (byte[])this.decrypt.invoke(null, objectArray);
            ++this.decBlocks;
            n6 = 1;
            while (n6 < 10000) {
                objectArray[0] = byArray5;
                byArray5 = (byte[])this.decrypt.invoke(null, objectArray);
                ++this.decBlocks;
                ++n6;
            }
            printWriter2.println("PT=" + Hex.toString(byArray5));
            if (!ArrayUtil.areEqual(byArray2, byArray5)) {
                printWriter.println(" *** ERROR ***");
                printWriter2.println(" *** ERROR ***");
                MCT.halt("ECB Encryption/Decryption mismatch");
            }
            printWriter.println();
            printWriter2.println();
            n6 = 0;
            if (n2 > n3) {
                int n7 = n2 - n3;
                n5 = n3 - n7;
                while (n6 < n7) {
                    int n8 = n6++;
                    byArray[n8] = (byte)(byArray[n8] ^ byArray3[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n9 = n6++;
                byArray[n9] = (byte)(byArray[n9] ^ byArray4[n5++]);
            }
            System.arraycopy(byArray4, 0, byArray2, 0, n3);
            ++n4;
        }
    }

    void ecbForKeyIjce(int n, PrintWriter printWriter, PrintWriter printWriter2) throws KeyException {
        MCT.notify("Processing MCT in ECB mode (long); key size: " + n);
        MCT.notify("Using IJCE API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        printWriter2.println("==========");
        printWriter2.println();
        printWriter2.println("KEYSIZE=" + n);
        printWriter2.println();
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = this.cipher.blockSize();
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            String string = Hex.toString(byArray);
            MCT mCT = this;
            if (mCT == null) {
                throw null;
            }
            MCT_Key mCT_Key = mCT.new MCT_Key(byArray);
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + string);
            printWriter.println("PT=" + Hex.toString(byArray2));
            this.cipher.initEncrypt(mCT_Key);
            ++this.keyCount;
            byte[] byArray3 = this.cipher.crypt(byArray2);
            ++this.encBlocks;
            int n6 = 1;
            while (n6 < 9999) {
                byArray3 = this.cipher.crypt(byArray3);
                ++this.encBlocks;
                ++n6;
            }
            byte[] byArray4 = this.cipher.crypt(byArray3);
            ++this.encBlocks;
            String string2 = Hex.toString(byArray4);
            printWriter.println("CT=" + string2);
            printWriter2.println("I=" + n4);
            printWriter2.println("KEY=" + string);
            printWriter2.println("CT=" + string2);
            this.cipher.initDecrypt(mCT_Key);
            ++this.keyCount;
            byte[] byArray5 = this.cipher.crypt(byArray4);
            ++this.decBlocks;
            n6 = 1;
            while (n6 < 10000) {
                byArray5 = this.cipher.crypt(byArray5);
                ++this.decBlocks;
                ++n6;
            }
            printWriter2.println("PT=" + Hex.toString(byArray5));
            if (!ArrayUtil.areEqual(byArray2, byArray5)) {
                printWriter.println(" *** ERROR ***");
                printWriter2.println(" *** ERROR ***");
                MCT.halt("ECB Encryption/Decryption mismatch");
            }
            printWriter.println();
            printWriter2.println();
            n6 = 0;
            if (n2 > n3) {
                int n7 = n2 - n3;
                n5 = n3 - n7;
                while (n6 < n7) {
                    int n8 = n6++;
                    byArray[n8] = (byte)(byArray[n8] ^ byArray3[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n9 = n6++;
                byArray[n9] = (byte)(byArray[n9] ^ byArray4[n5++]);
            }
            System.arraycopy(byArray4, 0, byArray2, 0, n3);
            ++n4;
        }
    }

    void cbcMCT(String string, String string2) throws KeyException {
        this.cbcEncrypt(string);
        this.cbcDecrypt(string2);
    }

    void cbcEncrypt(String string) throws KeyException {
        PrintWriter printWriter = null;
        File file = new File(this.destination, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Cipher Block Chaining (CBC) Mode - ENCRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        boolean bl = true;
        if (this.useReflection) {
            try {
                int n = 0;
                while (n < this.keys.length) {
                    this.cbcEncForKeyReflect(this.keys[n], printWriter);
                    ++n;
                }
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                MCT.notify("Exception while invoking a method in " + this.cipherName + "_Algorithm class");
            }
            catch (InvocationTargetException invocationTargetException) {
                MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + invocationTargetException.getMessage());
                bl = false;
            }
        }
        if (bl) {
            int n = 0;
            while (n < this.keys.length) {
                this.cbcEncForKeyIjce(this.keys[n], printWriter);
                ++n;
            }
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void cbcEncForKeyReflect(int n, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in CBC-Encrypt mode (long); key size: " + n);
        MCT.notify("Using Reflection API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        Object[] objectArray = new Object[]{};
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = (Integer)this.blockSize.invoke(null, objectArray);
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray4, 0, byArray3, 0, n3);
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + Hex.toString(byArray));
            printWriter.println("IV=" + Hex.toString(byArray4));
            printWriter.println("PT=" + Hex.toString(byArray2));
            objectArray = new Object[]{byArray};
            Object object = this.makeKey.invoke(null, objectArray);
            ++this.keyCount;
            objectArray = new Object[3];
            objectArray[1] = new Integer(0);
            objectArray[2] = object;
            int n6 = 0;
            while (n6 < 10000) {
                n5 = 0;
                while (n5 < n3) {
                    int n7 = n5;
                    byArray4[n7] = (byte)(byArray4[n7] ^ byArray2[n5]);
                    ++n5;
                }
                System.arraycopy(byArray3, 0, byArray2, 0, n3);
                objectArray[0] = byArray4;
                byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
                ++this.encBlocks;
                System.arraycopy(byArray3, 0, byArray4, 0, n3);
                ++n6;
            }
            printWriter.println("CT=" + Hex.toString(byArray3));
            printWriter.println();
            n6 = 0;
            if (n2 > n3) {
                int n8 = n2 - n3;
                n5 = n3 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray2[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray3[n5++]);
            }
            ++n4;
        }
    }

    void cbcEncForKeyIjce(int n, PrintWriter printWriter) throws KeyException {
        MCT.notify("Processing MCT in CBC-Encrypt mode (long); key size: " + n);
        MCT.notify("Using IJCE API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = this.cipher.blockSize();
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray4, 0, byArray3, 0, n3);
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + Hex.toString(byArray));
            printWriter.println("IV=" + Hex.toString(byArray4));
            printWriter.println("PT=" + Hex.toString(byArray2));
            MCT mCT = this;
            if (mCT == null) {
                throw null;
            }
            MCT_Key mCT_Key = mCT.new MCT_Key(byArray);
            this.cipher.initEncrypt(mCT_Key);
            ++this.keyCount;
            int n6 = 0;
            while (n6 < 10000) {
                n5 = 0;
                while (n5 < n3) {
                    int n7 = n5;
                    byArray4[n7] = (byte)(byArray4[n7] ^ byArray2[n5]);
                    ++n5;
                }
                System.arraycopy(byArray3, 0, byArray2, 0, n3);
                byArray3 = this.cipher.crypt(byArray4);
                ++this.encBlocks;
                System.arraycopy(byArray3, 0, byArray4, 0, n3);
                ++n6;
            }
            printWriter.println("CT=" + Hex.toString(byArray3));
            printWriter.println();
            n6 = 0;
            if (n2 > n3) {
                int n8 = n2 - n3;
                n5 = n3 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray2[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray3[n5++]);
            }
            ++n4;
        }
    }

    void cbcDecrypt(String string) throws KeyException {
        PrintWriter printWriter = null;
        File file = new File(this.destination, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Cipher Block Chaining (CBC) Mode - DECRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        boolean bl = false;
        if (this.useReflection) {
            try {
                int n = 128;
                while (n < 257) {
                    this.cbcDecForKeyReflect(n, printWriter);
                    n += 64;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                MCT.notify("Exception while invoking a method in " + this.cipherName + "_Algorithm class");
                bl = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + invocationTargetException.getMessage());
            }
        }
        if (bl) {
            int n = 128;
            while (n < 257) {
                this.cbcDecForKeyIjce(n, printWriter);
                n += 64;
            }
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void cbcDecForKeyReflect(int n, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in CBC-Decrypt mode (long); key size: " + n);
        MCT.notify("Using Reflection API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        Object[] objectArray = new Object[]{};
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = (Integer)this.blockSize.invoke(null, objectArray);
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + Hex.toString(byArray));
            printWriter.println("IV=" + Hex.toString(byArray4));
            printWriter.println("CT=" + Hex.toString(byArray3));
            objectArray = new Object[]{byArray};
            Object object = this.makeKey.invoke(null, objectArray);
            ++this.keyCount;
            objectArray = new Object[3];
            objectArray[1] = new Integer(0);
            objectArray[2] = object;
            int n6 = 0;
            while (n6 < 10000) {
                objectArray[0] = byArray3;
                byArray2 = (byte[])this.decrypt.invoke(null, objectArray);
                ++this.decBlocks;
                n5 = 0;
                while (n5 < n3) {
                    int n7 = n5;
                    byArray2[n7] = (byte)(byArray2[n7] ^ byArray4[n5]);
                    ++n5;
                }
                System.arraycopy(byArray3, 0, byArray4, 0, n3);
                System.arraycopy(byArray2, 0, byArray3, 0, n3);
                ++n6;
            }
            printWriter.println("PT=" + Hex.toString(byArray2));
            printWriter.println();
            n6 = 0;
            if (n2 > n3) {
                int n8 = n2 - n3;
                n5 = n3 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray4[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray2[n5++]);
            }
            ++n4;
        }
    }

    void cbcDecForKeyIjce(int n, PrintWriter printWriter) throws KeyException {
        MCT.notify("Processing MCT in CBC-Decrypt mode (long); key size: " + n);
        MCT.notify("Using IJCE API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = this.cipher.blockSize();
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + Hex.toString(byArray));
            printWriter.println("IV=" + Hex.toString(byArray4));
            printWriter.println("CT=" + Hex.toString(byArray3));
            MCT mCT = this;
            if (mCT == null) {
                throw null;
            }
            MCT_Key mCT_Key = mCT.new MCT_Key(byArray);
            this.cipher.initDecrypt(mCT_Key);
            ++this.keyCount;
            int n6 = 0;
            while (n6 < 10000) {
                byArray2 = this.cipher.crypt(byArray3);
                ++this.decBlocks;
                n5 = 0;
                while (n5 < n3) {
                    int n7 = n5;
                    byArray2[n7] = (byte)(byArray2[n7] ^ byArray4[n5]);
                    ++n5;
                }
                System.arraycopy(byArray3, 0, byArray4, 0, n3);
                System.arraycopy(byArray2, 0, byArray3, 0, n3);
                ++n6;
            }
            printWriter.println("PT=" + Hex.toString(byArray2));
            printWriter.println();
            n6 = 0;
            if (n2 > n3) {
                int n8 = n2 - n3;
                n5 = n3 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray4[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray2[n5++]);
            }
            ++n4;
        }
    }

    public MCT() {
        this.eeFileName = "ecb_e_m.txt";
        this.edFileName = "ecb_d_m.txt";
        this.ceFileName = "cbc_e_m.txt";
        this.cdFileName = "cbc_d_m.txt";
    }

    final class MCT_Key
    implements SecretKey {
        byte[] key;

        public String getAlgorithm() {
            return "<ANY>";
        }

        public String getFormat() {
            return "RAW";
        }

        public byte[] getEncoded() {
            return (byte[])this.key.clone();
        }

        public MCT_Key(byte[] byArray) {
            this.key = (byte[])byArray.clone();
        }
    }
}

