/*
 * Decompiled with CFR 0.152.
 */
package cryptix.tools;

import cryptix.CryptixException;
import cryptix.provider.key.RawKeyGenerator;
import cryptix.util.checksum.PRZ24;
import cryptix.util.io.DosFilter;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.security.Cipher;
import java.security.CipherInputStream;
import java.security.CipherOutputStream;
import java.security.FeedbackCipher;
import java.security.InvalidKeyException;
import java.security.KeyGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecretKey;
import java.security.SecureRandom;
import java.security.WeakKeyException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Scar
extends Thread {
    public static boolean DEBUG = true;
    static int debuglevel;
    static final PrintWriter err;
    static final boolean TRACE = false;
    static final boolean IN = true;
    static final boolean OUT = false;
    private static final String MAGIC_STRING = "Que du magnifique...";
    private static final byte[] MAGIC;
    static String fs;
    static final SecureRandom random;
    static final String DEFAULT_HEADER = "BEGIN SCAR ARCHIVE";
    static final String DEFAULT_FOOTER = "END SCAR ARCHIVE";
    static final String DEFAULT_COMMENT = "scar by Cryptix...";
    static final String DEFAULT_CIPHER = "Square";
    static final String DEFAULT_PASS_PHRASE = "sub rosa";
    static final String DEFAULT_MD = "RIPEMD-160";
    static final String DEFAULT_SALT = "BEGIN SCAR ARCHIVE";
    static final int DEFAULT_ITERATIONS = 7;
    static final int CONV_WHITE = -1;
    static final int CONV_PAD = -2;
    static final int CONV_OTHER = -3;
    static final String VERSION = "Version: Alpha.1 --December 97";
    static final int MAX_LINE_LENGTH = 64;
    static final char[] BASE64;
    static final char PADDING = '=';
    private boolean asciify = false;
    private boolean decrypting = false;
    private boolean encrypting = false;
    private boolean recursion = false;
    private boolean useDirInfo = false;
    private boolean verbose = false;
    private boolean wipeSource = false;
    private String cipherAlgorithm = null;
    private String passPhrase = null;
    private String mdAlgorithm = null;
    private String salt = null;
    private int iterations;
    private String input = null;
    private String output = null;
    private File inFile = null;
    private File outFile = null;
    private File temp = null;
    private File temp2 = null;
    private byte[] buffer = new byte[512];
    private DosFilter filter = new DosFilter();
    private int count = 0;
    PropertyResourceBundle properties;
    String header;
    String footer;
    String comment;

    static void debug(String string) {
        if (DEBUG) {
            err.println(">>> scar: " + string);
        }
    }

    static void trace(boolean bl, String string) {
    }

    static void trace(String string) {
    }

    public static void main(String[] stringArray) {
        System.out.println("scar (Strong Cryptographic ARchiver)\nVersion: Alpha.1 --December 97\nCopyright (c) 1997, 1998 Systemics Ltd. on behalf of\nthe Cryptix Development Team.  All rights reserved.\n\n");
        Scar scar = new Scar();
        scar.processOptions(stringArray);
        scar.run();
    }

    void initDefaults() {
        Scar.trace(true, "initDefaults()");
        this.header = "BEGIN SCAR ARCHIVE";
        this.footer = DEFAULT_FOOTER;
        this.comment = DEFAULT_COMMENT;
        this.cipherAlgorithm = DEFAULT_CIPHER;
        this.passPhrase = DEFAULT_PASS_PHRASE;
        this.mdAlgorithm = DEFAULT_MD;
        this.salt = "BEGIN SCAR ARCHIVE";
        this.iterations = 7;
        Scar.trace(false, "initDefaults()");
    }

    public void processOptions(String[] stringArray) {
        Scar.trace(true, "processOptions()");
        int n = stringArray.length;
        Scar.debug("Command line arguments [...");
        int n2 = 0;
        while (n2 < n) {
            Scar.debug(" args[" + (n2 + 1) + "]: " + stringArray[n2]);
            ++n2;
        }
        Scar.debug("...]");
        if (n == 0) {
            this.printUsage();
        }
        Vector<String> vector = new Vector<String>();
        int n3 = -1;
        String string = "";
        boolean bl = true;
        this.filter.reset();
        int n4 = 0;
        while (true) {
            if (bl) {
                if (++n3 >= n) break;
                string = stringArray[n3];
            } else {
                string = "-" + string.substring(2);
            }
            if (string.startsWith("-a")) {
                this.asciify = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-d")) {
                this.decrypting = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-e")) {
                this.encrypting = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-r")) {
                this.recursion = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-u")) {
                this.useDirInfo = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-v")) {
                this.verbose = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-w")) {
                this.wipeSource = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-c")) {
                this.cipherAlgorithm = stringArray[n3 + 1];
                ++n3;
                bl = true;
                ++n4;
                continue;
            }
            if (string.startsWith("-p")) {
                this.passPhrase = stringArray[n3 + 1];
                ++n3;
                bl = true;
                ++n4;
                continue;
            }
            if (string.startsWith("-m")) {
                this.mdAlgorithm = stringArray[n3 + 1];
                ++n3;
                bl = true;
                ++n4;
                continue;
            }
            if (string.startsWith("-s")) {
                this.salt = stringArray[n3 + 1];
                ++n3;
                bl = true;
                ++n4;
                continue;
            }
            if (string.startsWith("-i")) {
                this.iterations = Integer.parseInt(stringArray[n3 + 1]);
                ++n3;
                bl = true;
                ++n4;
                continue;
            }
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        if (this.decrypting) {
            if (this.encrypting || this.recursion || this.asciify) {
                this.halt("Found at least one conflicting option to Decryption");
            }
        } else {
            this.encrypting = true;
        }
        if (this.cipherAlgorithm.length() > 1 && (this.cipherAlgorithm.startsWith("\"") || this.cipherAlgorithm.startsWith("'"))) {
            this.cipherAlgorithm = this.cipherAlgorithm.substring(2, this.cipherAlgorithm.length() - 2);
        }
        if (this.passPhrase.length() > 1 && (this.passPhrase.startsWith("\"") || this.passPhrase.startsWith("'"))) {
            this.passPhrase = this.passPhrase.substring(2, this.passPhrase.length() - 2);
        }
        if (this.mdAlgorithm.length() > 1 && (this.mdAlgorithm.startsWith("\"") || this.mdAlgorithm.startsWith("'"))) {
            this.mdAlgorithm = this.mdAlgorithm.substring(2, this.mdAlgorithm.length() - 2);
        }
        if (this.salt.length() > 1 && (this.salt.startsWith("\"") || this.salt.startsWith("'"))) {
            this.salt = this.salt.substring(2, this.salt.length() - 2);
        }
        vector.trimToSize();
        if (vector.size() == 0) {
            this.halt("Missing <input> path-name");
        } else if (vector.size() == 1) {
            this.input = (String)vector.elementAt(0);
            this.output = System.getProperty("user.dir", new File("." + fs).getAbsolutePath());
        } else if (vector.size() == 2) {
            this.input = (String)vector.elementAt(0);
            this.output = (String)vector.elementAt(1);
        } else {
            this.halt("Too many files");
        }
        if (this.input.startsWith("\"") || this.input.startsWith("'")) {
            this.input = this.input.substring(2, this.input.length() - 2);
        }
        if (this.input.indexOf("*") != -1 || this.input.indexOf("?") != -1) {
            this.filter.setMask(new File(this.input).getName());
            this.input = new File(new File(this.input).getAbsolutePath()).getParent();
        }
        if (this.output.startsWith("\"") || this.output.startsWith("'")) {
            this.output = this.output.substring(2, this.output.length() - 2);
        }
        if (this.encrypting && (this.decrypting || this.useDirInfo || this.output == null)) {
            this.halt("Found at least one conflicting option to Encryption");
        }
        this.inFile = new File(this.input);
        if (!this.inFile.exists()) {
            this.halt("Input <" + this.input + "> not found");
        }
        if (!this.inFile.canRead()) {
            this.halt("Input <" + this.input + "> is unreadable");
        }
        if (this.decrypting && this.inFile.isDirectory()) {
            this.halt("Decryption required but input <" + this.input + "> is a directory");
        }
        this.outFile = new File(this.output);
        if (this.encrypting && this.outFile.isDirectory()) {
            this.halt("Encryption required but output <" + this.output + "> is a directory");
        } else if (this.decrypting && !this.outFile.isDirectory()) {
            this.halt("Decryption required but output <" + this.output + "> is not a directory");
        }
        if (n4 == 0) {
            System.out.println("WARNING:\n  You did not specify at least one of: cipher algorithm, pass-phrase,\n  message digest algorithm, message digest salt value or message\n  digest iteration count; instead you are relying on default values\n  for these arguments. Please note that it is bad practice not to\n  vary at least one of those parameters. Failing to do so reduces\n  the efforts of an attacker trying to decrypt your scar.");
        }
        this.temp = this.getTempFile();
        Scar.trace(false, "processOptions()");
    }

    private void halt(String string) {
        Scar.trace("halt()");
        Scar.debug("halt() --> " + string);
        System.err.println("\n*** " + string + "...");
        System.exit(-1);
    }

    private void printUsage() {
        Scar.trace(true, "printUsage()");
        System.out.println("NAME\n  Scar: Strong Cryptographic ARchiver using Cryptix IJCE\n  (International Java Cryptography Extensions).\n\nSYNTAX\n  java cryptix.tools.Scar\n    [ -e ]\n    [ -a ]\n    [ -r ]\n    [ -v ]\n    [ -w ]\n    [ -c cipher]\n    [ -p passphrase]\n    [ -m s2k_message_digest]\n    [ -s s2k_salt]\n    [ -i s2k_iterations]\n    input\n    output\n\n  java cryptix.tools.Scar\n    -d\n    [ -u ]\n    [ -v ]\n    [ -w ]\n    [ -c cipher]\n    [ -p passphrase]\n    [ -m s2k_message_digest]\n    [ -s s2k_salt]\n    [ -i s2k_iterations]\n    input\n    [output]\n\nDESCRIPTION\n  Scar  reads  and  compresses input and writes the encrypted\n  result to output. It also does the inverse operation: reads\n  and decrypts input and decompresses the resulting data into\n  output.\n\n  By default both encryption and decryption are done using the\n  'Square' cipher algorithm (designed by Joan Daemen & Vincent\n  Rijmen) in Cipher Electronic Codebook (CBC) mode padded with\n  the method described in PKCS#7.\n\n  The cipher's secret session key is derived from a passphrase\n  supplied by the user through an S2K algorithm. The types and\n  differences of such S2K algorithms are described in Open-PGP\n  I.E.T.F document (draft-ietf-openpgp-formats.txt) dated 9/97.\n  This scar uses Simple, Salted and Salted-Iterated S2K variants.\n  The default message digest used with all S2K variants is\n  RIPEMD-160.\n\n  As mentioned earlier, the encryption and decryption are not\n  done on the data itself but on a ZIP-ped image.  ZIPping is\n  accomplished using the DEFLATE  method at its maximum level\n  (best size).\n\n  When a command line is entered, scar tries to load a properties\n  file named \"scar.properties\" from the user home directory,\n  the value of which is returned by Java's property \"user.home\"\n\nOPTIONS\n  -a   Asciify (Encryption).  Encode the output in Base-64 format\n       (RFC-1521) making it suitable for Internet transmission.\n\n  -d   Decryption.\n\n  -e   Encryption (default).\n\n  -r   Recurse (Encryption).  Apply the process repetitively to\n       sub-directories found in input.\n\n  -u   Use directory information (Decryption).  Recreate original\n       directory tree structure.\n\n  -v   Verbose.  Print notification messages to System.out.\n\n  -w   Wipe the source input after processing.\n\n  -c <cipher>\n       Cipher algorithm name ('Square' by default).  Other values\n       can be any block cipher algorithm installed and accessible\n       on user platform  that conforms to Sun(R)'s JCE or Cryptix\n       IJCE. With Cryptix security provider installed choices are\n       Blowfish, CAST5, RC4, IDEA, SAFER and LOKI91 in addition to\n       Square.\n\n  -p <passphrase>\n       An alphanumeric string with no spaces.  If contains spaces\n       then include within double quotes.  If not supplied use \"\".\n\n  -m <s2k_message_digest>\n       Message digest algorithm name ('RIPEMD-160' by default).\n       Other values can be any message digest algorithm installed\n       and accessible on user platform that conforms to Sun (R)'s\n       JCE or Cryptix's IJCE. With Cryptix security provider this\n       can be, in addition to 'RIPEMD-160', HAVAL, MD2, MD4, MD5,\n       SHA-1 and RIPEMD-128.\n\n  -s <s2k_salt>\n       S2K salt value.  If not supplied a Simple or Iterated S2K\n       algorithm will be used, depending on whether an iteration\n       count was supplied or not.\n\n  -i <s2k_iterations>\n       S2K iteration count. If a positive value is not provided,\n       a Simple or Salted S2K algorithm will be used, depending\n       on whether a salt value is given or not.\n\n  <input>\n       Input file or directory pathname. If the pathname includes\n       spaces,  then it should be enclosed within  double quotes.\n       Wild characters such as '*' (any number of characters) and\n       '?' (any one character) are allowed, in such case <input>\n       acts as a filter for actual selection of input file(s).\n       When a filter is used, it should be enclosed within \"\".\n\n  <output>\n       Output file or directory.  When decrypting this should be\n       a directory pathname. If absent, in the case of decryption,\n       use the current directory.\n\nCOPYRIGHT\n  Copyright (c) 1997, 1998 Systemics Ltd. on behalf of\n  the Cryptix Development Team.  All rights reserved.\n");
        Scar.trace(false, "printUsage()");
        System.exit(0);
    }

    private File getTempFile() {
        int n;
        File file;
        Scar.trace(true, "getTempFile()");
        do {
            n = (int)(Math.abs(random.nextDouble()) * 1000000.0);
        } while ((file = new File("." + fs, "F" + String.valueOf(n))).exists());
        Scar.debug("getTempFile() --> " + file.getName());
        Scar.trace(false, "getTempFile()");
        return file;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block40: {
            block38: {
                block37: {
                    block43: {
                        block42: {
                            Scar.trace(true, "run()");
                            this.notify("\nActual parameters");
                            this.notify("\tcipher algorithm: \"" + this.cipherAlgorithm + "\"");
                            this.notify("\t     pass-phrase: \"" + this.passPhrase + "\"");
                            this.notify("\t  message digest: \"" + this.mdAlgorithm + "\"");
                            this.notify("\t         md salt: \"" + this.salt + "\"");
                            this.notify("\t   md iterations: " + this.iterations);
                            this.notify("\t   input file(s): <" + this.input + ">");
                            this.notify("\t output file/dir: <" + this.output + ">");
                            this.notify("\tselection filter: <" + this.filter + ">");
                            var2_1 = null;
                            var3_2 = null;
                            var6_3 = null;
                            try {
                                var6_3 = Cipher.getInstance(this.cipherAlgorithm + "/CBC/PKCS#7");
                            }
                            catch (NoSuchAlgorithmException var7_9) {
                                throw new CryptixException("Unable to instantiate a " + this.cipherAlgorithm + " cipher object in CBC mode with PKCS#7 padding.");
                            }
                            var7_10 = ((FeedbackCipher)var6_3).getInitializationVectorLength();
                            var8_11 = new byte[var7_10];
                            ((FeedbackCipher)var6_3).setInitializationVector(var8_11);
                            var9_12 = this.s2k();
                            if (!this.encrypting) break block42;
                            this.notify("\nZipping");
                            var10_13 = new ZipOutputStream(new FileOutputStream(this.temp));
                            var10_13.setComment("Made with scar");
                            var10_13.setMethod(8);
                            var10_13.setLevel(9);
                            this.zip(this.inFile, var10_13, 0);
                            if (this.count == 0) {
                                this.halt("No files were found that satisfy the selection criteria");
                            }
                            var10_13.flush();
                            var10_13.finish();
                            var10_13.close();
                            this.notify("\nEncrypting");
                            this.temp2 = this.getTempFile();
                            var3_2 = new FileOutputStream(this.temp2);
                            var6_3.initEncrypt(var9_12);
                            var11_15 = new CipherInputStream(new FileInputStream(this.temp), (Cipher)var6_3);
                            Scar.random.nextBytes(var8_11);
                            var3_2.write(var8_11);
                            var3_2.write(Scar.MAGIC);
                            while ((var1_18 = var11_15.read(this.buffer)) != -1) {
                                var3_2.write(this.buffer, 0, var1_18);
                            }
                            var11_15.close();
                            var3_2.close();
                            if (this.asciify) {
                                this.notify("\nAsciifying");
                                var2_1 = new FileInputStream(this.temp2);
                                v0 = this;
                                if (v0 == null) {
                                    throw null;
                                }
                                var12_20 = v0.new ScarOutputStream(new FileOutputStream(this.outFile));
                                while ((var1_18 = var2_1.read(this.buffer)) != -1) {
                                    var12_20.write(this.buffer, 0, var1_18);
                                }
                                var2_1.close();
                                var12_20.flush();
                                var12_20.close();
                            } else {
                                this.outFile.delete();
                                this.temp2.renameTo(this.outFile);
                            }
                            this.temp.delete();
                            this.temp2.delete();
                            break block43;
                        }
                        this.notify("\nDe-asciifying");
                        var3_2 = new FileOutputStream(this.temp);
                        var10_14 = null;
                        try {
                            v1 = this;
                            if (v1 == null) {
                                throw null;
                            }
                            var10_14 = v1.new ScarInputStream(new FileInputStream(this.inFile));
                            while ((var1_19 = var10_14.read(this.buffer)) != -1) {
                                var3_2.write(this.buffer, 0, var1_19);
                            }
                            var10_14.close();
                            var3_2.flush();
                            var3_2.close();
                            var2_1 = new FileInputStream(this.temp);
                        }
                        catch (IOException var11_16) {
                            Scar.debug("Warning: " + var11_16.getMessage());
                            this.notify("Warning: " + var11_16.getMessage());
                            var2_1 = new FileInputStream(this.inFile);
                        }
                        this.notify("\nDecrypting");
                        this.temp2 = this.getTempFile();
                        var3_2 = new FileOutputStream(this.temp2);
                        var6_3.initDecrypt(var9_12);
                        var11_17 = new CipherOutputStream(var3_2, (Cipher)var6_3);
                        var1_19 = var2_1.read(this.buffer, 0, var8_11.length);
                        Scar.debug("length of alleged iv: " + var1_19);
                        if (var1_19 != var8_11.length) {
                            throw new CryptixException("File too short to be a scar (1).");
                        }
                        var1_19 = var2_1.read(this.buffer, 0, Scar.MAGIC.length);
                        if (var1_19 == -1 || var1_19 != Scar.MAGIC.length) {
                            throw new CryptixException("File too short to be a scar (2).");
                        }
                        Scar.debug("Magic word: " + new String(this.buffer, 0, Scar.MAGIC.length));
                        if (new String(this.buffer, 0, Scar.MAGIC.length).equals("Que du magnifique...")) ** GOTO lbl110
                        throw new CryptixException("File doesn't look to be a scar. If it is, it was produced using a different set of properties.");
lbl-1000:
                        // 1 sources

                        {
                            var11_17.write(this.buffer, 0, var1_19);
lbl110:
                            // 2 sources

                            ** while ((var1_19 = var2_1.read((byte[])this.buffer)) != -1)
                        }
lbl111:
                        // 1 sources

                        var11_17.flush();
                        var11_17.close();
                        var2_1.close();
                        var3_2.close();
                        this.notify("\nUnzipping");
                        var12_21 = new ZipInputStream(new FileInputStream(this.temp2));
                        this.unzip(var12_21, this.outFile);
                        var12_21.close();
                        this.temp.delete();
                        this.temp2.delete();
                    }
                    if (!this.wipeSource) break block37;
                    this.notify("\nDeleting input");
                    this.wipe(this.inFile, 0);
                }
                var5_22 = null;
                if (this.temp == null) break block38;
                try {
                    this.temp.delete();
                }
                catch (Exception var6_3) {
                    // empty catch block
                }
            }
            if (this.temp2 != null) {
                try {
                    this.temp2.delete();
                }
                catch (Exception var6_3) {}
            }
            break block40;
            {
                catch (CryptixException var6_4) {
                    Scar.debug(var6_4.getMessage());
                    this.notify("\n--- Exception: " + var6_4.getMessage());
                    var5_23 = null;
                    if (this.temp != null) {
                        try {
                            this.temp.delete();
                        }
                        catch (Exception var6_5) {
                            // empty catch block
                        }
                    }
                    if (this.temp2 != null) {
                        try {
                            this.temp2.delete();
                        }
                        catch (Exception var6_5) {}
                    }
                    break block40;
                }
                catch (Exception var6_6) {
                    var6_6.printStackTrace();
                    var5_24 = null;
                    if (this.temp != null) {
                        try {
                            this.temp.delete();
                        }
                        catch (Exception var6_7) {
                            // empty catch block
                        }
                    }
                    if (this.temp2 != null) {
                        try {
                            this.temp2.delete();
                        }
                        catch (Exception var6_7) {}
                    }
                }
            }
            catch (Throwable var4_26) {
                var5_25 = null;
                if (this.temp != null) {
                    try {
                        this.temp.delete();
                    }
                    catch (Exception var6_8) {
                        // empty catch block
                    }
                }
                if (this.temp2 != null) {
                    try {
                        this.temp2.delete();
                    }
                    catch (Exception var6_8) {
                        // empty catch block
                    }
                }
                throw var4_26;
            }
        }
        Scar.trace(false, "run()");
    }

    private SecretKey s2k() throws CloneNotSupportedException, InvalidKeyException {
        Scar.trace(true, "s2k()");
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(this.mdAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptixException("Unable to instantiate a " + this.mdAlgorithm + " message digest object");
        }
        int n = messageDigest.digest().length;
        RawKeyGenerator rawKeyGenerator = null;
        try {
            rawKeyGenerator = (RawKeyGenerator)KeyGenerator.getInstance(this.cipherAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptixException("Unable to instantiate a " + this.cipherAlgorithm + " key-generator object");
        }
        int n2 = rawKeyGenerator.getDefaultKeyLength();
        Vector<Object> vector = new Vector<Object>();
        int n3 = 0;
        do {
            vector.addElement(messageDigest.clone());
            messageDigest.update((byte)0);
        } while ((n3 += n) < n2);
        int n4 = this.salt.length();
        int n5 = this.passPhrase.length();
        byte[] byArray = new byte[n4 + n5];
        if (n4 != 0) {
            System.arraycopy(this.salt.getBytes(), 0, byArray, 0, n4);
        }
        System.arraycopy(this.passPhrase.getBytes(), 0, byArray, n4, n5);
        int n6 = 0;
        int n7 = vector.size();
        do {
            int n8 = 0;
            while (n8 < n7) {
                ((MessageDigest)vector.elementAt(n8)).update(byArray);
                ++n8;
            }
        } while (++n6 < this.iterations);
        byte[] byArray2 = new byte[n2];
        n3 = 0;
        int n9 = 0;
        while (n9 < n7) {
            byte[] byArray3 = ((MessageDigest)vector.elementAt(n9)).digest();
            int n10 = n3 + n > n2 ? n2 - n3 : n;
            System.arraycopy(byArray3, 0, byArray2, n3, n10);
            n3 += n10;
            ++n9;
        }
        rawKeyGenerator.setWeakAllowed(true);
        SecretKey secretKey = null;
        try {
            secretKey = rawKeyGenerator.generateKey(byArray2);
        }
        catch (WeakKeyException weakKeyException) {
            // empty catch block
        }
        Scar.trace(false, "s2k()");
        return secretKey;
    }

    private void notify(String string) {
        Scar.trace(true, "notify()");
        if (this.verbose) {
            System.out.println(string + "...");
        }
        Scar.trace(false, "notify()");
    }

    public void zip(File file, ZipOutputStream zipOutputStream, int n) throws FileNotFoundException, IOException {
        Scar.trace(true, "zip(" + n + ")");
        FileInputStream fileInputStream = null;
        if (file.isFile()) {
            Object object2;
            try {
                ++this.count;
                fileInputStream = new FileInputStream(file);
                object2 = file.getCanonicalPath();
                int n2 = ((String)object2).indexOf(fs);
                if (n2 != -1) {
                    object2 = ((String)object2).substring(n2 + 1);
                }
                object2 = ((String)object2).replace(fs.charAt(0), '/');
                this.notify("\t " + (String)object2);
                zipOutputStream.putNextEntry(new ZipEntry((String)object2));
                while ((n2 = fileInputStream.read(this.buffer)) != -1) {
                    zipOutputStream.write(this.buffer, 0, n2);
                }
            }
            finally {
                Object var6_8 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException object2) {
                        ((Throwable)object2).printStackTrace();
                    }
                }
            }
        }
        if (file.isDirectory() && (n == 0 || n != 0 && this.recursion)) {
            String[] stringArray = file.list(this.filter);
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.zip(new File(file, stringArray[n3]), zipOutputStream, n + 1);
                ++n3;
            }
        }
        Scar.trace(false, "zip(" + n + ")");
    }

    public void unzip(ZipInputStream zipInputStream, File file) throws FileNotFoundException, IOException {
        ZipEntry zipEntry;
        Scar.trace(true, "unzip()");
        OutputStream outputStream = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            try {
                int n;
                String string = zipEntry.getName();
                if (!this.useDirInfo) {
                    n = string.lastIndexOf("/");
                    if (n != -1) {
                        string = string.substring(n + 1);
                    }
                } else {
                    string = string.replace('/', fs.charAt(0));
                }
                String string2 = file.getPath();
                string = string2.endsWith(fs) ? string2 + string : string2 + fs + string;
                this.notify("\t " + string);
                File file2 = new File(string);
                if (this.useDirInfo) {
                    new File(file2.getParent()).mkdirs();
                }
                outputStream = new FileOutputStream(file2);
                while ((n = zipInputStream.read(this.buffer)) != -1) {
                    ((FileOutputStream)outputStream).write(this.buffer, 0, n);
                }
            }
            finally {
                Object var6_5 = null;
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        ((FileOutputStream)outputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        Scar.trace(false, "unzip()");
    }

    private void wipe(File file, int n) {
        Scar.trace(true, "wipe(" + n + ")");
        if (file.isDirectory() && (n == 0 || n != 0 && this.recursion)) {
            String[] stringArray = file.list();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.wipe(new File(file, stringArray[n2]), n + 1);
                ++n2;
            }
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        Scar.trace(false, "wipe(" + n + ")");
    }

    public Scar() {
        Scar.trace(true, "Scar()");
        fs = System.getProperty("file.separator");
        String string = System.getProperty("user.home");
        try {
            String string2 = string + "scar.properties";
            this.properties = new PropertyResourceBundle(new FileInputStream(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Scar.debug("File \"scar.properties\" was not found in " + string + ". Using default properties");
            this.initDefaults();
            Scar.trace(false, "Scar()");
            return;
        }
        catch (IOException iOException) {
            Scar.debug("I/O exception occured while loading \"scar.properties\" file. Using default properties");
            this.initDefaults();
            Scar.trace(false, "Scar()");
            return;
        }
        try {
            this.header = this.properties.getString("scar.header");
        }
        catch (MissingResourceException missingResourceException) {
            this.header = "BEGIN SCAR ARCHIVE";
        }
        try {
            this.footer = this.properties.getString("scar.footer");
        }
        catch (MissingResourceException missingResourceException) {
            this.footer = DEFAULT_FOOTER;
        }
        try {
            this.comment = this.properties.getString("scar.comment");
        }
        catch (MissingResourceException missingResourceException) {
            this.comment = DEFAULT_COMMENT;
        }
        try {
            this.cipherAlgorithm = this.properties.getString("scar.cipher.algorithm");
        }
        catch (MissingResourceException missingResourceException) {
            this.cipherAlgorithm = DEFAULT_CIPHER;
        }
        try {
            this.passPhrase = this.properties.getString("scar.passphrase");
        }
        catch (MissingResourceException missingResourceException) {
            this.passPhrase = DEFAULT_PASS_PHRASE;
        }
        try {
            this.mdAlgorithm = this.properties.getString("scar.md.algorithm");
        }
        catch (MissingResourceException missingResourceException) {
            this.mdAlgorithm = DEFAULT_MD;
        }
        try {
            this.salt = this.properties.getString("scar.md.salt");
        }
        catch (MissingResourceException missingResourceException) {
            this.salt = "BEGIN SCAR ARCHIVE";
        }
        try {
            this.iterations = Integer.parseInt(this.properties.getString("scar.md.iterations"));
        }
        catch (MissingResourceException missingResourceException) {
            this.iterations = 7;
        }
        Scar.debug("Default properties [...");
        Scar.debug("      header line: \"-----" + this.header + "-----\"");
        Scar.debug("     comment line: \"Comment: " + this.comment + "\"");
        Scar.debug("      footer line: \"-----" + this.footer + "-----\"");
        Scar.debug(" cipher algorithm: \"" + this.cipherAlgorithm + "\"");
        Scar.debug("      pass-phrase: \"" + this.passPhrase + "\"");
        Scar.debug("   message digest: \"" + this.mdAlgorithm + "\"");
        Scar.debug("          md salt: \"" + this.salt + "\"");
        Scar.debug("    md iterations: " + this.iterations);
        Scar.debug("...]");
        Scar.trace(false, "Scar()");
    }

    static {
        err = new PrintWriter(System.out, true);
        MAGIC = MAGIC_STRING.getBytes();
        random = new SecureRandom();
        BASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    }

    final class ScarInputStream
    extends FilterInputStream {
        byte[] lineBuffer;
        boolean finished;
        PRZ24 crc;
        byte[] inBuf = new byte[4];
        byte[] outBuf = new byte[3];
        int inOff;
        int outOff;
        int outBufMax;

        public synchronized int read() throws IOException {
            int n;
            Scar.trace(true, "ScarInputStream.read()");
            if (this.outOff == 0) {
                if (this.finished) {
                    return -1;
                }
                n = 0;
                int n2 = -1;
                while (n2 == -1) {
                    n = this.in.read();
                    if (n < 0) {
                        return -1;
                    }
                    n2 = this.toNumber(n);
                }
                if (n2 < 0) {
                    if (n2 == -3) {
                        throw new CharConversionException();
                    }
                    long l = this.crc.getValue();
                    long l2 = 0L;
                    this.crc = null;
                    int n3 = 0;
                    while (n3 < 3) {
                        n = this.read();
                        if (n < 0) {
                            throw new EOFException();
                        }
                        l2 = l2 << 8 | (long)n;
                        ++n3;
                    }
                    this.finished = true;
                    this.outOff = 0;
                    if (l2 != l) {
                        throw new IOException("PRZ24 crc mismatch");
                    }
                    return -1;
                }
                int n4 = 0;
                while (n4 < 4) {
                    if (n2 == -2) {
                        if (n4 < 2) {
                            throw new CharConversionException();
                        }
                    } else {
                        if (n2 < 0) {
                            throw new CharConversionException();
                        }
                        this.inBuf[this.inOff++] = (byte)n2;
                    }
                    if (n4 != 3) {
                        n = this.in.read();
                        if (n < 0) {
                            throw new EOFException();
                        }
                        n2 = this.toNumber(n);
                    }
                    ++n4;
                }
                this.writeTriplet();
            }
            n = this.outBuf[this.outOff++] & 0xFF;
            if (this.outOff == this.outBufMax) {
                this.outOff = 0;
            }
            if (this.crc != null) {
                this.crc.update(n);
            }
            Scar.trace(false, "ScarInputStream.read()");
            return n;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            Scar.trace(true, "ScarInputStream.read(3)");
            Scar.debug("ScarInputStream.read(" + byArray + ", " + n + ", " + n2 + ")");
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.read();
                if (n4 < 0) {
                    return n3 == 0 ? -1 : n3;
                }
                byArray[n++] = (byte)n4;
                ++n3;
            }
            Scar.trace(false, "ScarInputStream.read(3)");
            return n2;
        }

        public synchronized void close() throws IOException {
            String string;
            Scar.trace(true, "ScarInputStream.close()");
            do {
                if ((string = this.readLine()) != null) continue;
                throw new EOFException("Missing scar footer");
            } while (!string.startsWith("-----" + Scar.this.footer + "-----"));
            this.finished = true;
            this.outOff = 0;
            super.close();
            Scar.trace(false, "ScarInputStream.close()");
        }

        private String readLine() throws IOException {
            int n;
            InputStream inputStream = this.in;
            byte[] byArray = this.lineBuffer;
            if (byArray == null) {
                byArray = this.lineBuffer = new byte[128];
            }
            int n2 = byArray.length;
            int n3 = 0;
            block4: while (true) {
                n = inputStream.read();
                switch (n) {
                    case -1: 
                    case 10: {
                        break block4;
                    }
                    case 13: {
                        int n4 = inputStream.read();
                        if (n4 == 10) break block4;
                        if (!(inputStream instanceof PushbackInputStream)) {
                            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
                            this.in = pushbackInputStream;
                            inputStream = pushbackInputStream;
                        }
                        ((PushbackInputStream)inputStream).unread(n4);
                        break block4;
                    }
                    default: {
                        if (--n2 < 0) {
                            byArray = new byte[n3 + 128];
                            n2 = byArray.length - n3 - 1;
                            System.arraycopy(this.lineBuffer, 0, byArray, 0, n3);
                            this.lineBuffer = byArray;
                        }
                        byArray[n3++] = (byte)n;
                        break;
                    }
                }
            }
            if (n == -1 && n3 == 0) {
                return null;
            }
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return new String(byArray2);
        }

        private void writeTriplet() {
            this.outBufMax = 0;
            this.outBuf[this.outBufMax++] = (byte)(this.inBuf[0] << 2 | this.inBuf[1] >>> 4);
            if (this.inOff > 2) {
                this.outBuf[this.outBufMax++] = (byte)(this.inBuf[1] << 4 | this.inBuf[2] >>> 2);
            }
            if (this.inOff > 3) {
                this.outBuf[this.outBufMax++] = (byte)(this.inBuf[2] << 6 | this.inBuf[3]);
            }
            this.inOff = 0;
        }

        private int toNumber(int n) {
            if (n >= 97 & n <= 122) {
                return n - 97 + 26;
            }
            if (n >= 65 & n <= 90) {
                return n - 65;
            }
            if (n >= 48 & n <= 57) {
                return n - 48 + 52;
            }
            if (n == 43) {
                return 62;
            }
            if (n == 47) {
                return 63;
            }
            if (n == 61) {
                return -2;
            }
            if (n == 10 || n == 13 || n == 32 || n == 9) {
                return -1;
            }
            return -3;
        }

        public ScarInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            String string;
            Scar.trace(true, "ScarInputStream()");
            this.outBufMax = 3;
            this.outOff = 0;
            this.inOff = 0;
            this.finished = false;
            this.crc = new PRZ24();
            do {
                if ((string = this.readLine()) != null) continue;
                throw new EOFException("Missing scar header");
            } while (!string.startsWith("-----" + Scar.this.header + "-----"));
            do {
                if ((string = this.readLine()) != null) continue;
                throw new EOFException("Missing scar data");
            } while (string.length() != 0);
            Scar.trace(false, "ScarInputStream()");
        }
    }

    final class ScarOutputStream
    extends FilterOutputStream {
        PRZ24 crc;
        byte[] inBuf;
        int inOff;
        int lineLength;

        public void write(int n) throws IOException {
            this.inBuf[this.inOff++] = (byte)n;
            this.crc.update(n);
            if (this.inOff == 3) {
                this.writeQuadruplet();
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                this.write(byArray[n3 + n]);
                ++n3;
            }
        }

        public void close() throws IOException {
            int n;
            Scar.trace(true, "ScarOutputStream.close()");
            if (this.inOff != 0) {
                n = this.inOff;
                while (n < 3) {
                    this.inBuf[n] = 0;
                    ++n;
                }
                this.writeQuadruplet();
            }
            if (this.lineLength != 0) {
                this.writeln();
            }
            this.out.write(61);
            n = (int)this.crc.getValue();
            this.inBuf[0] = (byte)(n >> 16);
            this.inBuf[1] = (byte)(n >> 8);
            this.inBuf[2] = (byte)n;
            this.inOff = 3;
            this.writeQuadruplet();
            this.writeln();
            this.out.write(new String("-----" + Scar.this.footer + "-----").getBytes());
            this.writeln();
            super.flush();
            super.close();
            Scar.trace(false, "ScarOutputStream.close()");
        }

        private synchronized void writeQuadruplet() throws IOException {
            int n = BASE64[(this.inBuf[0] & 0xFF) >> 2];
            this.out.write(n);
            n = BASE64[(this.inBuf[0] & 3) << 4 | (this.inBuf[1] & 0xFF) >> 4];
            this.out.write(n);
            n = this.inOff > 1 ? BASE64[(this.inBuf[1] & 0xF) << 2 | (this.inBuf[2] & 0xCF) >> 6] : 61;
            this.out.write(n);
            n = this.inOff > 2 ? BASE64[this.inBuf[2] & 0x3F] : 61;
            this.out.write(n);
            this.inOff = 0;
            this.lineLength += 4;
            if (this.lineLength >= 64) {
                this.writeln();
            }
        }

        private void writeln() throws IOException {
            this.out.write(13);
            this.out.write(10);
            this.lineLength = 0;
        }

        public ScarOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
            Scar.trace(true, "ScarOutputStream()");
            this.inBuf = new byte[3];
            this.crc = new PRZ24();
            this.lineLength = 0;
            this.inOff = 0;
            this.out.write(new String("-----" + Scar.this.header + "-----").getBytes());
            this.writeln();
            this.out.write(Scar.VERSION.getBytes());
            this.writeln();
            if (Scar.this.comment.length() != 0) {
                this.out.write(new String("Comment: " + Scar.this.comment).getBytes());
                this.writeln();
            }
            this.writeln();
            Scar.trace(false, "ScarOutputStream()");
        }
    }
}

