/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.Cipher;
import java.security.IJCE;

public class CipherOutputStream
extends FilterOutputStream {
    private static final boolean DEBUG = true;
    private static int debuglevel = IJCE.getDebugLevel("CipherOutputStream");
    private static PrintWriter err = IJCE.getDebugOutput();
    private Cipher cipher;
    private final byte[] preallocated = new byte[256];

    private static void debug(String string) {
        err.println("CipherOutputStream: " + string);
    }

    private static String dump(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return byArray.toString();
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.cipher == null) {
            throw new IOException("stream closed");
        }
        if (n2 <= 0) {
            return;
        }
        int n3 = this.cipher.outBufferSize(n2);
        byte[] byArray2 = n3 <= this.preallocated.length ? this.preallocated : new byte[n3];
        int n4 = this.cipher.update(byArray, n, n2, byArray2, 0);
        if (debuglevel >= 7) {
            CipherOutputStream.debug("  buf = <" + CipherOutputStream.dump(byArray2) + ">, n = " + n4);
        }
        int n5 = 0;
        while (n5 < n4) {
            this.out.write(byArray2[n5]);
            ++n5;
        }
    }

    public synchronized void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public synchronized void flush() throws IOException {
        if (this.cipher == null) {
            throw new IOException("stream closed");
        }
        super.flush();
    }

    public synchronized void close() throws IOException {
        if (this.cipher == null) {
            throw new IOException("stream closed");
        }
        int n = this.cipher.outBufferSizeFinal(0);
        byte[] byArray = n <= this.preallocated.length ? this.preallocated : new byte[n];
        int n2 = this.cipher.crypt(new byte[0], 0, 0, byArray, 0);
        if (debuglevel >= 7) {
            CipherOutputStream.debug("  buf = <" + CipherOutputStream.dump(byArray) + ">, n = " + n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.out.write(byArray[n3]);
            ++n3;
        }
        super.flush();
        if (debuglevel >= 5) {
            CipherOutputStream.debug("flushed stream");
        }
        super.close();
        if (debuglevel >= 5) {
            CipherOutputStream.debug("closed stream");
        }
        this.cipher = null;
    }

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        if (cipher == null) {
            throw new NullPointerException("cipher == null");
        }
        int n = cipher.getState();
        if (n != 1 && n != 2) {
            throw new IllegalStateException("cipher is uninitialized");
        }
        this.cipher = cipher;
    }
}

