/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.math.RandomStream;
import cryptix.pgp.DecryptException;
import cryptix.pgp.FormatException;
import cryptix.pgp.PGPCFB;
import cryptix.pgp.Packet;
import cryptix.security.IDEA;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ConvEncryptedData
extends Packet {
    protected byte[] buffer = null;

    public byte[] getBuffer() {
        return this.buffer;
    }

    private byte[] getKeyCheck(RandomStream randomStream) {
        byte[] byArray = new byte[10];
        int n = 7;
        while (n >= 0) {
            byte by;
            while ((by = (byte)randomStream.read()) == 0) {
            }
            byArray[n] = by;
            --n;
        }
        byArray[8] = byArray[6];
        byArray[9] = byArray[7];
        return byArray;
    }

    public void read(DataInput dataInput, int n) throws IOException {
        if (n <= 11) {
            throw new FormatException("Length too short");
        }
        this.buffer = new byte[n];
        dataInput.readFully(this.buffer);
    }

    public int write(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.buffer);
        return this.buffer.length;
    }

    public byte[] data(byte[] byArray) throws DecryptException {
        IDEA iDEA = new IDEA(byArray);
        PGPCFB pGPCFB = new PGPCFB(iDEA);
        int n = iDEA.blockLength();
        byte[] byArray2 = new byte[this.buffer.length - 10];
        byte[] byArray3 = new byte[10];
        System.arraycopy(this.buffer, 0, byArray3, 0, 10);
        System.arraycopy(this.buffer, 10, byArray2, 0, byArray2.length);
        pGPCFB.decrypt(this.buffer, 0, byArray3, 0, byArray3.length);
        if (byArray3[6] != byArray3[8] || byArray3[7] != byArray3[9]) {
            throw new DecryptException("Invalid decryption key");
        }
        pGPCFB.decrypt(this.buffer, 10, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public int getType() {
        return 9;
    }

    public ConvEncryptedData(DataInput dataInput, int n) throws IOException {
        this.read(dataInput, n);
    }

    public ConvEncryptedData(byte[] byArray, byte[] byArray2, RandomStream randomStream) throws IOException {
        this.buffer = new byte[byArray.length + 10];
        IDEA iDEA = new IDEA(byArray2);
        PGPCFB pGPCFB = new PGPCFB(iDEA);
        byte[] byArray3 = this.getKeyCheck(randomStream);
        int n = iDEA.blockLength();
        pGPCFB.encrypt(byArray3, 0, this.buffer, 0, 10);
        pGPCFB.decrypt(this.buffer, 2, new byte[n], 0, n);
        pGPCFB.encrypt(byArray, 0, this.buffer, 10, byArray.length);
    }
}

